/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.ui.wizards.buildpath.newsourcepage;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.IBuildpathEntry;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IScriptFolder;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.internal.corext.buildpath.BuildpathModifier;
import org.eclipse.dltk.internal.ui.dialogs.StatusInfo;
import org.eclipse.dltk.internal.ui.wizards.NewWizardMessages;
import org.eclipse.dltk.internal.ui.wizards.buildpath.BPListElement;
import org.eclipse.dltk.internal.ui.wizards.buildpath.BuildPathBasePage;
import org.eclipse.dltk.internal.ui.wizards.buildpath.newsourcepage.DialogPackageExplorerActionGroup;
import org.eclipse.dltk.ui.DLTKPluginImages;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ISetSelectionTarget;

public class AddFolderToBuildpathAction
extends Action
implements ISelectionChangedListener {
    private final IWorkbenchSite fSite;
    private final List fSelectedElements;

    public AddFolderToBuildpathAction(IWorkbenchSite site) {
        super(NewWizardMessages.NewSourceContainerWorkbookPage_ToolBar_AddSelSFToCP_label, DLTKPluginImages.DESC_OBJS_PACKFRAG_ROOT);
        this.setToolTipText(NewWizardMessages.NewSourceContainerWorkbookPage_ToolBar_AddSelSFToCP_tooltip);
        this.fSite = site;
        this.fSelectedElements = new ArrayList();
    }

    public void run() {
        IScriptProject project;
        Object object = this.fSelectedElements.get(0);
        if (object instanceof IScriptProject) {
            project = (IScriptProject)object;
        } else if (object instanceof IScriptFolder) {
            project = ((IScriptFolder)object).getScriptProject();
        } else {
            IFolder folder = (IFolder)object;
            project = DLTKCore.create((IProject)folder.getProject());
            if (project == null) {
                return;
            }
        }
        final boolean removeProjectFromBuildpath = this.fSelectedElements.size() == 1 && this.fSelectedElements.get(0) instanceof IScriptProject;
        try {
            IRunnableWithProgress runnable = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        List result = AddFolderToBuildpathAction.this.addToBuildpath(AddFolderToBuildpathAction.this.fSelectedElements, project, removeProjectFromBuildpath, monitor);
                        AddFolderToBuildpathAction.this.selectAndReveal((ISelection)new StructuredSelection(result));
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            };
            PlatformUI.getWorkbench().getProgressService().run(true, false, runnable);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof CoreException) {
                this.showExceptionDialog((CoreException)e.getCause());
            } else {
                DLTKUIPlugin.log(e);
            }
        }
        catch (InterruptedException interruptedException) {}
    }

    private List addToBuildpath(List elements, IScriptProject project, boolean removeProjectFromBuildpath, IProgressMonitor monitor) throws OperationCanceledException, CoreException {
        if (!DLTKLanguageManager.hasScriptNature((IProject)project.getProject())) {
            StatusInfo rootStatus = new StatusInfo();
            rootStatus.setError(NewWizardMessages.BuildpathModifier_Error_NoNatures);
            throw new CoreException((IStatus)rootStatus);
        }
        try {
            monitor.beginTask(NewWizardMessages.BuildpathModifier_Monitor_AddToBuildpath, elements.size() + 4);
            monitor.worked(1);
            List existingEntries = BuildpathModifier.getExistingEntries(project);
            if (removeProjectFromBuildpath) {
                BuildpathModifier.removeFromBuildpath(project, existingEntries, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            } else {
                monitor.worked(1);
            }
            ArrayList<BPListElement> newEntries = new ArrayList<BPListElement>();
            int i = 0;
            while (i < elements.size()) {
                Object element = elements.get(i);
                BPListElement entry = element instanceof IResource ? BuildpathModifier.addToBuildpath((IResource)element, existingEntries, newEntries, project, (IProgressMonitor)new SubProgressMonitor(monitor, 1)) : BuildpathModifier.addToBuildpath((IModelElement)element, existingEntries, newEntries, project, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                newEntries.add(entry);
                ++i;
            }
            HashSet modifiedSourceEntries = new HashSet();
            BuildPathBasePage.fixNestingConflicts(newEntries.toArray(new BPListElement[newEntries.size()]), existingEntries.toArray(new BPListElement[existingEntries.size()]), modifiedSourceEntries);
            BuildpathModifier.setNewEntry(existingEntries, newEntries, project, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            BuildpathModifier.commitBuildPath(existingEntries, project, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            ArrayList<IScriptProject> result = new ArrayList<IScriptProject>();
            int i2 = 0;
            while (i2 < newEntries.size()) {
                IBuildpathEntry entry = ((BPListElement)newEntries.get(i2)).getBuildpathEntry();
                Object root = entry.getPath().equals((Object)project.getPath()) ? project : project.findProjectFragment(entry.getPath());
                if (root != null) {
                    result.add((IScriptProject)root);
                }
                ++i2;
            }
            ArrayList<IScriptProject> arrayList = result;
            return arrayList;
        }
        finally {
            monitor.done();
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        ISelection selection = event.getSelection();
        if (selection instanceof IStructuredSelection) {
            this.setEnabled(this.canHandle((IStructuredSelection)selection));
        } else {
            this.setEnabled(this.canHandle((IStructuredSelection)StructuredSelection.EMPTY));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean canHandle(IStructuredSelection elements) {
        if (elements.size() == 0) {
            return false;
        }
        try {
            this.fSelectedElements.clear();
            Iterator iter = elements.iterator();
            while (true) {
                if (!iter.hasNext()) {
                    return true;
                }
                Object element = iter.next();
                this.fSelectedElements.add(element);
                if (element instanceof IScriptProject) {
                    if (!BuildpathModifier.isSourceFolder((IScriptProject)element)) continue;
                    return false;
                }
                if (element instanceof IScriptFolder) {
                    int type = DialogPackageExplorerActionGroup.getType(element, ((IScriptFolder)element).getScriptProject());
                    if (type == 3 || type == 11) continue;
                    return false;
                }
                if (!(element instanceof IFolder)) {
                    return false;
                }
                IProject project = ((IFolder)element).getProject();
                IScriptProject scriptProject = DLTKCore.create((IProject)project);
                if (scriptProject == null || !scriptProject.exists()) break;
            }
            return false;
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    private void showExceptionDialog(CoreException exception) {
        this.showError(exception, this.fSite.getShell(), NewWizardMessages.AddSourceFolderToBuildpathAction_ErrorTitle, exception.getMessage());
    }

    private void showError(CoreException e, Shell shell, String title, String message) {
        IStatus status = e.getStatus();
        if (status != null) {
            ErrorDialog.openError((Shell)shell, (String)message, (String)title, (IStatus)status);
        } else {
            MessageDialog.openError((Shell)shell, (String)title, (String)message);
        }
    }

    private void selectAndReveal(final ISelection selection) {
        IWorkbenchPage page = this.fSite.getPage();
        if (page == null) {
            return;
        }
        ArrayList<IWorkbenchPart> parts = new ArrayList<IWorkbenchPart>();
        IViewReference[] refs = page.getViewReferences();
        int i = 0;
        while (i < refs.length) {
            IWorkbenchPart part = refs[i].getPart(false);
            if (part != null) {
                parts.add(part);
            }
            ++i;
        }
        refs = page.getEditorReferences();
        i = 0;
        while (i < refs.length) {
            if (refs[i].getPart(false) != null) {
                parts.add(refs[i].getPart(false));
            }
            ++i;
        }
        for (IWorkbenchPart part : parts) {
            ISetSelectionTarget target = null;
            target = part instanceof ISetSelectionTarget ? (ISetSelectionTarget)part : (ISetSelectionTarget)part.getAdapter(ISetSelectionTarget.class);
            if (target == null) continue;
            final ISetSelectionTarget finalTarget = target;
            page.getWorkbenchWindow().getShell().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    finalTarget.selectReveal(selection);
                }
            });
        }
    }
}

