/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.core.tests.model;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IModelElementDelta;
import org.eclipse.dltk.core.IParent;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.IScriptFolder;
import org.eclipse.dltk.core.ISourceManipulation;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.tests.model.ModifyingResourceTests;

public abstract class CopyMoveTests
extends ModifyingResourceTests {
    public CopyMoveTests(String TestProjectName, String name) {
        super(TestProjectName, name);
    }

    public void copyNegative(IModelElement element, IModelElement destination, IModelElement sibling, String rename, boolean force, int failureCode) {
        try {
            ((ISourceManipulation)element).copy(destination, sibling, rename, force, null);
        }
        catch (ModelException jme) {
            CopyMoveTests.assertTrue((String)("Code not correct for ModelException: " + (Object)((Object)jme)), (jme.getStatus().getCode() == failureCode ? 1 : 0) != 0);
            return;
        }
        CopyMoveTests.assertTrue((String)("The copy should have failed for: " + element), (boolean)false);
    }

    public void copyNegative(IModelElement[] elements, IModelElement[] destinations, IModelElement[] siblings, String[] renames, boolean force, int failureCode) {
        try {
            this.getScriptModel().copy(elements, destinations, siblings, renames, force, null);
        }
        catch (ModelException jme) {
            CopyMoveTests.assertTrue((String)("Code not correct for ModelException: " + (Object)((Object)jme)), (jme.getStatus().getCode() == failureCode ? 1 : 0) != 0);
            return;
        }
        CopyMoveTests.assertTrue((String)"The move should have failed for for multiple elements: ", (boolean)false);
    }

    public IModelElement copyPositive(IModelElement element, IModelElement container, IModelElement sibling, String rename, boolean force) throws ModelException {
        IModelElement copy;
        if (force) {
            IModelElement collision = this.generateHandle(element, rename, container);
            CopyMoveTests.assertTrue((String)"Collision does not exist", (boolean)collision.exists());
        }
        try {
            this.startDeltas();
            ((ISourceManipulation)element).copy(container, sibling, rename, force, null);
            CopyMoveTests.assertTrue((String)"The original element must still exist", (boolean)element.exists());
            copy = this.generateHandle(element, rename, container);
            CopyMoveTests.assertTrue((String)"Copy should exist", (boolean)copy.exists());
            if (element.getElementType() > 5) {
                this.ensureCorrectPositioning((IParent)container, sibling, copy);
            } else {
                container.getElementType();
            }
            IModelElementDelta destDelta = this.getDeltaFor(container, true);
            CopyMoveTests.assertTrue((String)"Destination container not changed", (destDelta != null && destDelta.getKind() == 4 ? 1 : 0) != 0);
            IModelElementDelta[] deltas = destDelta.getAddedChildren();
            CopyMoveTests.assertTrue((String)"Added children not correct for element copy", (boolean)deltas[0].getElement().equals(copy));
        }
        finally {
            this.stopDeltas();
        }
        return copy;
    }

    public IModelElement generateHandle(IModelElement original, String rename, IModelElement container) {
        String name = original.getElementName();
        if (rename != null) {
            name = rename;
        }
        switch (container.getElementType()) {
            case 3: {
                switch (original.getElementType()) {
                    case 4: {
                        return ((IProjectFragment)container).getScriptFolder(name);
                    }
                }
                CopyMoveTests.assertTrue((String)"illegal child type", (boolean)false);
                break;
            }
            case 4: {
                switch (original.getElementType()) {
                    case 5: {
                        return ((IScriptFolder)container).getSourceModule(name);
                    }
                }
                CopyMoveTests.assertTrue((String)"illegal child type", (boolean)false);
                break;
            }
            case 5: {
                switch (original.getElementType()) {
                    case 7: {
                        if (this.isMainType(original, container)) {
                            container = ((IScriptFolder)container.getParent()).getSourceModule(String.valueOf(name) + ".java");
                        }
                        return ((ISourceModule)container).getType(name);
                    }
                }
                CopyMoveTests.assertTrue((String)"illegal child type", (boolean)false);
                break;
            }
            case 7: {
                switch (original.getElementType()) {
                    case 9: {
                        if (name.equals(original.getParent().getElementName())) {
                            return ((IType)container).getMethod(container.getElementName());
                        }
                        return ((IType)container).getMethod(name);
                    }
                    case 8: {
                        return ((IType)container).getField(name);
                    }
                    case 7: {
                        return ((IType)container).getType(name);
                    }
                }
                CopyMoveTests.assertTrue((String)"illegal child type", (boolean)false);
                break;
            }
            default: {
                CopyMoveTests.assertTrue((String)"unsupported container type", (boolean)false);
            }
        }
        CopyMoveTests.assertTrue((String)"should not get here", (boolean)false);
        return null;
    }

    protected boolean isMainType(IModelElement element, IModelElement parent) {
        if (parent instanceof ISourceModule && element instanceof IType) {
            ISourceModule cu = (ISourceModule)parent;
            String typeName = cu.getElementName();
            typeName = typeName.substring(0, typeName.length() - 5);
            return element.getElementName().equals(typeName) && element.getParent().equals(cu);
        }
        return false;
    }

    public void moveNegative(IModelElement element, IModelElement destination, IModelElement sibling, String rename, boolean force, int failureCode) {
        try {
            ((ISourceManipulation)element).move(destination, sibling, rename, force, null);
        }
        catch (ModelException jme) {
            CopyMoveTests.assertTrue((String)("Code not correct for ModelException: " + (Object)((Object)jme)), (jme.getStatus().getCode() == failureCode ? 1 : 0) != 0);
            return;
        }
        CopyMoveTests.assertTrue((String)("The move should have failed for: " + element), (boolean)false);
    }

    public void moveNegative(IModelElement[] elements, IModelElement[] destinations, IModelElement[] siblings, String[] renames, boolean force, int failureCode) {
        try {
            this.getScriptModel().move(elements, destinations, siblings, renames, force, null);
        }
        catch (ModelException jme) {
            CopyMoveTests.assertTrue((String)("Code not correct for ModelException: " + (Object)((Object)jme)), (jme.getStatus().getCode() == failureCode ? 1 : 0) != 0);
            return;
        }
        CopyMoveTests.assertTrue((String)"The move should have failed for for multiple elements: ", (boolean)false);
    }

    public void movePositive(IModelElement element, IModelElement container, IModelElement sibling, String rename, boolean force) throws ModelException {
        IModelElement[] siblings = new IModelElement[]{sibling};
        String[] renamings = new String[]{rename};
        if (sibling == null) {
            siblings = null;
        }
        if (rename == null) {
            renamings = null;
        }
        this.movePositive(new IModelElement[]{element}, new IModelElement[]{container}, siblings, renamings, force);
    }

    public void movePositive(IModelElement[] elements, IModelElement[] destinations, IModelElement[] siblings, String[] names, boolean force) throws ModelException {
        this.movePositive(elements, destinations, siblings, names, force, null);
    }

    /*
     * Unable to fully structure code
     */
    public void movePositive(IModelElement[] elements, IModelElement[] destinations, IModelElement[] siblings, String[] names, boolean force, IProgressMonitor monitor) throws ModelException {
        if (force) {
            i = 0;
            while (i < elements.length) {
                e = elements[i];
                collision = null;
                collision = names == null ? this.generateHandle(e, null, destinations[i]) : this.generateHandle(e, names[i], destinations[i]);
                CopyMoveTests.assertTrue((String)"Collision does not exist", (boolean)collision.exists());
                ++i;
            }
        }
        try {
            this.startDeltas();
            this.getScriptModel().move(elements, destinations, siblings, names, force, monitor);
            i = 0;
            while (i < elements.length) {
                element = elements[i];
                moved = null;
                moved = names == null ? this.generateHandle(element, null, destinations[i]) : this.generateHandle(element, names[i], destinations[i]);
                if (!destinations[i].equals(element.getParent())) {
                    if (element.getElementType() == 4) {
                        try {
                            members = ((IContainer)element.getUnderlyingResource()).members();
                            if (members.length != 0) ** GOTO lbl28
                            CopyMoveTests.assertTrue((String)"The original element must not exist", (boolean)(element.exists() == false));
                        }
                        catch (CoreException ce) {
                            throw new ModelException(ce);
                        }
                    } else {
                        CopyMoveTests.assertTrue((String)"The original element must not exist", (boolean)(element.exists() == false));
                    }
                }
lbl28:
                // 5 sources

                CopyMoveTests.assertTrue((String)"Moved element should exist", (boolean)moved.exists());
                if (element.getElementType() > 5) {
                    if (siblings != null && siblings.length > 0) {
                        this.ensureCorrectPositioning((IParent)moved.getParent(), siblings[i], moved);
                    }
                } else {
                    container = destinations[i];
                    container.getElementType();
                }
                destDelta = null;
                if (this.isMainType(element, destinations[i]) && names != null && names[i] != null) {
                    destDelta = this.getDeltaFor(moved.getParent());
                    CopyMoveTests.assertTrue((String)"Renamed compilation unit as result of main type not added", (boolean)(destDelta != null && destDelta.getKind() == 1));
                    CopyMoveTests.assertTrue((String)"flag should be F_MOVED_FROM", (boolean)((destDelta.getFlags() & 16) > 0));
                    CopyMoveTests.assertTrue((String)"moved from handle should be original", (boolean)destDelta.getMovedFromElement().equals(element.getParent()));
                } else {
                    destDelta = this.getDeltaFor(destinations[i], true);
                    CopyMoveTests.assertTrue((String)"Destination container not changed", (boolean)(destDelta != null && destDelta.getKind() == 4));
                    deltas = destDelta.getAddedChildren();
                    CopyMoveTests.assertTrue((String)"Added children not correct for element copy", (boolean)deltas[i].getElement().equals(moved));
                    CopyMoveTests.assertTrue((String)"should be K_ADDED", (boolean)(deltas[i].getKind() == 1));
                    sourceDelta = this.getDeltaFor(element, false);
                    CopyMoveTests.assertTrue((String)"should be K_REMOVED", (boolean)(sourceDelta.getKind() == 2));
                }
                ++i;
            }
        }
        finally {
            this.stopDeltas();
        }
    }
}

