/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ruby.internal.parser;

import org.eclipse.dltk.compiler.task.ITodoTaskPreferences;
import org.eclipse.dltk.compiler.task.TodoTaskPreferencesOnPreferenceLookupDelegate;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.builder.AbstractTodoTaskBuildParticipantType;
import org.eclipse.dltk.core.builder.IBuildParticipant;

public class RubyTodoParserType
extends AbstractTodoTaskBuildParticipantType {
    protected ITodoTaskPreferences getPreferences(IScriptProject project) {
        return new TodoTaskPreferencesOnPreferenceLookupDelegate("org.eclipse.dltk.ruby.core", project);
    }

    protected IBuildParticipant getBuildParticipant(ITodoTaskPreferences preferences) {
        return new RubyTodoTaskParser(preferences);
    }

    private static class RubyTodoTaskParser
    extends AbstractTodoTaskBuildParticipantType.TodoTaskBuildParticipant {
        private boolean blockMode;

        public RubyTodoTaskParser(ITodoTaskPreferences preferences) {
            super(preferences);
        }

        protected void reset() {
            super.reset();
            this.blockMode = false;
        }

        protected int findCommentStart(char[] content, int begin, int end) {
            if (this.blockMode) {
                if (this.checkChars(content, begin, end, "=end")) {
                    this.blockMode = false;
                    return -1;
                }
                int i = begin;
                while (i < end) {
                    if (Character.isLetterOrDigit(content[i]) && (!this.isCheckRanges() || this.isValid(i))) {
                        return i;
                    }
                    ++i;
                }
                return -1;
            }
            if (this.checkChars(content, begin, end, "=begin")) {
                this.blockMode = true;
                return -1;
            }
            return super.findCommentStart(content, begin, end);
        }

        private boolean checkChars(char[] content, int begin, int end, String substring) {
            if (begin + substring.length() <= end) {
                int i = 0;
                while (i < substring.length()) {
                    if (content[begin + i] != substring.charAt(i)) {
                        return false;
                    }
                    ++i;
                }
            }
            return true;
        }
    }
}

