/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.internal.ui.text.completion;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.dltk.codeassist.ICompletionEngine;
import org.eclipse.dltk.core.CompletionRequestor;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.keyword.IKeywordCategory;
import org.eclipse.dltk.javascript.core.JSKeywordCategory;
import org.eclipse.dltk.javascript.core.JSKeywordManager;
import org.eclipse.dltk.javascript.internal.core.codeassist.JSCompletionEngine;
import org.eclipse.dltk.javascript.internal.ui.templates.JSDocTemplateCompletionProcessor;
import org.eclipse.dltk.javascript.internal.ui.text.completion.JavaScriptCompletionProposalCollector;
import org.eclipse.dltk.javascript.parser.jsdoc.JSDocTag;
import org.eclipse.dltk.javascript.typeinfo.TypeMode;
import org.eclipse.dltk.ui.DLTKPluginImages;
import org.eclipse.dltk.ui.templates.ScriptTemplateProposal;
import org.eclipse.dltk.ui.text.completion.ContentAssistInvocationContext;
import org.eclipse.dltk.ui.text.completion.IScriptCompletionProposalComputer;
import org.eclipse.dltk.ui.text.completion.ScriptCompletionProposal;
import org.eclipse.dltk.ui.text.completion.ScriptContentAssistInvocationContext;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSDocCompletionProposalComputer
implements IScriptCompletionProposalComputer {
    public void sessionStarted() {
    }

    public void sessionEnded() {
    }

    public List<ICompletionProposal> computeCompletionProposals(ContentAssistInvocationContext context, IProgressMonitor monitor) {
        IDocument document = context.getDocument();
        try {
            int invocationLineIndex;
            IRegion line = document.getLineInformationOfOffset(context.getInvocationOffset());
            String doc = document.get(line.getOffset(), line.getLength());
            int index = invocationLineIndex = context.getInvocationOffset() - line.getOffset();
            int prefixIndex = -1;
            String prefix = null;
            String tag = null;
            boolean bracketFound = false;
            boolean skipNoneIdentifiers = false;
            while (--index > 0) {
                char ch = doc.charAt(index);
                if (!Character.isJavaIdentifierPart(ch)) {
                    if (skipNoneIdentifiers) continue;
                    if (ch == '@') {
                        tag = doc.substring(index, prefixIndex == -1 ? invocationLineIndex : prefixIndex);
                        break;
                    }
                    if (prefixIndex != -1 || ch == '}') {
                        return Collections.emptyList();
                    }
                    if (ch == '{') {
                        prefixIndex = index + 1;
                        prefix = doc.substring(prefixIndex, invocationLineIndex);
                        bracketFound = true;
                        skipNoneIdentifiers = true;
                        continue;
                    }
                    prefix = doc.substring(index, invocationLineIndex);
                    prefixIndex = index;
                    continue;
                }
                skipNoneIdentifiers = false;
            }
            if (prefixIndex == -1) {
                if (tag != null) {
                    ArrayList<ICompletionProposal> proposals = new ArrayList<ICompletionProposal>();
                    JSDocTemplateCompletionProcessor processor = new JSDocTemplateCompletionProcessor((ScriptContentAssistInvocationContext)context);
                    Collections.addAll(proposals, processor.computeCompletionProposals(context.getViewer(), context.getInvocationOffset()));
                    HashSet tags = new HashSet();
                    Collections.addAll(tags, JSDocTag.getTags());
                    ISourceModule module = null;
                    Collections.addAll(tags, JSKeywordManager.getInstance().getKeywords((IKeywordCategory)JSKeywordCategory.JS_DOC_TAG, module));
                    tags.remove("@returns");
                    HashSet<String> usedTags = new HashSet<String>();
                    for (ICompletionProposal proposal : proposals) {
                        if (!(proposal instanceof ScriptTemplateProposal)) continue;
                        usedTags.add(((ScriptTemplateProposal)proposal).getTemplateName());
                    }
                    for (String jsdocTag : tags) {
                        if (!jsdocTag.startsWith(tag) || usedTags.contains(jsdocTag)) continue;
                        proposals.add((ICompletionProposal)new ScriptCompletionProposal(String.valueOf(jsdocTag) + ' ', context.getInvocationOffset() - tag.length(), tag.length(), DLTKPluginImages.get((String)"org.eclipse.dltk.ui.jdoc_tag_obj.gif"), jsdocTag, 90, true));
                    }
                    return proposals;
                }
            } else if (bracketFound || "@type".equals(tag)) {
                return this.generateTypes(context, prefix);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return Collections.emptyList();
    }

    private List<ICompletionProposal> generateTypes(ContentAssistInvocationContext context, String prefix) {
        JSCompletionEngine engine;
        if (context instanceof ScriptContentAssistInvocationContext && (engine = this.getCompletionEngine()) != null) {
            ISourceModule module = ((ScriptContentAssistInvocationContext)context).getSourceModule();
            JavaScriptCompletionProposalCollector collector = new JavaScriptCompletionProposalCollector(module);
            engine.setRequestor((CompletionRequestor)collector);
            engine.completeTypes(module, TypeMode.JSDOC, prefix.trim(), context.getInvocationOffset());
            return Arrays.asList(collector.getScriptCompletionProposals());
        }
        return Collections.emptyList();
    }

    private JSCompletionEngine getCompletionEngine() {
        ICompletionEngine[] engines = DLTKLanguageManager.getCompletionEngines((String)"org.eclipse.dltk.javascript.core.nature");
        if (engines != null) {
            ICompletionEngine[] iCompletionEngineArray = engines;
            int n = engines.length;
            int n2 = 0;
            while (n2 < n) {
                ICompletionEngine engine = iCompletionEngineArray[n2];
                if (engine instanceof JSCompletionEngine) {
                    return (JSCompletionEngine)engine;
                }
                ++n2;
            }
        }
        return null;
    }

    public List<IContextInformation> computeContextInformation(ContentAssistInvocationContext context, IProgressMonitor monitor) {
        return Collections.emptyList();
    }

    public String getErrorMessage() {
        return null;
    }
}

