/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.core.environment;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.environment.IEnvironment;
import org.eclipse.dltk.core.environment.IEnvironmentChangedListener;
import org.eclipse.dltk.core.environment.IEnvironmentLocationResolver;
import org.eclipse.dltk.core.environment.IEnvironmentProvider;
import org.eclipse.dltk.core.environment.Messages;
import org.eclipse.dltk.internal.core.BuildpathValidation;
import org.eclipse.dltk.internal.core.ModelManager;
import org.eclipse.dltk.internal.core.ScriptProject;
import org.eclipse.dltk.utils.ExecutableOperation;
import org.eclipse.dltk.utils.ExecutionContexts;
import org.eclipse.dltk.utils.LazyExtensionManager;
import org.eclipse.osgi.util.NLS;

public final class EnvironmentManager {
    private static final QualifiedName PROJECT_ENVIRONMENT = new QualifiedName("org.eclipse.dltk.core", "environment");
    private static final String ENVIRONMENT_EXTENSION = "org.eclipse.dltk.core.environment";
    private static final EnvironmentProviderManager manager = new EnvironmentProviderManager();
    private static ListenerList listeners = new ListenerList();
    private static final Map<IProject, IEnvironment> environmentCache = new HashMap<IProject, IEnvironment>();
    private static IResourceChangeListener resourceListener = new IResourceChangeListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void resourceChanged(IResourceChangeEvent event) {
            int eventType = event.getType();
            IResource resource = event.getResource();
            switch (eventType) {
                case 4: {
                    if (resource.getType() == 4) {
                        Map map = environmentCache;
                        synchronized (map) {
                            environmentCache.remove(resource);
                        }
                    }
                    return;
                }
            }
        }
    };
    private static LocationResolverManager resolverManager = null;

    private EnvironmentManager() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener(resourceListener);
    }

    public static IEnvironmentProvider getEnvironmentProvider(String providerId) {
        if (providerId != null) {
            LazyExtensionManager.Descriptor<E>[] descriptorArray = manager.getDescriptors();
            int n = descriptorArray.length;
            int n2 = 0;
            while (n2 < n) {
                LazyExtensionManager.Descriptor descriptor = descriptorArray[n2];
                EnvironmentProviderManager.EnvironmentProviderDesc desc = (EnvironmentProviderManager.EnvironmentProviderDesc)descriptor;
                if (providerId.equals(desc.getId())) {
                    return (IEnvironmentProvider)desc.get();
                }
                ++n2;
            }
        }
        return null;
    }

    public static IEnvironment getEnvironment(IModelElement element) {
        IScriptProject scriptProject;
        URI locationURI;
        if (element == null) {
            return null;
        }
        IResource res = element.getResource();
        if (res != null && res.getType() != 4 && (locationURI = res.getLocationURI()) != null) {
            for (IEnvironmentProvider provider : manager) {
                EnvironmentManager.waitInitialized(provider);
                IEnvironment env = provider.getEnvironment(locationURI);
                if (env == null) continue;
                return env;
            }
        }
        if ((scriptProject = element.getScriptProject()) == null) {
            return null;
        }
        IProject project = scriptProject.getProject();
        if (project == null) {
            return null;
        }
        return EnvironmentManager.getEnvironment(project);
    }

    public static IEnvironment getEnvironment(IResource element) {
        IProject project;
        URI locationURI;
        if (element == null) {
            return null;
        }
        if (element.getType() != 4 && (locationURI = element.getLocationURI()) != null) {
            for (IEnvironmentProvider provider : manager) {
                EnvironmentManager.waitInitialized(provider);
                IEnvironment env = provider.getEnvironment(locationURI);
                if (env == null) continue;
                return env;
            }
        }
        if ((project = element.getProject()) == null) {
            return null;
        }
        return EnvironmentManager.getEnvironment(project);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IEnvironment getEnvironment(IProject project) {
        Map<IProject, IEnvironment> map = environmentCache;
        synchronized (map) {
            IEnvironment environment = environmentCache.get(project);
            if (environment == null) {
                block9: {
                    if (!" ".equals(project.getName())) {
                        try {
                            String environmentId = project.getPersistentProperty(PROJECT_ENVIRONMENT);
                            if (environmentId != null) {
                                environment = EnvironmentManager.getEnvironmentById(environmentId);
                            }
                        }
                        catch (CoreException e) {
                            if (!DLTKCore.DEBUG) break block9;
                            e.printStackTrace();
                        }
                    }
                }
                if (environment == null) {
                    environment = EnvironmentManager.detectEnvironment(project);
                }
                environmentCache.put(project, environment);
            }
            return environment;
        }
    }

    public static IEnvironment detectEnvironment(IProject project) {
        for (IEnvironmentProvider provider : manager) {
            EnvironmentManager.waitInitialized(provider);
            IEnvironment environment = provider.getProjectEnvironment(project);
            if (environment == null) continue;
            return environment;
        }
        return null;
    }

    public static String getEnvironmentId(IProject project) {
        return EnvironmentManager.getEnvironmentId(project, true);
    }

    public static String getEnvironmentId(IProject project, boolean detectAutomatically) {
        block4: {
            try {
                String environmentId = project.getPersistentProperty(PROJECT_ENVIRONMENT);
                if (environmentId != null) {
                    EnvironmentManager.verifyEnvironmentCache(project, environmentId);
                    return environmentId;
                }
            }
            catch (CoreException e) {
                if (!DLTKCore.DEBUG) break block4;
                e.printStackTrace();
            }
        }
        if (detectAutomatically) {
            IEnvironment environment = EnvironmentManager.detectEnvironment(project);
            return environment != null ? environment.getId() : null;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void verifyEnvironmentCache(IProject project, String environmentId) {
        if (environmentId != null) {
            Map<IProject, IEnvironment> map = environmentCache;
            synchronized (map) {
                IEnvironment environment = environmentCache.get(project);
                if (environment != null && !environmentId.equals(environment.getId())) {
                    environmentCache.remove(project);
                }
            }
        }
    }

    public static void setEnvironmentId(IProject project, String environmentId) throws CoreException {
        EnvironmentManager.setEnvironmentId(project, environmentId, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setEnvironmentId(IProject project, String environmentId, boolean refresh) throws CoreException {
        IScriptProject scriptProject;
        Map<IProject, IEnvironment> map = environmentCache;
        synchronized (map) {
            environmentCache.remove(project);
        }
        project.setPersistentProperty(PROJECT_ENVIRONMENT, environmentId);
        if (refresh && (scriptProject = DLTKCore.create(project)) != null) {
            DLTKCore.refreshBuildpathContainers(scriptProject);
            new BuildpathValidation((ScriptProject)scriptProject).validate();
        }
    }

    public static void refreshBuildpathContainersForMixedProjects(IProgressMonitor monitor) {
        try {
            try {
                SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                IScriptProject[] projects = ModelManager.getModelManager().getModel().getScriptProjects();
                subMonitor.worked(10);
                subMonitor = subMonitor.newChild(90);
                subMonitor.beginTask("", projects.length);
                int i = 0;
                while (i < projects.length) {
                    IProject project = projects[i].getProject();
                    SubMonitor projectMonitor = subMonitor.newChild(1);
                    projectMonitor.beginTask(NLS.bind((String)Messages.EnvironmentManager_RefreshProjectInterpreter, (Object)project.getName()), 2);
                    String environmentId = project.getPersistentProperty(PROJECT_ENVIRONMENT);
                    if (environmentId != null) {
                        EnvironmentManager.verifyEnvironmentCache(project, environmentId);
                        DLTKCore.refreshBuildpathContainers(projects[i]);
                        projectMonitor.worked(1);
                        new BuildpathValidation((ScriptProject)projects[i]).validate();
                        projectMonitor.worked(1);
                    }
                    ++i;
                }
            }
            catch (ModelException e) {
                if (DLTKCore.DEBUG) {
                    e.printStackTrace();
                }
                monitor.done();
            }
            catch (CoreException e) {
                block11: {
                    if (!DLTKCore.DEBUG) break block11;
                    e.printStackTrace();
                }
                monitor.done();
            }
        }
        finally {
            monitor.done();
        }
    }

    public static void setEnvironment(IProject project, IEnvironment environment) throws CoreException {
        EnvironmentManager.setEnvironmentId(project, environment != null ? environment.getId() : null);
    }

    public static IEnvironment[] getEnvironments() {
        return EnvironmentManager.getEnvironments(true);
    }

    public static IEnvironment[] getEnvironments(boolean allowWait) {
        ArrayList<IEnvironment> envList = new ArrayList<IEnvironment>();
        for (IEnvironmentProvider provider : manager) {
            if (allowWait) {
                EnvironmentManager.waitInitialized(provider);
            }
            envList.addAll(Arrays.asList(provider.getEnvironments()));
        }
        IEnvironment[] environments = new IEnvironment[envList.size()];
        envList.toArray(environments);
        return environments;
    }

    public static boolean isLocal(IEnvironment env) {
        return "org.eclipse.dltk.core.environment.localEnvironment".equals(env.getId());
    }

    public static IEnvironment getEnvironmentById(String envId) {
        for (IEnvironmentProvider provider : manager) {
            EnvironmentManager.waitInitialized(provider);
            IEnvironment env = provider.getEnvironment(envId);
            if (env == null) continue;
            return env;
        }
        return null;
    }

    public static void addEnvironmentChangedListener(IEnvironmentChangedListener listener) {
        listeners.add((Object)listener);
    }

    public static void removeEnvironmentChangedListener(IEnvironmentChangedListener listener) {
        listeners.remove((Object)listener);
    }

    public static void environmentAdded(IEnvironment environment) {
        Object[] environmentListeners = listeners.getListeners();
        int i = 0;
        while (i < environmentListeners.length) {
            IEnvironmentChangedListener listener = (IEnvironmentChangedListener)environmentListeners[i];
            listener.environmentAdded(environment);
            ++i;
        }
        EnvironmentManager.fireEnvirontmentChange();
    }

    public static void environmentRemoved(IEnvironment environment) {
        Object[] environmentListeners = listeners.getListeners();
        int i = 0;
        while (i < environmentListeners.length) {
            IEnvironmentChangedListener listener = (IEnvironmentChangedListener)environmentListeners[i];
            listener.environmentRemoved(environment);
            ++i;
        }
        EnvironmentManager.fireEnvirontmentChange();
    }

    public static void environmentChanged(IEnvironment environment) {
        Object[] environmentListeners = listeners.getListeners();
        int i = 0;
        while (i < environmentListeners.length) {
            IEnvironmentChangedListener listener = (IEnvironmentChangedListener)environmentListeners[i];
            listener.environmentChanged(environment);
            ++i;
        }
        EnvironmentManager.fireEnvirontmentChange();
    }

    public static void fireEnvirontmentChange() {
        Object[] environmentListeners = listeners.getListeners();
        int i = 0;
        while (i < environmentListeners.length) {
            IEnvironmentChangedListener listener = (IEnvironmentChangedListener)environmentListeners[i];
            listener.environmentsModified();
            ++i;
        }
    }

    public static IEnvironment getLocalEnvironment() {
        return EnvironmentManager.getEnvironmentById("org.eclipse.dltk.core.environment.localEnvironment");
    }

    public static boolean isInitialized() {
        for (IEnvironmentProvider provider : manager) {
            if (provider.isInitialized()) continue;
            return false;
        }
        return true;
    }

    private static void waitInitialized(final IEnvironmentProvider provider) {
        if (provider.isInitialized()) {
            return;
        }
        ExecutionContexts.getManager().executeInBackground(new ExecutableOperation(Messages.EnvironmentManager_initializingOperationName){

            public void execute(IProgressMonitor monitor) {
                monitor.beginTask("", 1);
                monitor.setTaskName(NLS.bind((String)Messages.EnvironmentManager_initializingTaskName, (Object)provider.getProviderName()));
                provider.waitInitialized();
                monitor.worked(1);
                monitor.done();
            }
        });
    }

    public static void waitInitialized() {
        EnvironmentManager.waitInitialized(null);
    }

    public static void waitInitialized(IProgressMonitor monitor) {
        if (monitor != null) {
            monitor.beginTask("", manager.getDescriptors().length);
        }
        for (IEnvironmentProvider provider : manager) {
            if (monitor != null) {
                monitor.setTaskName(NLS.bind((String)Messages.EnvironmentManager_initializingTaskName, (Object)provider.getProviderName()));
            }
            provider.waitInitialized();
            if (monitor == null) continue;
            monitor.worked(1);
        }
        if (monitor != null) {
            monitor.done();
        }
    }

    public static URI[] resolve(URI location) {
        if (resolverManager == null) {
            resolverManager = new LocationResolverManager();
        }
        ArrayList<URI> result = new ArrayList<URI>();
        for (IEnvironmentLocationResolver resolver : resolverManager) {
            URI[] resolved = resolver.resolve(location);
            if (resolved.length == 0) continue;
            result.addAll(Arrays.asList(resolved));
        }
        return result.toArray(new URI[result.size()]);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EnvironmentProviderManager
    extends LazyExtensionManager<IEnvironmentProvider> {
        public EnvironmentProviderManager() {
            super(EnvironmentManager.ENVIRONMENT_EXTENSION);
        }

        @Override
        protected LazyExtensionManager.Descriptor<IEnvironmentProvider> createDescriptor(IConfigurationElement confElement) {
            return new EnvironmentProviderDesc(this, confElement);
        }

        @Override
        protected void initializeDescriptors(List<LazyExtensionManager.Descriptor<IEnvironmentProvider>> descriptors) {
            Collections.sort(descriptors, new Comparator<LazyExtensionManager.Descriptor<IEnvironmentProvider>>(){

                @Override
                public int compare(LazyExtensionManager.Descriptor<IEnvironmentProvider> arg0, LazyExtensionManager.Descriptor<IEnvironmentProvider> arg1) {
                    EnvironmentProviderDesc d1 = (EnvironmentProviderDesc)arg0;
                    EnvironmentProviderDesc d2 = (EnvironmentProviderDesc)arg1;
                    return d1.priority - d2.priority;
                }
            });
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static class EnvironmentProviderDesc
        extends LazyExtensionManager.Descriptor<IEnvironmentProvider> {
            private String id;
            private int priority;

            public EnvironmentProviderDesc(EnvironmentProviderManager manager, IConfigurationElement configurationElement) {
                super(manager, configurationElement);
                this.priority = EnvironmentProviderDesc.parseInt(configurationElement.getAttribute("priority"));
                this.id = configurationElement.getAttribute("id");
            }

            public String getId() {
                return this.id;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LocationResolverManager
    extends LazyExtensionManager<IEnvironmentLocationResolver> {
        private static final String LOCATION_RESOLVER_EXTENSION = "org.eclipse.dltk.core.locationResolver";

        public LocationResolverManager() {
            super(LOCATION_RESOLVER_EXTENSION);
        }

        @Override
        protected LazyExtensionManager.Descriptor<IEnvironmentLocationResolver> createDescriptor(IConfigurationElement confElement) {
            return new Desc(this, confElement);
        }

        @Override
        protected void initializeDescriptors(List<LazyExtensionManager.Descriptor<IEnvironmentLocationResolver>> descriptors) {
            Collections.sort(descriptors, new Comparator<LazyExtensionManager.Descriptor<IEnvironmentLocationResolver>>(){

                @Override
                public int compare(LazyExtensionManager.Descriptor<IEnvironmentLocationResolver> arg0, LazyExtensionManager.Descriptor<IEnvironmentLocationResolver> arg1) {
                    Desc d1 = (Desc)arg0;
                    Desc d2 = (Desc)arg1;
                    return d1.priority - d2.priority;
                }
            });
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static class Desc
        extends LazyExtensionManager.Descriptor<IEnvironmentLocationResolver> {
            private int priority;

            public Desc(LocationResolverManager manager, IConfigurationElement configurationElement) {
                super(manager, configurationElement);
                this.priority = Desc.parseInt(configurationElement.getAttribute("priority"));
            }
        }
    }
}

