/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.core.model.binary;

import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.INamespace;
import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.SourceRange;
import org.eclipse.dltk.core.WorkingCopyOwner;
import org.eclipse.dltk.core.model.binary.BinaryMemberInfo;
import org.eclipse.dltk.core.model.binary.ISourceMapperProvider;
import org.eclipse.dltk.core.model.binary.SourceMapper;
import org.eclipse.dltk.internal.core.MementoModelElementUtil;
import org.eclipse.dltk.internal.core.ModelElement;
import org.eclipse.dltk.internal.core.NamedMember;
import org.eclipse.dltk.internal.core.util.MementoTokenizer;

public abstract class BinaryMember
extends NamedMember
implements ISourceMapperProvider {
    public BinaryMember(ModelElement parent, String name) {
        super(parent, name);
    }

    public boolean exists() {
        return true;
    }

    protected char getHandleMementoDelimiter() {
        return '}';
    }

    public ISourceRange getSourceRange() throws ModelException {
        SourceMapper mapper = this.getSourceMapper();
        if (mapper != null) {
            return mapper.getSourceRange(this);
        }
        return new SourceRange(0, 0);
    }

    public ISourceRange getNameRange() throws ModelException {
        SourceMapper mapper = this.getSourceMapper();
        if (mapper != null) {
            return mapper.getNameRange(this);
        }
        return new SourceRange(0, 0);
    }

    public SourceMapper getSourceMapper() {
        IModelElement parent = this.getParent();
        if (parent instanceof ISourceMapperProvider) {
            return ((ISourceMapperProvider)((Object)parent)).getSourceMapper();
        }
        return null;
    }

    public int getFlags() throws ModelException {
        return ((BinaryMemberInfo)this.getElementInfo()).getFlags();
    }

    public INamespace getNamespace() throws ModelException {
        return ((BinaryMemberInfo)this.getElementInfo()).getNamespace();
    }

    public IModelElement getHandleFromMemento(String token, MementoTokenizer memento, WorkingCopyOwner workingCopyOwner) {
        switch (token.charAt(0)) {
            case '}': {
                return MementoModelElementUtil.getHandleFromMemento(memento, this, workingCopyOwner);
            }
        }
        return null;
    }
}

