/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core.search.matching;

import org.eclipse.dltk.compiler.CharOperation;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.search.SearchPattern;
import org.eclipse.dltk.core.search.indexing.IIndexConstants;
import org.eclipse.dltk.internal.core.search.matching.PackageDeclarationPattern;
import org.eclipse.dltk.internal.core.search.matching.TypeDeclarationPattern;

public class QualifiedTypeDeclarationPattern
extends TypeDeclarationPattern
implements IIndexConstants {
    public char[] qualification;
    private PackageDeclarationPattern packagePattern;

    public QualifiedTypeDeclarationPattern(char[] qualification, char[] simpleName, char typeSuffix, int matchRule, IDLTKLanguageToolkit toolkit) {
        this(matchRule, toolkit);
        this.qualification = this.isCaseSensitive() ? qualification : CharOperation.toLowerCase(qualification);
        this.simpleName = this.isCaseSensitive() || this.isCamelCase() ? simpleName : CharOperation.toLowerCase(simpleName);
        this.typeSuffix = typeSuffix;
    }

    public QualifiedTypeDeclarationPattern(char[] qualification, int qualificationMatchRule, char[] simpleName, char typeSuffix, int matchRule, IDLTKLanguageToolkit toolkit) {
        this(qualification, simpleName, typeSuffix, matchRule, toolkit);
        this.packagePattern = new PackageDeclarationPattern(qualification, qualificationMatchRule, toolkit);
    }

    QualifiedTypeDeclarationPattern(int matchRule, IDLTKLanguageToolkit toolkit) {
        super(matchRule, toolkit);
    }

    public void decodeIndexKey(char[] key) {
        super.decodeIndexKey(key);
        this.qualification = CharOperation.concatWith(this.pkg, this.enclosingTypeNames, '$');
    }

    public SearchPattern getBlankPattern() {
        return new QualifiedTypeDeclarationPattern(8, this.getToolkit());
    }

    public boolean matchesDecodedKey(SearchPattern decodedPattern) {
        QualifiedTypeDeclarationPattern pattern = (QualifiedTypeDeclarationPattern)decodedPattern;
        block0 : switch (this.typeSuffix) {
            case 'C': {
                switch (pattern.typeSuffix) {
                    case 'C': {
                        break block0;
                    }
                }
                return false;
            }
            case 'A': {
                if (this.typeSuffix == pattern.typeSuffix) break;
                return false;
            }
        }
        boolean matchesName = this.matchesName(this.simpleName, pattern.simpleName);
        if (matchesName) {
            if (this.qualification != null) {
                if (this.packagePattern != null) {
                    return this.packagePattern.matchesName(this.qualification, pattern.qualification);
                }
                return pattern.matchesName(this.qualification, pattern.qualification);
            }
            return true;
        }
        return false;
    }

    protected StringBuffer print(StringBuffer output) {
        switch (this.typeSuffix) {
            case 'C': {
                output.append("ClassDeclarationPattern: qualification<");
                break;
            }
            case 'A': {
                output.append("AnnotationTypeDeclarationPattern: qualification<");
                break;
            }
            default: {
                output.append("TypeDeclarationPattern: qualification<");
            }
        }
        if (this.qualification != null) {
            output.append(this.qualification);
        } else {
            output.append("*");
        }
        output.append(">, type<");
        if (this.simpleName != null) {
            output.append(this.simpleName);
        } else {
            output.append("*");
        }
        output.append("> ");
        return super.print(output);
    }
}

