/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.formatter.internal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.dltk.formatter.IFormatterContext;
import org.eclipse.dltk.formatter.IFormatterDocument;
import org.eclipse.dltk.tcl.ast.AstPackage;
import org.eclipse.dltk.tcl.ast.ComplexString;
import org.eclipse.dltk.tcl.ast.Script;
import org.eclipse.dltk.tcl.ast.StringArgument;
import org.eclipse.dltk.tcl.ast.Substitution;
import org.eclipse.dltk.tcl.ast.TclArgument;
import org.eclipse.dltk.tcl.ast.TclArgumentList;
import org.eclipse.dltk.tcl.ast.TclCommand;
import org.eclipse.dltk.tcl.ast.VariableReference;
import org.eclipse.dltk.tcl.formatter.internal.TclFormatterWriter;
import org.eclipse.dltk.tcl.formatter.internal.UnexpectedFormatterException;
import org.eclipse.dltk.tcl.parser.TclParserUtils;
import org.eclipse.dltk.tcl.parser.TclVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FormatterWorker
extends TclVisitor {
    private static final String BACKSLASH = "\\";
    private static final String PROC_DIRECTIVE = "proc";
    private static final String PACKAGE_DIRECTIVE = "package";
    private final IFormatterDocument document;
    private final IFormatterContext context;
    private final TclFormatterWriter writer;
    private int lastReaderPos = 0;
    private String prevLine = "";
    private boolean lastComment = false;
    private boolean wasPackageDirective = false;

    public FormatterWorker(TclFormatterWriter writer, IFormatterDocument document, IFormatterContext context) {
        this.writer = writer;
        this.document = document;
        this.context = context;
    }

    private static boolean isBackSlashLine(IFormatterDocument document, String line) {
        return document.getBoolean("indent.after.backslash") && (line.contains("\\\n") || line.contains("\\\r"));
    }

    private static List<String> splitComments(String input) {
        ArrayList<String> result = new ArrayList<String>();
        List<String> lines = FormatterWorker.splitLines(input);
        StringBuffer sb = new StringBuffer();
        for (String line : lines) {
            sb.append(line);
            if (!"".equals(line.trim())) continue;
            result.add(sb.toString());
            sb.setLength(0);
        }
        if (sb.length() > 0) {
            result.add(sb.toString());
        }
        return result;
    }

    private static List<String> splitLines(String text) {
        char[] input = text.toCharArray();
        ArrayList<String> lines = new ArrayList<String>();
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < input.length) {
            block7: {
                block6: {
                    sb.append(input[i]);
                    if (input[i] != '\r') break block6;
                    if (i + 1 < input.length && input[i + 1] == '\n') break block7;
                    lines.add(sb.toString());
                    sb.setLength(0);
                }
                if (input[i] == '\n') {
                    lines.add(sb.toString());
                    sb.setLength(0);
                }
            }
            ++i;
        }
        if (sb.length() > 0) {
            lines.add(sb.toString());
        }
        return lines;
    }

    private static boolean isIf0Comment(TclCommand command) {
        return "if".equals(command.getQualifiedName()) && command.getArguments().size() == 2 && command.getArguments().get(0) instanceof StringArgument && "0".equals(((StringArgument)command.getArguments().get(0)).getValue()) && command.getArguments().get(1) instanceof Script;
    }

    private static boolean isCommandName(TclArgument arg) {
        return arg.eContainingFeature() == AstPackage.Literals.TCL_COMMAND__NAME;
    }

    public void format(List<TclCommand> commands) {
        TclParserUtils.traverse(commands, (TclVisitor)this);
        if (this.lastReaderPos < this.document.getLength()) {
            this.write(this.document.getLength());
        }
    }

    public boolean visit(TclCommand command) {
        this.context.setIndenting(true);
        this.lastComment = false;
        if (PACKAGE_DIRECTIVE.equals(command.getQualifiedName())) {
            if (this.wasPackageDirective) {
                this.context.setBlankLines(0);
            }
            this.wasPackageDirective = true;
        } else if (this.wasPackageDirective) {
            this.context.setBlankLines(this.document.getInt("line.file.require.after"));
            this.wasPackageDirective = false;
        }
        if (PROC_DIRECTIVE.equals(command.getQualifiedName())) {
            List<String> comments = FormatterWorker.splitComments(this.document.get(this.lastReaderPos, command.getStart()));
            int i = 0;
            while (i < comments.size() - 1) {
                this.write(this.lastReaderPos + comments.get(i).length());
                ++i;
            }
            this.context.setBlankLines(this.document.getInt("line.file.proc.between"));
        } else if (FormatterWorker.isIf0Comment(command)) {
            this.lastComment = true;
            this.write(command.getEnd());
            return false;
        }
        this.write(command.getName().getEnd());
        return true;
    }

    public void endVisit(TclCommand command) {
        if (PROC_DIRECTIVE.equals(command.getQualifiedName())) {
            this.context.setBlankLines(this.document.getInt("line.file.proc.between"));
        }
    }

    public boolean visit(StringArgument arg) {
        if (FormatterWorker.isCommandName((TclArgument)arg)) {
            return false;
        }
        this.writeString(arg.getStart(), arg.getEnd());
        return false;
    }

    private void writeString(int start, int end) {
        this.write(start);
        if (!FormatterWorker.isBackSlashLine(this.document, this.prevLine)) {
            try {
                this.writer.ensureLineStarted(this.context);
            }
            catch (Exception e) {
                throw new UnexpectedFormatterException(e);
            }
        }
        boolean savedIndenting = this.context.isIndenting();
        int savedLinesPreserve = this.writer.getLinesPreserve();
        this.writer.setLinesPreserve(-1);
        this.context.setIndenting(false);
        this.write(end);
        this.context.setIndenting(savedIndenting);
        this.writer.setLinesPreserve(savedLinesPreserve);
        this.writer.ensureLineStarted(this.context);
    }

    public boolean visit(TclArgumentList list) {
        this.context.incIndent();
        return true;
    }

    public void endVisit(TclArgumentList list) {
        this.context.decIndent();
    }

    public boolean visit(Script script) {
        if (FormatterWorker.isCommandName((TclArgument)script)) {
            return false;
        }
        if (script.getCommands().isEmpty()) {
            if (this.document.getBoolean("indent.script")) {
                this.context.incIndent();
            }
            this.write(script.getContentEnd());
            return true;
        }
        if (script.getContentStart() > script.getStart()) {
            this.write(script.getContentStart());
            if (this.document.getBoolean("indent.script")) {
                this.context.incIndent();
            }
            return true;
        }
        this.write(script.getEnd());
        return false;
    }

    public void endVisit(Script script) {
        this.write(script.getContentEnd());
        if (this.document.getBoolean("indent.script")) {
            this.context.decIndent();
        }
        this.write(script.getEnd());
    }

    public boolean visit(Substitution substitution) {
        if (FormatterWorker.isCommandName((TclArgument)substitution)) {
            return false;
        }
        this.write(substitution.getStart());
        return true;
    }

    public boolean visit(ComplexString string) {
        if (FormatterWorker.isCommandName((TclArgument)string)) {
            return false;
        }
        this.writeString(string.getStart(), string.getEnd());
        return false;
    }

    public boolean visit(VariableReference var) {
        if (FormatterWorker.isCommandName((TclArgument)var)) {
            return false;
        }
        this.write(var.getStart());
        this.write(var.getEnd());
        return false;
    }

    protected void write(int endOffset) {
        assert (endOffset >= this.lastReaderPos);
        if (this.lastReaderPos == endOffset) {
            return;
        }
        boolean decIndent = false;
        if (FormatterWorker.isBackSlashLine(this.document, this.prevLine)) {
            this.context.setIndenting(!this.lastComment);
            this.context.incIndent();
            decIndent = true;
        }
        String text = this.document.get(this.lastReaderPos, endOffset);
        List<String> lines = FormatterWorker.splitLines(text);
        for (String line : lines) {
            int end = this.lastReaderPos + line.length();
            if (line.trim().startsWith("#")) {
                boolean savedWrapping = this.context.isWrapping();
                this.context.setWrapping(this.document.getBoolean("wrap.comments"));
                try {
                    this.writer.write(this.context, this.lastReaderPos, end);
                }
                catch (Exception e) {
                    throw new UnexpectedFormatterException(e);
                }
                this.context.setWrapping(savedWrapping);
                this.lastComment = true;
            } else {
                try {
                    this.writer.write(this.context, this.lastReaderPos, end);
                }
                catch (Exception e) {
                    throw new UnexpectedFormatterException(e);
                }
                this.lastComment = false;
            }
            this.prevLine = "".equals(line.trim()) ? String.valueOf(this.prevLine) + line : line;
            this.lastReaderPos = end;
        }
        if (decIndent) {
            this.context.decIndent();
        }
    }
}

