/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.internal.parser.raw;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.dltk.tcl.internal.parser.raw.ISubstitution;
import org.eclipse.dltk.tcl.internal.parser.raw.TclWord;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TclWordBuffer {
    private State state;
    private int start;
    private final List<Object> contents = new ArrayList<Object>();
    private final StringBuilder string = new StringBuilder();

    TclWordBuffer() {
    }

    public State getState() {
        return this.state;
    }

    public void setState(State state) {
        this.state = state;
    }

    public void reset() {
        this.state = State.START;
        this.contents.clear();
        this.string.setLength(0);
    }

    public boolean isEmpty() {
        return this.contents.isEmpty() && this.string.length() == 0;
    }

    public TclWord buildWord() {
        this.flushStringBuffer();
        if (!this.isEmpty()) {
            TclWord word = new TclWord(this.contents);
            word.setStart(this.start);
            this.state = State.START;
            this.contents.clear();
            return word;
        }
        return null;
    }

    private final void flushStringBuffer() {
        if (this.string.length() != 0) {
            this.contents.add(this.string.toString());
            this.string.setLength(0);
        }
    }

    public void setStart(int start) {
        this.start = start;
    }

    public void add(ISubstitution s) {
        this.flushStringBuffer();
        this.contents.add(s);
        this.state = State.CONTENT;
    }

    public void add(char ch) {
        this.string.append(ch);
        this.state = State.CONTENT;
    }

    public List<Object> getContents() {
        this.flushStringBuffer();
        return this.contents;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum State {
        START,
        CONTENT;

    }
}

