/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ruby.internal.ui.text;

import org.eclipse.dltk.ruby.internal.ui.text.RubyHeuristicScanner;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.source.DefaultCharacterPairMatcher;

public final class RubyPairMatcher
extends DefaultCharacterPairMatcher {
    private int fBlockAnchor;

    public RubyPairMatcher() {
        super("{}[]()".toCharArray(), "__ruby_partitioning");
    }

    public IRegion match(IDocument document, int offset) {
        try {
            return this.performMatch(document, offset);
        }
        catch (BadLocationException ble) {
            return null;
        }
    }

    private IRegion performMatch(IDocument document, int offset) throws BadLocationException {
        int end;
        if (offset < 0 || document == null) {
            return null;
        }
        IRegion region = super.match(document, offset);
        if (region != null) {
            return region;
        }
        RubyHeuristicScanner scanner = new RubyHeuristicScanner(document);
        IRegion word = scanner.findWordAt(offset);
        if (word == null) {
            return null;
        }
        int start = word.getOffset();
        if (scanner.isBlockBeginning(start, end = start + word.getLength())) {
            start = scanner.getPosition();
            if ((end = scanner.findBlockEndingOffset(end)) != -1) {
                this.clear();
                this.fBlockAnchor = 1;
                return new Region(start, end - start);
            }
        } else if (scanner.isBlockEnding(start, end)) {
            end = scanner.getPosition();
            if ((start = scanner.findBlockBeginningOffset(start)) != -1) {
                this.clear();
                this.fBlockAnchor = 0;
                return new Region(start, end - start);
            }
        }
        return null;
    }

    public int getAnchor() {
        int superAnchor = super.getAnchor();
        if (superAnchor < 0) {
            return this.fBlockAnchor;
        }
        return superAnchor;
    }

    public void clear() {
        super.clear();
        this.fBlockAnchor = -1;
    }
}

