/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.internal.ui.text.completion;

import java.util.concurrent.Callable;
import org.eclipse.dltk.core.CompletionProposal;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.internal.javascript.ti.TypeSystemImpl;
import org.eclipse.dltk.javascript.internal.ui.JavaScriptUI;
import org.eclipse.dltk.javascript.internal.ui.text.completion.GenericTypeCompletionProposal;
import org.eclipse.dltk.javascript.internal.ui.text.completion.JavaScriptCompletionProposal;
import org.eclipse.dltk.javascript.internal.ui.text.completion.JavaScriptProposalInfo;
import org.eclipse.dltk.javascript.typeinference.IValueReference;
import org.eclipse.dltk.javascript.typeinfo.IRMethod;
import org.eclipse.dltk.javascript.typeinfo.IRParameter;
import org.eclipse.dltk.javascript.typeinfo.IRType;
import org.eclipse.dltk.javascript.typeinfo.ITypeSystem;
import org.eclipse.dltk.javascript.typeinfo.RTypes;
import org.eclipse.dltk.javascript.typeinfo.TypeMode;
import org.eclipse.dltk.javascript.typeinfo.model.GenericType;
import org.eclipse.dltk.javascript.typeinfo.model.JSType;
import org.eclipse.dltk.javascript.typeinfo.model.Method;
import org.eclipse.dltk.javascript.typeinfo.model.Parameter;
import org.eclipse.dltk.javascript.typeinfo.model.ParameterKind;
import org.eclipse.dltk.ui.text.completion.AbstractScriptCompletionProposal;
import org.eclipse.dltk.ui.text.completion.ICompletionProposalInfo;
import org.eclipse.dltk.ui.text.completion.IScriptCompletionProposal;
import org.eclipse.dltk.ui.text.completion.LazyScriptCompletionProposal;
import org.eclipse.dltk.ui.text.completion.ProposalContextInformation;
import org.eclipse.dltk.ui.text.completion.ScriptCompletionProposal;
import org.eclipse.dltk.ui.text.completion.ScriptCompletionProposalCollector;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.swt.graphics.Image;

public class JavaScriptCompletionProposalCollector
extends ScriptCompletionProposalCollector {
    protected static final char[] VAR_TRIGGER = new char[]{'\t', ' ', '=', ';', '.'};
    private ITypeSystem typeSystem;

    protected char[] getVarTrigger() {
        return VAR_TRIGGER;
    }

    public JavaScriptCompletionProposalCollector(ISourceModule module) {
        super(module);
    }

    private boolean hasProposalInfo(AbstractScriptCompletionProposal proposal) {
        if (proposal instanceof LazyScriptCompletionProposal) {
            return true;
        }
        return proposal.getProposalInfo() != null;
    }

    protected IScriptCompletionProposal createScriptCompletionProposal(CompletionProposal proposal) {
        AbstractScriptCompletionProposal outProposal = (AbstractScriptCompletionProposal)super.createScriptCompletionProposal(proposal);
        if (outProposal != null && !this.hasProposalInfo(outProposal) && proposal.getExtraInfo() != null) {
            outProposal.setProposalInfo((ICompletionProposalInfo)new JavaScriptProposalInfo(proposal.getExtraInfo()));
        }
        return outProposal;
    }

    protected IScriptCompletionProposal createTypeProposal(CompletionProposal typeProposal) {
        if (this.getAttribute(TypeMode.JSDOC) != null && typeProposal.getExtraInfo() instanceof GenericType) {
            return new GenericTypeCompletionProposal(typeProposal, this.getInvocationContext());
        }
        return super.createTypeProposal(typeProposal);
    }

    protected IScriptCompletionProposal createMethodReferenceProposal(CompletionProposal methodProposal) {
        Method method;
        AbstractScriptCompletionProposal methodReferenceProposal = (AbstractScriptCompletionProposal)super.createMethodReferenceProposal(methodProposal);
        Object extraInfo = methodProposal.getExtraInfo();
        if (extraInfo != null) {
            methodReferenceProposal.setProposalInfo((ICompletionProposalInfo)new JavaScriptProposalInfo(extraInfo));
        }
        StringBuilder sb = null;
        Integer paramLimit = (Integer)methodProposal.getAttribute("org.eclipse.dltk.uiCompletionProposal#ParameterLimit");
        if (extraInfo instanceof Method) {
            method = (Method)extraInfo;
            EList parameters = method.getParameters();
            if (parameters.size() > 0) {
                sb = new StringBuilder();
                int index = 0;
                for (final Parameter parameter : parameters) {
                    if (sb.length() > 0) {
                        sb.append(", ");
                    }
                    if (parameter.getKind() == ParameterKind.OPTIONAL) {
                        sb.append('[');
                    }
                    if (parameter.getType() != null) {
                        try {
                            final ITypeSystem ts = this.getTypeSystem();
                            IRType type = (IRType)ITypeSystem.CURRENT.runWith(ts, (Callable)new Callable<IRType>(){

                                @Override
                                public IRType call() {
                                    return RTypes.create((ITypeSystem)ts, (JSType)parameter.getType());
                                }
                            });
                            sb.append(type.getName());
                        }
                        catch (Exception e) {
                            JavaScriptUI.log(e);
                        }
                        if (parameter.getKind() == ParameterKind.VARARGS) {
                            sb.append("...");
                        }
                        sb.append(' ');
                    }
                    sb.append(parameter.getName());
                    if (parameter.getKind() == ParameterKind.VARARGS && parameter.getType() == null) {
                        sb.append("...");
                    }
                    if (parameter.getKind() == ParameterKind.OPTIONAL) {
                        sb.append(']');
                    }
                    if (paramLimit == null || ++index < paramLimit) {
                        continue;
                    }
                    break;
                }
            }
        } else if (extraInfo instanceof IValueReference && (method = (IRMethod)((IValueReference)extraInfo).getAttribute("R_METHOD")) != null && method.getParameterCount() > 0) {
            sb = new StringBuilder();
            int index = 0;
            for (IRParameter parameter : method.getParameters()) {
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                if (parameter.isOptional()) {
                    sb.append('[');
                }
                if (parameter.getType() != null) {
                    sb.append(parameter.getType().getName());
                    if (parameter.isVarargs()) {
                        sb.append("...");
                    }
                    sb.append(' ');
                }
                sb.append(parameter.getName());
                if (parameter.isVarargs() && parameter.getType() == null) {
                    sb.append("...");
                }
                if (parameter.isOptional()) {
                    sb.append(']');
                }
                if (paramLimit == null || ++index < paramLimit) {
                    continue;
                }
                break;
            }
        }
        if (sb != null) {
            JavaScriptProposalContextInformation contextInformation = new JavaScriptProposalContextInformation(methodProposal, sb.toString());
            int pos = methodProposal.getCompletion().indexOf(40);
            if (pos >= 0) {
                contextInformation.setContextInformationPosition(methodProposal.getReplaceStart() + pos + 1);
                methodReferenceProposal.setContextInformation((IContextInformation)contextInformation);
            }
        }
        return methodReferenceProposal;
    }

    private ITypeSystem getTypeSystem() {
        if (this.typeSystem == null) {
            this.typeSystem = ITypeSystem.CURRENT.get();
            if (this.typeSystem == null) {
                this.typeSystem = new TypeSystemImpl();
            }
        }
        return this.typeSystem;
    }

    protected IScriptCompletionProposal createFieldProposal(CompletionProposal proposal) {
        IScriptCompletionProposal fieldProposal = super.createFieldProposal(proposal);
        if (proposal.getExtraInfo() != null) {
            ((AbstractScriptCompletionProposal)fieldProposal).setProposalInfo((ICompletionProposalInfo)new JavaScriptProposalInfo(proposal.getExtraInfo()));
        }
        return fieldProposal;
    }

    protected ScriptCompletionProposal createScriptCompletionProposal(String completion, int replaceStart, int length, Image image, String displayString, int i, boolean isInDoc) {
        if (this.getAttribute(TypeMode.JSDOC) instanceof Boolean) {
            isInDoc = (Boolean)this.getAttribute(TypeMode.JSDOC);
        }
        JavaScriptCompletionProposal javaScriptCompletionProposal = new JavaScriptCompletionProposal(completion, replaceStart, length, image, displayString, i, isInDoc);
        return javaScriptCompletionProposal;
    }

    protected IScriptCompletionProposal createKeywordProposal(CompletionProposal proposal) {
        String completion = String.valueOf(proposal.getCompletion());
        int start = proposal.getReplaceStart();
        int length = this.getLength(proposal);
        String label = this.getLabelProvider().createSimpleLabel(proposal);
        Image img = this.getImage(this.getLabelProvider().createImageDescriptor(proposal));
        int relevance = this.computeRelevance(proposal);
        return this.createScriptCompletionProposal(completion, start, length, img, label, relevance, false);
    }

    protected String getNatureId() {
        return "org.eclipse.dltk.javascript.core.nature";
    }

    private static final class JavaScriptProposalContextInformation
    extends ProposalContextInformation {
        private final String informationDisplayString;

        public JavaScriptProposalContextInformation(CompletionProposal proposal, String informationDisplayString) {
            super(proposal);
            this.informationDisplayString = informationDisplayString;
        }

        public String getInformationDisplayString() {
            return this.informationDisplayString;
        }
    }
}

