/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ruby.formatter.lexer;

import org.eclipse.dltk.ruby.formatter.lexer.ILexerReader;

public class StringLexerReader
implements ILexerReader {
    private int offset = 0;
    private int line = 0;
    private int column = 0;
    private final String content;
    private boolean nextCharIsOnANewLine = false;

    public StringLexerReader(String content) {
        this.content = content;
    }

    public int peek() {
        return this.offset < this.content.length() ? (int)this.content.charAt(this.offset) : -1;
    }

    public int read() {
        if (this.offset < this.content.length()) {
            if (this.nextCharIsOnANewLine) {
                this.column = 0;
                this.nextCharIsOnANewLine = false;
            }
            ++this.column;
            return this.content.charAt(this.offset++);
        }
        return -1;
    }

    public int getColumn() {
        return this.column;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getLine() {
        return this.line;
    }

    public void newLine() {
        ++this.line;
        this.nextCharIsOnANewLine = true;
    }
}

