/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.ui.callhierarchy;

import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.search.IDLTKSearchScope;
import org.eclipse.dltk.internal.ui.callhierarchy.CallHierarchyMessages;
import org.eclipse.dltk.internal.ui.callhierarchy.SearchScopeAction;
import org.eclipse.dltk.internal.ui.callhierarchy.SearchScopeActionGroup;
import org.eclipse.dltk.internal.ui.search.DLTKSearchScopeFactory;

class SearchScopeProjectAction
extends SearchScopeAction {
    private final SearchScopeActionGroup fGroup;

    public SearchScopeProjectAction(SearchScopeActionGroup group) {
        super(group, CallHierarchyMessages.SearchScopeActionGroup_project_text);
        this.fGroup = group;
        this.setToolTipText(CallHierarchyMessages.SearchScopeActionGroup_project_tooltip);
        if (DLTKCore.DEBUG) {
            System.err.println("Add help support here...");
        }
    }

    @Override
    public IDLTKSearchScope getSearchScope() {
        IMethod method = this.fGroup.getView().getMethod();
        if (method == null) {
            return null;
        }
        DLTKSearchScopeFactory factory = DLTKSearchScopeFactory.getInstance();
        return factory.createProjectSearchScope(method.getScriptProject(), true);
    }

    @Override
    public int getSearchScopeType() {
        return 2;
    }

    @Override
    public String getFullDescription() {
        IMethod method = this.fGroup.getView().getMethod();
        if (method != null) {
            DLTKSearchScopeFactory factory = DLTKSearchScopeFactory.getInstance();
            return factory.getProjectScopeDescription(method.getScriptProject(), true);
        }
        return "";
    }
}

