/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.debug.core.model;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.WeakHashMap;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStepFilters;
import org.eclipse.debug.core.model.ITerminate;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.dltk.compiler.CharOperation;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.dbgp.IDbgpSession;
import org.eclipse.dltk.dbgp.IDbgpStackLevel;
import org.eclipse.dltk.dbgp.IDbgpStreamFilter;
import org.eclipse.dltk.dbgp.IDbgpThreadAcceptor;
import org.eclipse.dltk.debug.core.DLTKDebugLaunchConstants;
import org.eclipse.dltk.debug.core.DLTKDebugPlugin;
import org.eclipse.dltk.debug.core.IDbgpService;
import org.eclipse.dltk.debug.core.IDebugOptions;
import org.eclipse.dltk.debug.core.model.DefaultDebugOptions;
import org.eclipse.dltk.debug.core.model.IScriptBreakpoint;
import org.eclipse.dltk.debug.core.model.IScriptBreakpointLineMapper;
import org.eclipse.dltk.debug.core.model.IScriptBreakpointPathMapper;
import org.eclipse.dltk.debug.core.model.IScriptDebugTarget;
import org.eclipse.dltk.debug.core.model.IScriptDebugTargetListener;
import org.eclipse.dltk.debug.core.model.IScriptDebugThreadConfigurator;
import org.eclipse.dltk.debug.core.model.IScriptThread;
import org.eclipse.dltk.debug.core.model.IScriptVariable;
import org.eclipse.dltk.internal.debug.core.model.DebugEventHelper;
import org.eclipse.dltk.internal.debug.core.model.IScriptStreamProxy;
import org.eclipse.dltk.internal.debug.core.model.IScriptThreadManager;
import org.eclipse.dltk.internal.debug.core.model.IScriptThreadManagerListener;
import org.eclipse.dltk.internal.debug.core.model.NopScriptBreakpointLineMapper;
import org.eclipse.dltk.internal.debug.core.model.NopScriptbreakpointPathMapper;
import org.eclipse.dltk.internal.debug.core.model.ScriptBreakpointManager;
import org.eclipse.dltk.internal.debug.core.model.ScriptDebugElement;
import org.eclipse.dltk.internal.debug.core.model.ScriptThreadManager;
import org.eclipse.dltk.internal.debug.core.model.StrUtils;

public class ScriptDebugTarget
extends ScriptDebugElement
implements IScriptDebugTarget,
IScriptThreadManagerListener,
IStepFilters {
    @Deprecated
    private static final String LAUNCH_CONFIGURATION_ATTR_PROJECT = "project";
    private static final int THREAD_TERMINATION_TIMEOUT = 5000;
    private final ListenerList listeners;
    private IScriptStreamProxy streamProxy;
    private IProcess process;
    private final ILaunch launch;
    private String name;
    private boolean disconnected;
    private final IScriptThreadManager threadManager;
    final ScriptBreakpointManager breakpointManager;
    private final IDbgpService dbgpService;
    private final String sessionId;
    private final String modelId;
    private static final WeakHashMap targets = new WeakHashMap();
    private String[] stepFilters;
    private boolean useStepFilters;
    private final Object processLock = new Object();
    private boolean initialized = false;
    private boolean retrieveGlobalVariables;
    private boolean retrieveClassVariables;
    private boolean retrieveLocalVariables;
    private final IDebugOptions options;
    private IScriptBreakpointLineMapper lineMapper;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List getAllTargets() {
        WeakHashMap weakHashMap = targets;
        synchronized (weakHashMap) {
            return new ArrayList(targets.keySet());
        }
    }

    public ScriptDebugTarget(String modelId, IDbgpService dbgpService, String sessionId, ILaunch launch, IProcess process) {
        this(modelId, dbgpService, sessionId, launch, process, DefaultDebugOptions.getDefaultInstance());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScriptDebugTarget(String modelId, IDbgpService dbgpService, String sessionId, ILaunch launch, IProcess process, IDebugOptions options) {
        Assert.isNotNull((Object)options);
        this.modelId = modelId;
        this.listeners = new ListenerList();
        this.process = process;
        this.launch = launch;
        this.options = options;
        this.threadManager = new ScriptThreadManager(this);
        this.threadManager.addListener(this);
        this.sessionId = sessionId;
        this.dbgpService = dbgpService;
        this.disconnected = false;
        this.lineMapper = this.createLineMapper();
        this.breakpointManager = new ScriptBreakpointManager(this, this.createPathMapper(), this.lineMapper);
        DebugEventHelper.fireCreateEvent(this);
        WeakHashMap weakHashMap = targets;
        synchronized (weakHashMap) {
            targets.put(this, "");
        }
    }

    public void shutdown() {
        try {
            this.terminate(true);
        }
        catch (DebugException e) {
            DLTKDebugPlugin.log(e);
        }
    }

    @Override
    public String getSessionId() {
        return this.sessionId;
    }

    public IDebugTarget getDebugTarget() {
        return this;
    }

    @Override
    public String getModelIdentifier() {
        return this.modelId;
    }

    @Override
    public ILaunch getLaunch() {
        return this.launch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IProcess getProcess() {
        Object object = this.processLock;
        synchronized (object) {
            return this.process;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProcess(IProcess process) {
        Object object = this.processLock;
        synchronized (object) {
            this.process = process;
        }
    }

    public boolean hasThreads() {
        return this.threadManager.hasThreads();
    }

    public IThread[] getThreads() {
        return this.threadManager.getThreads();
    }

    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canTerminate() {
        Object object = this.processLock;
        synchronized (object) {
            return this.threadManager.canTerminate() || this.process != null && this.process.canTerminate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isTerminated() {
        Object object = this.processLock;
        synchronized (object) {
            return this.threadManager.isTerminated() && (this.process == null || this.process.isTerminated());
        }
    }

    protected static boolean waitTerminated(ITerminate terminate, int chunk, long timeout) {
        long start = System.currentTimeMillis();
        while (!terminate.isTerminated()) {
            if (System.currentTimeMillis() - start > timeout) {
                return false;
            }
            try {
                Thread.sleep(chunk);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return true;
    }

    public void terminate() throws DebugException {
        this.terminate(true);
    }

    protected void terminate(boolean waitTermination) throws DebugException {
        this.fireTargetTerminating();
        this.threadManager.sendTerminationRequest();
        if (waitTermination) {
            IProcess p = this.getProcess();
            int CHUNK = 500;
            if ((!ScriptDebugTarget.waitTerminated(this.threadManager, 500, 5000L) || p != null && !ScriptDebugTarget.waitTerminated((ITerminate)p, 500, 5000L)) && p != null && p.canTerminate()) {
                p.terminate();
            }
        }
        this.threadManager.removeListener(this);
        this.breakpointManager.threadTerminated();
        DebugEventHelper.fireTerminateEvent(this);
    }

    public boolean canSuspend() {
        return this.threadManager.canSuspend();
    }

    public boolean isSuspended() {
        return this.threadManager.isSuspended();
    }

    public void suspend() throws DebugException {
        this.threadManager.suspend();
    }

    public boolean canResume() {
        return this.threadManager.canResume();
    }

    public void resume() throws DebugException {
        this.threadManager.resume();
    }

    public boolean canDisconnect() {
        return false;
    }

    public void disconnect() {
        this.disconnected = true;
    }

    public boolean isDisconnected() {
        return this.disconnected;
    }

    public boolean supportsStorageRetrieval() {
        return false;
    }

    public IMemoryBlock getMemoryBlock(long startAddress, long length) {
        return null;
    }

    public IScriptVariable findVariable(String variableName) {
        return null;
    }

    @Override
    public int getRequestTimeout() {
        return 0;
    }

    @Override
    public void setRequestTimeout(int timeout) {
    }

    public void breakpointAdded(IBreakpoint breakpoint) {
        this.breakpointManager.breakpointAdded(breakpoint);
    }

    public void breakpointChanged(IBreakpoint breakpoint, IMarkerDelta delta) {
        this.breakpointManager.breakpointChanged(breakpoint, delta);
    }

    public void breakpointRemoved(IBreakpoint breakpoint, IMarkerDelta delta) {
        this.breakpointManager.breakpointRemoved(breakpoint, delta);
    }

    @Override
    public IScriptStreamProxy getStreamProxy() {
        return this.streamProxy;
    }

    @Override
    public void setStreamProxy(IScriptStreamProxy proxy) {
        this.streamProxy = proxy;
        if (proxy != null) {
            proxy.setEncoding(this.getConsoleEncoding());
        }
    }

    @Override
    public void threadAccepted(IScriptThread thread, boolean first) {
        if (first) {
            DebugEventHelper.fireExtendedEvent(this, 2);
            this.initialized = true;
            this.fireTargetInitialized();
        }
    }

    protected IScriptBreakpointPathMapper createPathMapper() {
        return new NopScriptbreakpointPathMapper();
    }

    protected IScriptBreakpointLineMapper createLineMapper() {
        return new NopScriptBreakpointLineMapper();
    }

    @Override
    public void allThreadsTerminated() {
        try {
            if (this.streamProxy != null) {
                this.streamProxy.close();
            }
            this.terminate(false);
        }
        catch (DebugException e) {
            DLTKDebugPlugin.log(e);
        }
    }

    public String toString() {
        return "Debugging engine (id = " + this.sessionId + ")";
    }

    @Override
    public void runToLine(URI uri, int lineNumber) throws DebugException {
        this.breakpointManager.setBreakpointUntilFirstSuspend(uri, lineNumber);
        this.resume();
    }

    @Override
    public boolean isInitialized() {
        return this.initialized;
    }

    protected void fireTargetInitialized() {
        Object[] list = this.listeners.getListeners();
        int i = 0;
        while (i < list.length) {
            ((IScriptDebugTargetListener)list[i]).targetInitialized();
            ++i;
        }
    }

    protected void fireTargetTerminating() {
        Object[] list = this.listeners.getListeners();
        int i = 0;
        while (i < list.length) {
            ((IScriptDebugTargetListener)list[i]).targetTerminating();
            ++i;
        }
    }

    @Override
    public void addListener(IScriptDebugTargetListener listener) {
        this.listeners.add((Object)listener);
    }

    @Override
    public void removeListener(IScriptDebugTargetListener listener) {
        this.listeners.remove((Object)listener);
    }

    public boolean supportsBreakpoint(IBreakpoint breakpoint) {
        if (breakpoint instanceof IScriptBreakpoint) {
            return StrUtils.equals(breakpoint.getModelIdentifier(), this.getModelIdentifier());
        }
        return false;
    }

    @Override
    public void setFilters(String[] activeFilters) {
        this.stepFilters = activeFilters;
    }

    @Override
    public String[] getFilters() {
        if (this.stepFilters != null) {
            return this.stepFilters;
        }
        return CharOperation.NO_STRINGS;
    }

    @Override
    public boolean isUseStepFilters() {
        return this.useStepFilters;
    }

    @Override
    public void setUseStepFilters(boolean useStepFilters) {
        this.useStepFilters = useStepFilters;
    }

    @Override
    public IDLTKLanguageToolkit getLanguageToolkit() {
        IScriptProject scriptProject = this.getScriptProject();
        if (scriptProject != null) {
            IDLTKLanguageToolkit toolkit = DLTKLanguageManager.getLanguageToolkit((IModelElement)scriptProject);
            return toolkit;
        }
        return null;
    }

    @Deprecated
    protected IScriptProject getScriptProject() {
        block4: {
            ILaunchConfiguration configuration = this.launch.getLaunchConfiguration();
            if (configuration != null) {
                try {
                    String projectName = configuration.getAttribute(LAUNCH_CONFIGURATION_ATTR_PROJECT, null);
                    if (projectName != null && (projectName = projectName.trim()).length() > 0) {
                        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
                        return DLTKCore.create((IProject)project);
                    }
                }
                catch (CoreException e) {
                    if (!DLTKCore.DEBUG) break block4;
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    @Override
    public boolean breakOnFirstLineEnabled() {
        return DLTKDebugLaunchConstants.isBreakOnFirstLine(this.launch);
    }

    @Override
    public void toggleGlobalVariables(boolean enabled) {
        this.retrieveGlobalVariables = enabled;
        this.threadManager.refreshThreads();
    }

    @Override
    public void toggleClassVariables(boolean enabled) {
        this.retrieveClassVariables = enabled;
        this.threadManager.refreshThreads();
    }

    @Override
    public void toggleLocalVariables(boolean enabled) {
        this.retrieveLocalVariables = enabled;
        this.threadManager.refreshThreads();
    }

    @Override
    public boolean retrieveClassVariables() {
        return this.retrieveClassVariables;
    }

    @Override
    public boolean retrieveGlobalVariables() {
        return this.retrieveGlobalVariables;
    }

    @Override
    public boolean retrieveLocalVariables() {
        return this.retrieveLocalVariables;
    }

    @Override
    public String getConsoleEncoding() {
        String encoding = "UTF-8";
        try {
            encoding = this.getLaunch().getLaunchConfiguration().getAttribute("org.eclipse.debug.ui.ATTR_CONSOLE_ENCODING", encoding);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return encoding;
    }

    public void setScriptDebugThreadConfigurator(IScriptDebugThreadConfigurator configurator) {
        this.threadManager.setScriptThreadConfigurator(configurator);
    }

    @Override
    public IDebugOptions getOptions() {
        return this.options;
    }

    public boolean isStepFiltersEnabled() {
        return this.isUseStepFilters();
    }

    public void setStepFiltersEnabled(boolean enabled) {
        this.setUseStepFilters(enabled);
    }

    public boolean supportsStepFilters() {
        return true;
    }

    @Override
    public IDbgpSession[] getSessions() {
        return this.breakpointManager.getSessions();
    }

    @Override
    public IScriptBreakpointPathMapper getPathMapper() {
        return this.breakpointManager.bpPathMapper;
    }

    public void setStreamFilters(IDbgpStreamFilter[] streamFilters) {
        ((ScriptThreadManager)this.threadManager).setStreamFilters(streamFilters);
    }

    public IDbgpService getDbgpService() {
        return this.dbgpService;
    }

    public IDbgpThreadAcceptor getDbgpThreadAcceptor() {
        return this.threadManager;
    }

    @Override
    public boolean isRemote() {
        return false;
    }

    public void updateStackLevels(IDbgpStackLevel[] levels) {
        if (this.lineMapper != null) {
            int i = 0;
            while (i < levels.length) {
                IDbgpStackLevel level = this.lineMapper.getSourceStackLevel(levels[i]);
                if (level != null) {
                    levels[i] = level;
                }
                ++i;
            }
        }
    }
}

