/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.rhino.dbgp;

import java.util.HashMap;
import java.util.HashSet;
import org.eclipse.dltk.rhino.dbgp.DBGPDebugFrame;
import org.eclipse.dltk.rhino.dbgp.DBGPDebugger;
import org.eclipse.dltk.rhino.dbgp.LazyInitScope;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.xml.XMLObject;

final class ContextGetCommand
extends DBGPDebugger.Command {
    private static final int LOCAL_CONTEXT_ID = 0;
    private static final int GLOBAL_CONTEXT_ID = 1;
    private static final int CLASS_CONTEXT_ID = 2;
    private final DBGPDebugger debugger;

    ContextGetCommand(DBGPDebugger debugger) {
        this.debugger = debugger;
    }

    @Override
    void parseAndExecute(String command, HashMap options) {
        StringBuffer properties = new StringBuffer();
        try {
            DBGPDebugFrame stackFrame;
            Scriptable this1;
            int level = Integer.parseInt((String)options.get("-d"));
            int context = -1;
            String contextString = (String)options.get("-c");
            if (contextString != null) {
                context = Integer.parseInt((String)options.get("-c"));
            }
            if ((this1 = (stackFrame = this.debugger.stackmanager.getStackFrame(level)).getThis()) != null && (context == 0 || context == -1)) {
                this.debugger.printProperty("this", "this", this1, properties, 0, false);
            }
            Scriptable scriptable = stackFrame.getThis();
            HashSet doubles = new HashSet();
            if (context == 1 || context == -1) {
                this.sendAllIds(properties, stackFrame, scriptable.getParentScope(), doubles, true);
            }
            if (context == 0 || context == -1) {
                String[] propertyIds = stackFrame.getParametersAndVars();
                int a = 0;
                while (a < propertyIds.length) {
                    String id = propertyIds[a].toString();
                    Object value = stackFrame.getValue(a);
                    if (!(value instanceof Function) || value instanceof XMLObject) {
                        this.debugger.printProperty(id, id, value, properties, 0, true);
                    }
                    ++a;
                }
                Object argsValue = stackFrame.getStackFrameArgs();
                if (argsValue != null) {
                    this.debugger.printProperty("arguments", "arguments", argsValue, properties, 0, true);
                }
                this.sendAllIds(properties, stackFrame, scriptable, doubles, false);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        this.debugger.printResponse("<response command=\"context_get\"\r\nstatus=\"starting\" reason=\"ok\" transaction_id=\"" + options.get("-i") + "\">\r\n" + properties + "</response>\r\n");
    }

    private void sendAllIds(StringBuffer properties, DBGPDebugFrame stackFrame, Scriptable scriptable, HashSet doubles, boolean walkParents) {
        if (scriptable != null) {
            Object[] ids = null;
            ids = scriptable instanceof LazyInitScope ? ((LazyInitScope)scriptable).getInitializedIds() : scriptable.getIds();
            int i = 0;
            while (i < ids.length) {
                Object id = ids[i];
                if (!doubles.contains(id)) {
                    doubles.add(id);
                    Object value = null;
                    value = id instanceof Number ? scriptable.get(((Number)id).intValue(), scriptable) : scriptable.get(id.toString(), scriptable);
                    if (!(value instanceof Function)) {
                        this.debugger.printProperty(id.toString(), id.toString(), value, properties, 0, true);
                    }
                }
                ++i;
            }
            this.sendAllIds(properties, stackFrame, scriptable.getPrototype(), doubles, walkParents);
            if (walkParents) {
                this.sendAllIds(properties, stackFrame, scriptable.getParentScope(), doubles, walkParents);
            }
        }
    }
}

