/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.ast;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.parser.IModuleDeclaration;
import org.eclipse.dltk.javascript.ast.ASTVisitor;
import org.eclipse.dltk.javascript.ast.Comment;
import org.eclipse.dltk.javascript.ast.ISourceable;
import org.eclipse.dltk.javascript.ast.JSDeclaration;
import org.eclipse.dltk.javascript.ast.JSNode;
import org.eclipse.dltk.javascript.ast.JSScope;
import org.eclipse.dltk.javascript.ast.Statement;

public class Script
extends JSNode
implements ISourceable,
IModuleDeclaration,
JSScope {
    private final List<Comment> comments = new ArrayList<Comment>();
    private final List<Statement> statements = new ArrayList<Statement>();
    private final List<JSDeclaration> declarations = new ArrayList<JSDeclaration>();
    private Map<String, Object> attributes;

    public Script() {
        super(null);
    }

    @Override
    public Script getScript() {
        return this;
    }

    @Override
    public String toSourceString(String indentationString) {
        StringBuilder buffer = new StringBuilder();
        for (Statement statement : this.statements) {
            buffer.append(statement.toSourceString(indentationString));
        }
        return buffer.toString();
    }

    public List<Comment> getComments() {
        return this.comments;
    }

    public void addComment(Comment comment) {
        this.comments.add(comment);
    }

    public List<Statement> getStatements() {
        return this.statements;
    }

    public void addStatement(Statement statement) {
        this.statements.add(statement);
    }

    public <E> void visitAll(ASTVisitor<E> visitor) {
        for (Statement statement : this.statements) {
            visitor.visit(statement);
        }
    }

    @Override
    public String toString() {
        return this.toSourceString("");
    }

    public void traverse(org.eclipse.dltk.ast.ASTVisitor visitor) throws Exception {
        if (visitor.visit((ASTNode)this)) {
            for (Statement statement : this.statements) {
                statement.traverse(visitor);
            }
            visitor.endvisit((ASTNode)this);
        }
    }

    @Override
    public void addDeclaration(JSDeclaration declaration) {
        this.declarations.add(declaration);
    }

    @Override
    public List<JSDeclaration> getDeclarations() {
        return this.declarations;
    }

    public synchronized Object getAttribute(String key) {
        return this.attributes != null ? this.attributes.get(key) : null;
    }

    public synchronized void setAttribute(String key, Object value) {
        if (value != null) {
            if (this.attributes == null) {
                this.attributes = new HashMap<String, Object>();
            }
            this.attributes.put(key, value);
        } else if (this.attributes != null) {
            this.attributes.remove(key);
        }
    }
}

