/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.terminal.connector.ssh.connector;

import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.terminal.connector.AbstractSettingsPage;
import org.eclipse.terminal.connector.ssh.connector.SshMessages;
import org.eclipse.terminal.connector.ssh.connector.SshSettings;

public class SshSettingsPage
extends AbstractSettingsPage {
    private Text fHostText;
    private Text fUser;
    private Text fTimeout;
    private Text fKeepalive;
    private final SshSettings fTerminalSettings;
    private Text fPort;
    private Text fPassword;

    public SshSettingsPage(SshSettings settings) {
        this.fTerminalSettings = settings;
    }

    public void saveSettings() {
        this.fTerminalSettings.setHost(this.fHostText.getText());
        this.fTerminalSettings.setUser(this.fUser.getText());
        this.fTerminalSettings.setPassword(this.fPassword.getText());
        this.fTerminalSettings.setPort(this.fPort.getText());
        this.fTerminalSettings.setTimeout(this.fTimeout.getText());
        this.fTerminalSettings.setKeepalive(this.fKeepalive.getText());
    }

    public void loadSettings() {
        if (this.fTerminalSettings != null) {
            this.fHostText.setText(this.get(this.fTerminalSettings.getHost(), ""));
            this.fTimeout.setText(this.get(this.fTerminalSettings.getTimeoutString(), "0"));
            this.fKeepalive.setText(this.get(this.fTerminalSettings.getKeepaliveString(), "300"));
            this.fUser.setText(this.get(this.fTerminalSettings.getUser(), ""));
            this.fPort.setText(this.get(this.fTerminalSettings.getPortString(), String.valueOf(22)));
            this.fPassword.setText(this.get(this.fTerminalSettings.getPassword(), ""));
        }
    }

    String get(String value, String def) {
        if (value == null || value.length() == 0) {
            return def;
        }
        return value;
    }

    public boolean validateSettings() {
        int mt;
        String m;
        String message = null;
        int messageType = 0;
        boolean valid = true;
        if (this.fHostText.getText().trim().length() == 0) {
            m = "Please enter a host IP or name.";
            mt = 1;
            this.updateControlDecoration((Control)this.fHostText, m, mt);
            if (mt > messageType) {
                message = m;
                messageType = mt;
            }
            valid = false;
        } else {
            this.updateControlDecoration((Control)this.fHostText, null, 0);
        }
        if (this.fUser.getText().trim().length() == 0) {
            m = "Please enter a username.";
            mt = 1;
            this.updateControlDecoration((Control)this.fUser, m, mt);
            if (mt > messageType) {
                message = m;
                messageType = mt;
            }
            valid = false;
        } else {
            this.updateControlDecoration((Control)this.fUser, null, 0);
        }
        try {
            int mt2;
            int p = Integer.parseInt(this.fPort.getText().trim());
            if (p <= 0 || p > 65535) {
                String m2 = "Invalid network port. Must be between 0 and 65535.";
                mt2 = 3;
                this.updateControlDecoration((Control)this.fPort, m2, mt2);
                if (mt2 > messageType) {
                    message = m2;
                    messageType = mt2;
                }
                valid = false;
            } else {
                this.updateControlDecoration((Control)this.fPort, null, 0);
            }
            p = Integer.parseInt(this.fTimeout.getText().trim());
            if (p < 0) {
                String m3 = "Invalid timeout. Must be greater than 0.";
                mt2 = 3;
                this.updateControlDecoration((Control)this.fTimeout, m3, mt2);
                if (mt2 > messageType) {
                    message = m3;
                    messageType = mt2;
                }
                valid = false;
            } else {
                this.updateControlDecoration((Control)this.fTimeout, null, 0);
            }
            p = Integer.parseInt(this.fKeepalive.getText().trim());
            if (p < 0) {
                String m4 = "Invalid keep alive. Must be greater than 0.";
                mt2 = 3;
                this.updateControlDecoration((Control)this.fKeepalive, m4, mt2);
                if (mt2 > messageType) {
                    message = m4;
                    messageType = mt2;
                }
                valid = false;
            } else {
                this.updateControlDecoration((Control)this.fKeepalive, null, 0);
            }
        }
        catch (Exception e) {
            valid = false;
        }
        this.setMessage(message, messageType);
        return valid;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        GridData gridData = new GridData(768);
        gridData.horizontalIndent = FieldDecorationRegistry.getDefault().getMaximumDecorationWidth();
        composite.setLayout((Layout)gridLayout);
        composite.setLayoutData((Object)gridData);
        this.fHostText = this.createTextField(composite, SshMessages.HOST);
        this.fUser = this.createTextField(composite, SshMessages.USER);
        this.fPassword = this.createTextField(composite, SshMessages.PASSWORD, 0x400000);
        this.fTimeout = this.createTextField(composite, SshMessages.TIMEOUT);
        this.fKeepalive = this.createTextField(composite, SshMessages.KEEPALIVE);
        this.fKeepalive.setToolTipText(SshMessages.KEEPALIVE_Tooltip);
        this.fPort = this.createTextField(composite, SshMessages.PORT);
        this.loadSettings();
    }

    private Text createTextField(Composite composite, String labelTxt, int textOptions) {
        Label ctlLabel = new Label(composite, 131072);
        ctlLabel.setText(labelTxt + ":");
        GridData gridData = new GridData(768);
        final Text text = new Text(composite, 0x800 | textOptions);
        text.setLayoutData((Object)gridData);
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SshSettingsPage.this.fireListeners((Control)text);
            }
        });
        this.createControlDecoration((Control)text);
        return text;
    }

    private Text createTextField(Composite composite, String labelTxt) {
        return this.createTextField(composite, labelTxt, 0);
    }
}

