/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d.internal;

import java.util.function.Consumer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Control;

public class InternalDraw2dUtils {
    private static final String DRAW2D_ENABLE_AUTOSCALE = "draw2d.enableAutoscale";
    private static final String DATA_SHELL_ZOOM = "SHELL_ZOOM";
    private static final String DATA_AUTOSCALE_DISABLED = "AUTOSCALE_DISABLED";
    private static final boolean enableAutoScale = "win32".equals(SWT.getPlatform()) && Boolean.parseBoolean(System.getProperty("draw2d.enableAutoscale", Boolean.TRUE.toString())) && SWT.getVersion() >= 4971;

    public static boolean isAutoScaleEnabled() {
        return enableAutoScale;
    }

    public static void configureForAutoscalingMode(Control control, Consumer<Double> zoomConsumer) {
        if (control == null || !InternalDraw2dUtils.isAutoScaleEnabled()) {
            return;
        }
        control.setData(DATA_AUTOSCALE_DISABLED, (Object)true);
        control.addListener(55, e -> zoomConsumer.accept((double)e.detail / 100.0));
        zoomConsumer.accept(InternalDraw2dUtils.calculateScale(control));
    }

    private static double calculateScale(Control control) {
        int shellZoom;
        try {
            shellZoom = (Integer)control.getData(DATA_SHELL_ZOOM);
        }
        catch (ClassCastException | NullPointerException e) {
            shellZoom = 100;
        }
        return (double)shellZoom / 100.0;
    }
}

