/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.sqm.core.internal.ui.preferences;

import java.util.Arrays;
import java.util.List;
import java.util.regex.PatternSyntaxException;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.datatools.connectivity.sqm.core.internal.ui.RDBCoreUIPlugin;
import org.eclipse.datatools.connectivity.sqm.core.internal.ui.util.resources.ResourceLoader;
import org.eclipse.datatools.connectivity.sqm.core.ui.services.IDataToolsUIServiceManager;
import org.eclipse.datatools.help.ContextProviderDelegate;
import org.eclipse.datatools.help.HelpUtil;
import org.eclipse.help.IContext;
import org.eclipse.help.IContextProvider;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.osgi.service.prefs.Preferences;

public class LabelDecoratorPreference
extends PreferencePage
implements IWorkbenchPreferencePage,
IContextProvider {
    private static final String DECORATION_KEY = "org.eclipse.datatools.connectivity.sqm.core.ui.column.decoration";
    private static final String DECORATION = ResourceLoader.getResourceLoader().queryString("DATATOOLS.CORE.UI.PREFERENCES.COLUMN.DECORATION");
    private static final String COLUMN_TAB = ResourceLoader.getResourceLoader().queryString("DATATOOLS.CORE.UI.PREFERENCES.COLUMN.TAB");
    private static final String FORMAT = ResourceLoader.getResourceLoader().queryString("DATATOOLS.CORE.UI.PREFERENCES.COLUMN.FORMAT");
    private static final String COLUMN_FORMAT = ResourceLoader.getResourceLoader().queryString("DATATOOLS.CORE.UI.PREFERENCES.COLUMN.CFORMAT");
    private static final String VARIABLE = ResourceLoader.getResourceLoader().queryString("DATATOOLS.CORE.UI.PREFERENCES.COLUMN.VARIABLE");
    private static final String EXAMPLE = ResourceLoader.getResourceLoader().queryString("DATATOOLS.CORE.UI.PREFERENCES.COLUMN.EXAMPLE");
    private static final String TITLE = ResourceLoader.getResourceLoader().queryString("DATATOOLS.CORE.UI.PREFERENCES.COLUMN.TITLE");
    private static final String MESSAGE = ResourceLoader.getResourceLoader().queryString("DATATOOLS.CORE.UI.PREFERENCES.COLUMN.MESSAGE");
    private static final String DATATYPE_DESCRIPTION = ResourceLoader.getResourceLoader().queryString("DATATOOLS.CORE.UI.PREFERENCES.COLUMN.DATATYPE_DESC");
    private static final String NULLABLE_DESCRIPTION = ResourceLoader.getResourceLoader().queryString("DATATOOLS.CORE.UI.PREFERENCES.COLUMN.NULLABLE_DESC");
    private static final String PK_DESCRIPTION = ResourceLoader.getResourceLoader().queryString("DATATOOLS.CORE.UI.PREFERENCES.COLUMN.PK_DESC");
    private static final String FK_DESCRIPTION = ResourceLoader.getResourceLoader().queryString("DATATOOLS.CORE.UI.PREFERENCES.COLUMN.FK_DESC");
    private static final String DATATYPE = "{datatype}";
    private static final String NULLABLE = "{nullable}";
    private static final String FK = "{foreignKey}";
    private static final String PK = "{primaryKey}";
    private static final String DATATYPE_REG = "\\{datatype\\}";
    private static final String NULLABLE_REG = "\\{nullable\\}";
    private static final String FK_REG = "\\{foreignKey\\}";
    private static final String PK_REG = "\\{primaryKey\\}";
    private static final String EX_DATATYPE = "VARCHAR(14)";
    private static final String EX_NAME = "NAME";
    private static final String EX_NULLABLE = "Nullable";
    private static final String EX_FK = "FK";
    private static final String EX_PK = "PK";
    private static final String BLANK = "";
    private static final String SPACE = " ";
    private static final String BEG_BRACKET = "[";
    private static final String END_BRACKET = "]";
    private static final Preferences preferences = new InstanceScope().getNode("org.eclipse.datatools.connectivity.sqm.core.ui");
    private Text exampleText;
    private Text columnText;
    private ContextProviderDelegate contextProviderDelegate = new ContextProviderDelegate(RDBCoreUIPlugin.getDefault().getBundle().getSymbolicName());

    private String getReplacement(String columnString, boolean shouldKey, String reg_key, String key, String replacement) {
        if (shouldKey) {
            return columnString.replaceAll(reg_key, replacement);
        }
        int index = columnString.indexOf(key);
        if (index != -1) {
            int previousIndex = columnString.substring(0, index).lastIndexOf("}");
            int nextIndex = columnString.indexOf("}", columnString.substring(0, index).length());
            int n = nextIndex = columnString.indexOf("{", columnString.substring(0, index).length() + 1) != -1 ? ++nextIndex : -1;
            columnString = previousIndex == -1 && nextIndex == -1 ? columnString.replaceAll(key, BLANK) : (nextIndex == -1 ? String.valueOf(columnString.substring(0, previousIndex + 1)) + columnString.substring(index + key.length(), columnString.length()) : (previousIndex == -1 ? String.valueOf(columnString.substring(0, index)) + columnString.substring(nextIndex, columnString.length()) : String.valueOf(columnString.substring(0, previousIndex + 1)) + columnString.substring(nextIndex, columnString.length())));
        }
        return columnString;
    }

    private String getColumnString(String columnString, String dataType, boolean nullable, boolean pk, boolean fk) {
        if (columnString != null && !columnString.equals(BLANK)) {
            try {
                if (!nullable) {
                    while (columnString.indexOf(NULLABLE) != -1) {
                        columnString = this.getReplacement(columnString, nullable, NULLABLE_REG, NULLABLE, EX_NULLABLE);
                    }
                }
                if (!fk) {
                    while (columnString.indexOf(FK) != -1) {
                        columnString = this.getReplacement(columnString, fk, FK_REG, FK, EX_FK);
                    }
                }
                if (!pk) {
                    while (columnString.indexOf(PK) != -1) {
                        columnString = this.getReplacement(columnString, pk, PK_REG, PK, EX_PK);
                    }
                }
                if (columnString.indexOf(DATATYPE) == -1) {
                    columnString = this.getReplacement(columnString, true, DATATYPE_REG, DATATYPE, dataType);
                }
                if (columnString.indexOf(NULLABLE) != -1 && nullable) {
                    columnString = this.getReplacement(columnString, nullable, NULLABLE_REG, NULLABLE, EX_NULLABLE);
                }
                if (columnString.indexOf(FK) != -1 && fk) {
                    columnString = this.getReplacement(columnString, fk, FK_REG, FK, EX_FK);
                }
                if (columnString.indexOf(PK) != -1 && pk) {
                    columnString = this.getReplacement(columnString, pk, PK_REG, PK, EX_PK);
                }
                if (columnString.indexOf(DATATYPE) != -1) {
                    columnString = this.getReplacement(columnString, true, DATATYPE_REG, DATATYPE, dataType);
                }
            }
            catch (PatternSyntaxException patternSyntaxException) {
                return BLANK;
            }
        }
        return SPACE + columnString.trim();
    }

    private String getExampleTextDefault() {
        return "NAME " + this.getColumnString(this.columnText.getText(), EX_DATATYPE, true, true, true);
    }

    private String getColumnTextDefault() {
        return "[{datatype} {nullable} {primaryKey} {foreignKey}]";
    }

    private void addToTextColumn(List list) {
        if (list.contains(NULLABLE)) {
            this.columnText.setText(NULLABLE + this.columnText.getText());
        }
        if (list.contains(FK)) {
            this.columnText.setText(FK + this.columnText.getText());
        }
        if (list.contains(PK)) {
            this.columnText.setText(PK + this.columnText.getText());
        }
        if (list.contains(DATATYPE)) {
            this.columnText.setText(DATATYPE + this.columnText.getText());
        }
    }

    private Control getColumnTabDecorationControl(TabFolder folder) {
        Composite composite = new Composite((Composite)folder, 0);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setLayout((Layout)new GridLayout(3, false));
        Label label = new Label(composite, 0);
        GridData data = new GridData();
        data.horizontalSpan = 3;
        label.setLayoutData((Object)data);
        label.setText(FORMAT);
        label = new Label(composite, 0);
        label.setText(COLUMN_FORMAT);
        this.columnText = new Text(composite, 2048);
        GridData columnLayout = new GridData(768);
        columnLayout.grabExcessHorizontalSpace = true;
        columnLayout.widthHint = 240;
        this.columnText.setLayoutData((Object)columnLayout);
        this.columnText.setText(preferences.get(DECORATION_KEY, this.getColumnTextDefault()));
        this.columnText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                LabelDecoratorPreference.this.exampleText.setText(LabelDecoratorPreference.this.getExampleTextDefault());
            }
        });
        Button variableButton = new Button(composite, 8);
        variableButton.setText(VARIABLE);
        variableButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ElementTreeSelectionDialog dlg = new ElementTreeSelectionDialog(LabelDecoratorPreference.this.getShell(), (ILabelProvider)new LabelProvider(){

                    public String getText(Object element) {
                        if (element == LabelDecoratorPreference.NULLABLE) {
                            return NULLABLE_DESCRIPTION;
                        }
                        if (element == LabelDecoratorPreference.FK) {
                            return FK_DESCRIPTION;
                        }
                        if (element == LabelDecoratorPreference.PK) {
                            return PK_DESCRIPTION;
                        }
                        if (element == LabelDecoratorPreference.DATATYPE) {
                            return DATATYPE_DESCRIPTION;
                        }
                        return null;
                    }
                }, new ITreeContentProvider(){

                    public Object[] getChildren(Object parentElement) {
                        return new String[]{LabelDecoratorPreference.NULLABLE, LabelDecoratorPreference.FK, LabelDecoratorPreference.PK, LabelDecoratorPreference.DATATYPE};
                    }

                    public Object getParent(Object element) {
                        return null;
                    }

                    public boolean hasChildren(Object element) {
                        return false;
                    }

                    public Object[] getElements(Object inputElement) {
                        return this.getChildren(inputElement);
                    }

                    public void dispose() {
                    }

                    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                    }
                });
                dlg.setTitle(TITLE);
                dlg.setMessage(MESSAGE);
                dlg.setInput((Object)LabelDecoratorPreference.NULLABLE);
                if (dlg.open() == 0) {
                    LabelDecoratorPreference.this.addToTextColumn(Arrays.asList(dlg.getResult()));
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        label = new Label(composite, 0);
        label.setText(EXAMPLE);
        this.exampleText = new Text(composite, 2056);
        this.exampleText.setLayoutData((Object)new GridData(768));
        this.exampleText.setText(this.getExampleTextDefault());
        return composite;
    }

    private void addColumnTabDecoration(TabFolder folder) {
        TabItem columnItem = new TabItem(folder, 0);
        columnItem.setText(COLUMN_TAB);
        columnItem.setControl(this.getColumnTabDecorationControl(folder));
    }

    private void addMultiTabDecorations(Composite parent) {
        TabFolder folder = new TabFolder(parent, 128);
        this.createStandardLayout((Composite)folder);
        this.addColumnTabDecoration(folder);
    }

    private void createStandardLayout(Composite composite) {
        GridLayout layout = new GridLayout();
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
    }

    private boolean isSelected(String key) {
        String columnText = this.columnText.getText();
        return columnText != null && columnText.indexOf(key) != -1;
    }

    private boolean isNullable() {
        return this.isSelected(NULLABLE);
    }

    private boolean isFK() {
        return this.isSelected(FK);
    }

    private boolean isPK() {
        return this.isSelected(PK);
    }

    private boolean isDatatype() {
        return this.isSelected(DATATYPE);
    }

    protected void performDefaults() {
        this.exampleText.setText(this.getExampleTextDefault());
        this.columnText.setText(this.getColumnTextDefault());
    }

    public boolean performOk() {
        preferences.put(DECORATION_KEY, this.columnText.getText());
        IDataToolsUIServiceManager.INSTANCE.refreshColumnDecorationService();
        return true;
    }

    protected Control createContents(Composite container) {
        Composite parent = new Composite(container, 0);
        this.createStandardLayout(parent);
        new Label(parent, 0).setText(DECORATION);
        this.addMultiTabDecorations(parent);
        return parent;
    }

    public void init(IWorkbench workbench) {
    }

    public String getColumnDecoration(String dataType, boolean isNullable, boolean isPK, boolean isFK) {
        return this.getColumnString(preferences.get(DECORATION_KEY, this.getColumnTextDefault()), dataType, isNullable, isPK, isFK);
    }

    public IContext getContext(Object target) {
        return this.contextProviderDelegate.getContext(target);
    }

    public int getContextChangeMask() {
        return this.contextProviderDelegate.getContextChangeMask();
    }

    public String getSearchExpression(Object target) {
        return this.contextProviderDelegate.getSearchExpression(target);
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        this.getShell().setData(HelpUtil.CONTEXT_PROVIDER_KEY, (Object)this);
        HelpUtil.setHelp((Control)this.getControl(), (String)HelpUtil.getContextId((String)"LABEL_DECORATOR_PREFERENCE_PAGE", (String)RDBCoreUIPlugin.getDefault().getBundle().getSymbolicName()));
    }
}

