/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.trace4cps.ui.view;

import org.eclipse.trace4cps.common.jfreechart.ui.viewers.BackReferenceProvider;
import org.eclipse.trace4cps.core.IAttributeAware;
import org.eclipse.trace4cps.core.IClaim;
import org.eclipse.trace4cps.ui.view.EclipseSelectionWrapper;
import org.jfree.data.ComparableObjectItem;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYIntervalDataItem;
import org.jfree.data.xy.XYIntervalSeries;
import org.jfree.data.xy.XYIntervalSeriesCollection;

public class ClaimDataItem
extends XYIntervalDataItem
implements BackReferenceProvider<EclipseSelectionWrapper> {
    private static final long serialVersionUID = 1L;
    private final EclipseSelectionWrapper backReference;

    public ClaimDataItem(IClaim claim, double xmin, double xmax, double ymin, double ymax) {
        super((xmin + xmax) / 2.0, xmin, xmax, (ymin + ymax) / 2.0, ymin, ymax);
        this.backReference = new EclipseSelectionWrapper((IAttributeAware)claim);
    }

    public EclipseSelectionWrapper getBackReference() {
        return this.backReference;
    }

    public String toString() {
        return "ClaimDataItem[claim=" + this.getBackReference().getSelectedTraceItem() + "]";
    }

    public static ClaimDataItem getFrom(XYDataset ds, int series, int item) {
        XYIntervalSeriesCollection sc;
        XYIntervalSeries s;
        ComparableObjectItem o;
        if (ds instanceof XYIntervalSeriesCollection && (o = (s = (sc = (XYIntervalSeriesCollection)ds).getSeries(series)).getDataItem(item)) instanceof ClaimDataItem) {
            return (ClaimDataItem)o;
        }
        return null;
    }
}

