/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.trace4cps.ui.view.verify;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.trace4cps.analysis.mtl.ExplanationTable;
import org.eclipse.trace4cps.analysis.mtl.InformativePrefix;
import org.eclipse.trace4cps.analysis.mtl.MtlBuilder;
import org.eclipse.trace4cps.analysis.mtl.MtlFormula;
import org.eclipse.trace4cps.analysis.mtl.MtlUtil;
import org.eclipse.trace4cps.analysis.mtl.State;
import org.eclipse.trace4cps.analysis.signal.impl.PsopHelper;
import org.eclipse.trace4cps.analysis.stl.StlFormula;
import org.eclipse.trace4cps.analysis.stl.impl.StlNeg;
import org.eclipse.trace4cps.analysis.stl.impl.StlTrue;
import org.eclipse.trace4cps.analysis.stl.impl.StlUntil;
import org.eclipse.trace4cps.core.IPsop;
import org.eclipse.trace4cps.core.TracePart;
import org.eclipse.trace4cps.core.impl.Event;
import org.eclipse.trace4cps.core.impl.ModifiableTrace;
import org.eclipse.trace4cps.tl.VerificationResult;
import org.eclipse.trace4cps.ui.view.TraceView;
import org.eclipse.trace4cps.ui.view.verify.CheckNode;
import org.eclipse.trace4cps.ui.view.verify.FileNode;
import org.eclipse.trace4cps.ui.view.verify.ParameterizedCheckNode;
import org.eclipse.trace4cps.ui.view.verify.ResultNode;
import org.eclipse.trace4cps.ui.view.verify.ResultTree;
import org.eclipse.trace4cps.ui.view.verify.SpecNode;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import org.osgi.framework.Bundle;

public class VerificationResultView
extends ViewPart
implements IResourceChangeListener,
IDoubleClickListener,
IPartListener {
    public static final String VIEW_ID = "org.eclipse.trace4cps.ui.view.verify.VerificationResultView";
    private ResultTree tree = new ResultTree();
    private TreeViewer viewer;

    public static void showView(final String specFile, final String traceFile, final VerificationResult results, final TraceView traceView) {
        IWorkbench workbench = PlatformUI.getWorkbench();
        workbench.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                    IViewPart view = page.showView(VerificationResultView.VIEW_ID);
                    ((VerificationResultView)view).setResult(specFile, traceFile, results, traceView);
                }
                catch (CoreException e) {
                    ErrorDialog.openError(null, (String)"ETL Verification Error", (String)"Failed to update result view", (IStatus)e.getStatus());
                }
            }
        });
    }

    private void setResult(String specPath, String tracePath, VerificationResult res, TraceView view) {
        this.tree.refresh();
        this.tree.add(tracePath, specPath, res, view);
        this.tree.refresh();
        this.viewer.refresh();
        this.viewer.expandToLevel(4);
    }

    public void partActivated(IWorkbenchPart part) {
    }

    public void partBroughtToTop(IWorkbenchPart part) {
    }

    public void partClosed(IWorkbenchPart part) {
        this.tree.partClosed(part);
        this.viewer.refresh();
    }

    public void partDeactivated(IWorkbenchPart part) {
    }

    public void partOpened(IWorkbenchPart part) {
    }

    public void createPartControl(Composite c) {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        workspace.addResourceChangeListener((IResourceChangeListener)this);
        GridLayoutFactory.swtDefaults().numColumns(1).applyTo(c);
        this.viewer = new TreeViewer(c, 4);
        GridDataFactory.swtDefaults().applyTo((Control)this.viewer.getTree());
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.viewer.getTree());
        this.viewer.setContentProvider((IContentProvider)new TreeContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new TreeLabelProvider());
        this.viewer.setInput((Object)this.tree);
        this.viewer.addDoubleClickListener((IDoubleClickListener)this);
        IWorkbench workbench = PlatformUI.getWorkbench();
        workbench.getActiveWorkbenchWindow().getActivePage().addPartListener((IPartListener)this);
    }

    public void dispose() {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        workspace.removeResourceChangeListener((IResourceChangeListener)this);
        IWorkbench workbench = PlatformUI.getWorkbench();
        workbench.getActiveWorkbenchWindow().getActivePage().removePartListener((IPartListener)this);
        super.dispose();
    }

    public void setFocus() {
    }

    public void resourceChanged(IResourceChangeEvent event) {
        this.tree.refresh();
        IWorkbench workbench = PlatformUI.getWorkbench();
        workbench.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                VerificationResultView.this.viewer.refresh();
            }
        });
    }

    public void doubleClick(DoubleClickEvent event) {
        Object cn;
        IStructuredSelection selection = (IStructuredSelection)event.getSelection();
        if (selection == null || selection.isEmpty()) {
            return;
        }
        Object sel = selection.getFirstElement();
        if (sel instanceof CheckNode && !((CheckNode)(cn = (CheckNode)sel)).isParameterized() && ((CheckNode)cn).getMTLresult().getExplanation() != null) {
            this.createCounterExampleTrace(((CheckNode)cn).getResult(), ((CheckNode)cn).getFormula(), ((CheckNode)cn).getTraceView());
        }
        if (sel instanceof ParameterizedCheckNode && ((ParameterizedCheckNode)(cn = (ParameterizedCheckNode)sel)).getMTLresult().getExplanation() != null) {
            this.createCounterExampleTrace(((ParameterizedCheckNode)cn).getResult(), ((ParameterizedCheckNode)cn).getFormula(), ((ParameterizedCheckNode)cn).getTraceView());
        }
    }

    private void createCounterExampleTrace(VerificationResult r, MtlFormula formula, TraceView view) {
        ModifiableTrace trace = (ModifiableTrace)view.getTrace();
        ExplanationTable ex = r.getResult(formula).getExplanation();
        List states = ex.getTrace();
        this.addMtlFormula(r, formula, trace, ex, states);
        this.setGrouping(view);
    }

    private void setGrouping(TraceView view) {
        HashSet<String> groupAtts = new HashSet<String>();
        if (view.getViewConfiguration().getGroupingAttributes(TracePart.EVENT) != null) {
            groupAtts.addAll(view.getViewConfiguration().getGroupingAttributes(TracePart.EVENT));
        }
        groupAtts.add("phi");
        groupAtts.add("sat");
        view.getViewConfiguration().setGroupingAttributes(TracePart.EVENT, groupAtts);
        HashSet<String> groupAtts2 = new HashSet<String>();
        if (view.getViewConfiguration().getGroupingAttributes(TracePart.CLAIM) != null) {
            groupAtts2.addAll(view.getViewConfiguration().getGroupingAttributes(TracePart.CLAIM));
        }
        groupAtts2.add("phi");
        view.getViewConfiguration().setGroupingAttributes(TracePart.CLAIM, groupAtts2);
        view.update();
    }

    private void addMtlFormula(VerificationResult r, MtlFormula formula, ModifiableTrace trace, ExplanationTable ex, List<? extends State> states) {
        for (MtlFormula phi : MtlUtil.getSubformulas((MtlFormula)formula)) {
            if (phi.equals(MtlBuilder.TRUE()) || !r.contains(phi)) continue;
            if (phi instanceof StlFormula) {
                this.addStlExplanationClaims(r, (StlFormula)phi, trace);
                continue;
            }
            this.addMtlExplanationEvents(phi, states, r, trace, ex);
        }
    }

    private void addMtlExplanationEvents(MtlFormula phi, List<? extends State> states, VerificationResult r, ModifiableTrace trace, ExplanationTable ex) {
        for (ExplanationTable.Region region : ex.getRegions(phi)) {
            if (region.getValue() == InformativePrefix.NOT_COMPUTED) continue;
            String color = "black";
            switch (region.getValue()) {
                case BAD: {
                    color = "dark_red";
                    break;
                }
                case GOOD: {
                    color = "dark_green";
                    break;
                }
                case NON_INFORMATIVE: {
                    color = "dark_blue";
                    break;
                }
                case NOT_COMPUTED: {
                    color = "gray";
                }
            }
            ArrayList<Event> events = new ArrayList<Event>();
            int i = region.getStartIndex();
            while (i <= region.getEndIndex()) {
                Event e = new Event(states.get(i).getTimestamp());
                e.setAttribute("phi", r.getName(phi));
                e.setAttribute("color", color);
                e.setAttribute("type", "STL");
                e.setAttribute("sat", region.getValue().toString());
                events.add(e);
                ++i;
            }
            trace.addEvents(events);
        }
    }

    private void addStlExplanationClaims(VerificationResult r, StlFormula phi, ModifiableTrace trace) {
        if (!this.isGlobally(phi)) {
            IPsop p = phi.getSignal();
            List claims = PsopHelper.createClaimRepresentationOfSatisfaction((IPsop)p, (String)r.getName((MtlFormula)phi));
            trace.addClaims((Collection)claims);
        }
    }

    private boolean isGlobally(StlFormula phi) {
        StlFormula f1;
        StlFormula phi2;
        return phi instanceof StlNeg && (phi2 = ((StlNeg)phi).getFormula()) instanceof StlUntil && (f1 = ((StlUntil)phi2).getLeft()) instanceof StlTrue && ((StlUntil)phi2).isUntimed();
    }

    private final class TreeContentProvider
    implements ITreeContentProvider {
        private TreeContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer arg0, Object arg1, Object arg2) {
        }

        public Object[] getChildren(Object o) {
            if (o instanceof FileNode) {
                return ((FileNode)o).getSpecs().toArray();
            }
            if (o instanceof SpecNode) {
                return ((SpecNode)o).getResults().toArray();
            }
            if (o instanceof ResultNode) {
                return ((ResultNode)o).getChecks().toArray();
            }
            if (o instanceof CheckNode) {
                return ((CheckNode)o).getSubChecks().toArray();
            }
            return new Object[0];
        }

        public Object[] getElements(Object input) {
            return ((VerificationResultView)VerificationResultView.this).tree.traces.toArray();
        }

        public Object getParent(Object o) {
            return null;
        }

        public boolean hasChildren(Object o) {
            if (o instanceof FileNode) {
                return !((FileNode)o).getSpecs().isEmpty();
            }
            if (o instanceof SpecNode) {
                return !((SpecNode)o).getResults().isEmpty();
            }
            if (o instanceof ResultNode) {
                return !((ResultNode)o).getChecks().isEmpty();
            }
            if (o instanceof CheckNode) {
                return ((CheckNode)o).isParameterized();
            }
            return false;
        }
    }

    private final class TreeLabelProvider
    implements ILabelProvider {
        private Image good;
        private Image bad;
        private Image neutral;

        public TreeLabelProvider() {
            Bundle bundle = Platform.getBundle((String)"org.eclipse.trace4cps.ui");
            URL fullPathString = FileLocator.find((Bundle)bundle, (IPath)new Path("icons/passed.png"), null);
            ImageDescriptor imageDesc = ImageDescriptor.createFromURL((URL)fullPathString);
            this.good = imageDesc.createImage();
            fullPathString = FileLocator.find((Bundle)bundle, (IPath)new Path("icons/delete.png"), null);
            imageDesc = ImageDescriptor.createFromURL((URL)fullPathString);
            this.bad = imageDesc.createImage();
            fullPathString = FileLocator.find((Bundle)bundle, (IPath)new Path("icons/help_contents.png"), null);
            imageDesc = ImageDescriptor.createFromURL((URL)fullPathString);
            this.neutral = imageDesc.createImage();
        }

        public void addListener(ILabelProviderListener arg0) {
        }

        public void dispose() {
            this.good.dispose();
            this.bad.dispose();
            this.neutral.dispose();
        }

        public boolean isLabelProperty(Object arg0, String arg1) {
            return false;
        }

        public void removeListener(ILabelProviderListener arg0) {
        }

        public Image getImage(Object o) {
            if (o instanceof ResultNode) {
                ResultNode r = (ResultNode)o;
                if (r.getType() == InformativePrefix.GOOD) {
                    return this.good;
                }
                if (r.getType() == InformativePrefix.BAD) {
                    return this.bad;
                }
                return this.neutral;
            }
            ISharedImages im = PlatformUI.getWorkbench().getSharedImages();
            return im.getImage("IMG_OBJ_FILE");
        }

        public String getText(Object o) {
            if (o instanceof FileNode) {
                return ((FileNode)o).getTraceFile().getName();
            }
            if (o instanceof SpecNode) {
                return ((SpecNode)o).getSpecFile().getName();
            }
            if (o instanceof ResultNode) {
                ResultNode rn = (ResultNode)o;
                return rn.getType().toString();
            }
            if (o instanceof CheckNode) {
                CheckNode cn = (CheckNode)o;
                if (cn.isParameterized()) {
                    return String.valueOf(cn.getCheckName()) + " [" + cn.getSubChecks().size() + "]";
                }
                return cn.getCheckName();
            }
            if (o instanceof ParameterizedCheckNode) {
                return ((ParameterizedCheckNode)o).getCheckName();
            }
            return o.toString();
        }
    }
}

