/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.trace4cps.vis.jfree.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.trace4cps.core.IAttributeAware;
import org.eclipse.trace4cps.core.impl.TraceHelper;
import org.eclipse.trace4cps.vis.jfree.impl.Cell;

public class Partition<T extends IAttributeAware>
implements Iterable<Cell<T>> {
    protected final List<Cell<T>> cells = new ArrayList<Cell<T>>();

    public static <T extends IAttributeAware> Partition<T> createAttributePartition(List<T> aa, Collection<String> atts) {
        Partition<T> partition = new Partition<T>();
        HashMap<String, Cell<IAttributeAware>> m = new HashMap<String, Cell<IAttributeAware>>();
        for (IAttributeAware a : aa) {
            String attVals = TraceHelper.getValues((IAttributeAware)a, atts, (boolean)false);
            Cell<IAttributeAware> cell = (Cell<IAttributeAware>)m.get(attVals);
            if (cell == null) {
                cell = super.createCell(attVals);
                m.put(attVals, cell);
            }
            cell.add(a);
        }
        return partition;
    }

    private Cell<T> createCell(String description) {
        Cell c = new Cell(description);
        this.cells.add(c);
        return c;
    }

    protected Partition() {
    }

    public int size() {
        return this.cells.size();
    }

    public Cell<T> get(int i) {
        return this.cells.get(i);
    }

    public int getIndex(Cell<T> c) {
        return this.cells.indexOf(c);
    }

    public void sortCells() {
        Collections.sort(this.cells, new Comparator<Cell<T>>(){

            @Override
            public int compare(Cell<T> o1, Cell<T> o2) {
                return o2.getDescription().compareTo(o1.getDescription());
            }
        });
    }

    @Override
    public Iterator<Cell<T>> iterator() {
        return this.cells.iterator();
    }
}

