/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.trace4cps.common.jfreechart.ui.internal;

import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Stack;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.awt.SWT_AWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.trace4cps.common.jfreechart.ui.JFreeChartUIPlugin;

public class SWT_AWT_PATCH_377104
extends WindowAdapter {
    private static final Method SHELL_SET_ACTIVE_CONTROL_METHOD;
    private final Composite embedded;

    static {
        Method setActiveControlMethod = null;
        try {
            setActiveControlMethod = Shell.class.getDeclaredMethod("setActiveControl", Control.class);
            setActiveControlMethod.setAccessible(true);
        }
        catch (NoSuchMethodException | SecurityException e) {
            String msg = "Patch for bug 377104 cannot be applied: org.eclipse.swt.widgets.Shell#setActiveControl(org.eclipse.swt.widgets.Control) not available or accessible. This will result in embedded workbench parts not getting activated.";
            Status status = new Status(4, "org.eclipse.trace4cps.common.jfreechart.ui", msg, (Throwable)e);
            JFreeChartUIPlugin.getDefault().getLog().log((IStatus)status);
            setActiveControlMethod = null;
        }
        SHELL_SET_ACTIVE_CONTROL_METHOD = setActiveControlMethod;
    }

    public static Frame new_Frame(Composite parent) {
        Frame frame = SWT_AWT.new_Frame((Composite)parent);
        if (SHELL_SET_ACTIVE_CONTROL_METHOD != null) {
            frame.addWindowListener(new SWT_AWT_PATCH_377104(parent));
        }
        return frame;
    }

    private SWT_AWT_PATCH_377104(Composite embedded) {
        this.embedded = embedded;
    }

    @Override
    public void windowActivated(WindowEvent event) {
        if (!this.embedded.isDisposed()) {
            try {
                this.embedded.getDisplay().asyncExec(this::activateEmbedded);
            }
            catch (SWTException e) {
                String msg = "Embedded part was not able to set active control on Shell. This will result in other workbench parts not getting activated.";
                Status status = new Status(4, "org.eclipse.trace4cps.common.jfreechart.ui", msg, (Throwable)e);
                JFreeChartUIPlugin.getDefault().getLog().log((IStatus)status);
            }
        }
    }

    private void activateEmbedded() {
        try {
            if (Display.getCurrent().getFocusControl() != this.embedded) {
                return;
            }
            Stack<Composite> stack = new Stack<Composite>();
            Composite current = this.embedded;
            Shell shell = this.embedded.getShell();
            while (current != null && !(current instanceof Shell)) {
                stack.push(current.getParent());
                current = current.getParent();
            }
            while (!stack.isEmpty()) {
                SHELL_SET_ACTIVE_CONTROL_METHOD.invoke((Object)shell, stack.pop());
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException | SWTException e) {
            String msg = "Embedded part was not able to set active control on Shell. This will result in other workbench parts not getting activated.";
            Status status = new Status(4, "org.eclipse.trace4cps.common.jfreechart.ui", msg, e);
            JFreeChartUIPlugin.getDefault().getLog().log((IStatus)status);
        }
    }
}

