/**
 * Copyright (c) 2021, 2024 Contributors to the Eclipse Foundation
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 */

/*
 * generated by Xtext 2.22.0
 */
grammar InternalEtl;

options {
	superClass=AbstractInternalContentAssistParser;
}

@lexer::header {
package org.eclipse.trace4cps.tl.ide.contentassist.antlr.internal;

// Hack: Use our own Lexer superclass by means of import. 
// Currently there is no other way to specify the superclass for the lexer.
import org.eclipse.xtext.ide.editor.contentassist.antlr.internal.Lexer;
}

@parser::header {
package org.eclipse.trace4cps.tl.ide.contentassist.antlr.internal;

import java.io.InputStream;
import org.eclipse.xtext.*;
import org.eclipse.xtext.parser.*;
import org.eclipse.xtext.parser.impl.*;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.parser.antlr.XtextTokenStream;
import org.eclipse.xtext.parser.antlr.XtextTokenStream.HiddenTokens;
import org.eclipse.xtext.ide.editor.contentassist.antlr.internal.AbstractInternalContentAssistParser;
import org.eclipse.xtext.ide.editor.contentassist.antlr.internal.DFA;
import org.eclipse.trace4cps.tl.services.EtlGrammarAccess;

}
@parser::members {
	private EtlGrammarAccess grammarAccess;

	public void setGrammarAccess(EtlGrammarAccess grammarAccess) {
		this.grammarAccess = grammarAccess;
	}

	@Override
	protected Grammar getGrammar() {
		return grammarAccess.getGrammar();
	}

	@Override
	protected String getValueForTokenName(String tokenName) {
		return tokenName;
	}
}

// Entry rule entryRuleEtlModel
entryRuleEtlModel
:
{ before(grammarAccess.getEtlModelRule()); }
	 ruleEtlModel
{ after(grammarAccess.getEtlModelRule()); } 
	 EOF 
;

// Rule EtlModel
ruleEtlModel 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getEtlModelAccess().getElementsAssignment()); }
		(rule__EtlModel__ElementsAssignment)*
		{ after(grammarAccess.getEtlModelAccess().getElementsAssignment()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleTopLevelModelElement
entryRuleTopLevelModelElement
:
{ before(grammarAccess.getTopLevelModelElementRule()); }
	 ruleTopLevelModelElement
{ after(grammarAccess.getTopLevelModelElementRule()); } 
	 EOF 
;

// Rule TopLevelModelElement
ruleTopLevelModelElement 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getTopLevelModelElementAccess().getAlternatives()); }
		(rule__TopLevelModelElement__Alternatives)
		{ after(grammarAccess.getTopLevelModelElementAccess().getAlternatives()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleSignal
entryRuleSignal
:
{ before(grammarAccess.getSignalRule()); }
	 ruleSignal
{ after(grammarAccess.getSignalRule()); } 
	 EOF 
;

// Rule Signal
ruleSignal 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getSignalAccess().getAlternatives()); }
		(rule__Signal__Alternatives)
		{ after(grammarAccess.getSignalAccess().getAlternatives()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleConvSpec
entryRuleConvSpec
:
{ before(grammarAccess.getConvSpecRule()); }
	 ruleConvSpec
{ after(grammarAccess.getConvSpecRule()); } 
	 EOF 
;

// Rule ConvSpec
ruleConvSpec 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getConvSpecAccess().getGroup()); }
		(rule__ConvSpec__Group__0)
		{ after(grammarAccess.getConvSpecAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleFormula
entryRuleFormula
:
{ before(grammarAccess.getFormulaRule()); }
	 ruleFormula
{ after(grammarAccess.getFormulaRule()); } 
	 EOF 
;

// Rule Formula
ruleFormula 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getFormulaAccess().getAlternatives()); }
		(rule__Formula__Alternatives)
		{ after(grammarAccess.getFormulaAccess().getAlternatives()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleStlAp
entryRuleStlAp
:
{ before(grammarAccess.getStlApRule()); }
	 ruleStlAp
{ after(grammarAccess.getStlApRule()); } 
	 EOF 
;

// Rule StlAp
ruleStlAp 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getStlApAccess().getGroup()); }
		(rule__StlAp__Group__0)
		{ after(grammarAccess.getStlApAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleMtlAp
entryRuleMtlAp
:
{ before(grammarAccess.getMtlApRule()); }
	 ruleMtlAp
{ after(grammarAccess.getMtlApRule()); } 
	 EOF 
;

// Rule MtlAp
ruleMtlAp 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getMtlApAccess().getGroup()); }
		(rule__MtlAp__Group__0)
		{ after(grammarAccess.getMtlApAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleAttributeFilter
entryRuleAttributeFilter
:
{ before(grammarAccess.getAttributeFilterRule()); }
	 ruleAttributeFilter
{ after(grammarAccess.getAttributeFilterRule()); } 
	 EOF 
;

// Rule AttributeFilter
ruleAttributeFilter 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getAttributeFilterAccess().getGroup()); }
		(rule__AttributeFilter__Group__0)
		{ after(grammarAccess.getAttributeFilterAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleKeyVal
entryRuleKeyVal
:
{ before(grammarAccess.getKeyValRule()); }
	 ruleKeyVal
{ after(grammarAccess.getKeyValRule()); } 
	 EOF 
;

// Rule KeyVal
ruleKeyVal 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getKeyValAccess().getGroup()); }
		(rule__KeyVal__Group__0)
		{ after(grammarAccess.getKeyValAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleIdString
entryRuleIdString
:
{ before(grammarAccess.getIdStringRule()); }
	 ruleIdString
{ after(grammarAccess.getIdStringRule()); } 
	 EOF 
;

// Rule IdString
ruleIdString 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getIdStringAccess().getAlternatives()); }
		(rule__IdString__Alternatives)
		{ after(grammarAccess.getIdStringAccess().getAlternatives()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleInterval
entryRuleInterval
:
{ before(grammarAccess.getIntervalRule()); }
	 ruleInterval
{ after(grammarAccess.getIntervalRule()); } 
	 EOF 
;

// Rule Interval
ruleInterval 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getIntervalAccess().getGroup()); }
		(rule__Interval__Group__0)
		{ after(grammarAccess.getIntervalAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleIntervalSS
entryRuleIntervalSS
:
{ before(grammarAccess.getIntervalSSRule()); }
	 ruleIntervalSS
{ after(grammarAccess.getIntervalSSRule()); } 
	 EOF 
;

// Rule IntervalSS
ruleIntervalSS 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getIntervalSSAccess().getGroup()); }
		(rule__IntervalSS__Group__0)
		{ after(grammarAccess.getIntervalSSAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleIntervalSN
entryRuleIntervalSN
:
{ before(grammarAccess.getIntervalSNRule()); }
	 ruleIntervalSN
{ after(grammarAccess.getIntervalSNRule()); } 
	 EOF 
;

// Rule IntervalSN
ruleIntervalSN 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getIntervalSNAccess().getGroup()); }
		(rule__IntervalSN__Group__0)
		{ after(grammarAccess.getIntervalSNAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleIntervalNS
entryRuleIntervalNS
:
{ before(grammarAccess.getIntervalNSRule()); }
	 ruleIntervalNS
{ after(grammarAccess.getIntervalNSRule()); } 
	 EOF 
;

// Rule IntervalNS
ruleIntervalNS 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getIntervalNSAccess().getGroup()); }
		(rule__IntervalNS__Group__0)
		{ after(grammarAccess.getIntervalNSAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleIntervalNN
entryRuleIntervalNN
:
{ before(grammarAccess.getIntervalNNRule()); }
	 ruleIntervalNN
{ after(grammarAccess.getIntervalNNRule()); } 
	 EOF 
;

// Rule IntervalNN
ruleIntervalNN 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getIntervalNNAccess().getGroup()); }
		(rule__IntervalNN__Group__0)
		{ after(grammarAccess.getIntervalNNAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Rule TimeUnitEnum
ruleTimeUnitEnum
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getTimeUnitEnumAccess().getAlternatives()); }
		(rule__TimeUnitEnum__Alternatives)
		{ after(grammarAccess.getTimeUnitEnumAccess().getAlternatives()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Rule AndOr
ruleAndOr
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getAndOrAccess().getAlternatives()); }
		(rule__AndOr__Alternatives)
		{ after(grammarAccess.getAndOrAccess().getAlternatives()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Rule CompOp
ruleCompOp
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getCompOpAccess().getAlternatives()); }
		(rule__CompOp__Alternatives)
		{ after(grammarAccess.getCompOpAccess().getAlternatives()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__TopLevelModelElement__Alternatives
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getTopLevelModelElementAccess().getGroup_0()); }
		(rule__TopLevelModelElement__Group_0__0)
		{ after(grammarAccess.getTopLevelModelElementAccess().getGroup_0()); }
	)
	|
	(
		{ before(grammarAccess.getTopLevelModelElementAccess().getGroup_1()); }
		(rule__TopLevelModelElement__Group_1__0)
		{ after(grammarAccess.getTopLevelModelElementAccess().getGroup_1()); }
	)
	|
	(
		{ before(grammarAccess.getTopLevelModelElementAccess().getGroup_2()); }
		(rule__TopLevelModelElement__Group_2__0)
		{ after(grammarAccess.getTopLevelModelElementAccess().getGroup_2()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Signal__Alternatives
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getSignalAccess().getGroup_0()); }
		(rule__Signal__Group_0__0)
		{ after(grammarAccess.getSignalAccess().getGroup_0()); }
	)
	|
	(
		{ before(grammarAccess.getSignalAccess().getGroup_1()); }
		(rule__Signal__Group_1__0)
		{ after(grammarAccess.getSignalAccess().getGroup_1()); }
	)
	|
	(
		{ before(grammarAccess.getSignalAccess().getGroup_2()); }
		(rule__Signal__Group_2__0)
		{ after(grammarAccess.getSignalAccess().getGroup_2()); }
	)
	|
	(
		{ before(grammarAccess.getSignalAccess().getGroup_3()); }
		(rule__Signal__Group_3__0)
		{ after(grammarAccess.getSignalAccess().getGroup_3()); }
	)
	|
	(
		{ before(grammarAccess.getSignalAccess().getGroup_4()); }
		(rule__Signal__Group_4__0)
		{ after(grammarAccess.getSignalAccess().getGroup_4()); }
	)
	|
	(
		{ before(grammarAccess.getSignalAccess().getGroup_5()); }
		(rule__Signal__Group_5__0)
		{ after(grammarAccess.getSignalAccess().getGroup_5()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Signal__Alternatives_1_3
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getSignalAccess().getIdAttAssignment_1_3_0()); }
		(rule__Signal__IdAttAssignment_1_3_0)
		{ after(grammarAccess.getSignalAccess().getIdAttAssignment_1_3_0()); }
	)
	|
	(
		{ before(grammarAccess.getSignalAccess().getApAssignment_1_3_1()); }
		(rule__Signal__ApAssignment_1_3_1)
		{ after(grammarAccess.getSignalAccess().getApAssignment_1_3_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Formula__Alternatives
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getFormulaAccess().getGroup_0()); }
		(rule__Formula__Group_0__0)
		{ after(grammarAccess.getFormulaAccess().getGroup_0()); }
	)
	|
	(
		{ before(grammarAccess.getFormulaAccess().getGroup_1()); }
		(rule__Formula__Group_1__0)
		{ after(grammarAccess.getFormulaAccess().getGroup_1()); }
	)
	|
	(
		{ before(grammarAccess.getFormulaAccess().getGroup_2()); }
		(rule__Formula__Group_2__0)
		{ after(grammarAccess.getFormulaAccess().getGroup_2()); }
	)
	|
	(
		{ before(grammarAccess.getFormulaAccess().getGroup_3()); }
		(rule__Formula__Group_3__0)
		{ after(grammarAccess.getFormulaAccess().getGroup_3()); }
	)
	|
	(
		{ before(grammarAccess.getFormulaAccess().getGroup_4()); }
		(rule__Formula__Group_4__0)
		{ after(grammarAccess.getFormulaAccess().getGroup_4()); }
	)
	|
	(
		{ before(grammarAccess.getFormulaAccess().getGroup_5()); }
		(rule__Formula__Group_5__0)
		{ after(grammarAccess.getFormulaAccess().getGroup_5()); }
	)
	|
	(
		{ before(grammarAccess.getFormulaAccess().getGroup_6()); }
		(rule__Formula__Group_6__0)
		{ after(grammarAccess.getFormulaAccess().getGroup_6()); }
	)
	|
	(
		{ before(grammarAccess.getFormulaAccess().getGroup_7()); }
		(rule__Formula__Group_7__0)
		{ after(grammarAccess.getFormulaAccess().getGroup_7()); }
	)
	|
	(
		{ before(grammarAccess.getFormulaAccess().getGroup_8()); }
		(rule__Formula__Group_8__0)
		{ after(grammarAccess.getFormulaAccess().getGroup_8()); }
	)
	|
	(
		{ before(grammarAccess.getFormulaAccess().getGroup_9()); }
		(rule__Formula__Group_9__0)
		{ after(grammarAccess.getFormulaAccess().getGroup_9()); }
	)
	|
	(
		{ before(grammarAccess.getFormulaAccess().getGroup_10()); }
		(rule__Formula__Group_10__0)
		{ after(grammarAccess.getFormulaAccess().getGroup_10()); }
	)
	|
	(
		{ before(grammarAccess.getFormulaAccess().getGroup_11()); }
		(rule__Formula__Group_11__0)
		{ after(grammarAccess.getFormulaAccess().getGroup_11()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__StlAp__Alternatives_0
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getStlApAccess().getRefAssignment_0_0()); }
		(rule__StlAp__RefAssignment_0_0)
		{ after(grammarAccess.getStlApAccess().getRefAssignment_0_0()); }
	)
	|
	(
		{ before(grammarAccess.getStlApAccess().getGroup_0_1()); }
		(rule__StlAp__Group_0_1__0)
		{ after(grammarAccess.getStlApAccess().getGroup_0_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__MtlAp__Alternatives_0
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getMtlApAccess().getGroup_0_0()); }
		(rule__MtlAp__Group_0_0__0)
		{ after(grammarAccess.getMtlApAccess().getGroup_0_0()); }
	)
	|
	(
		{ before(grammarAccess.getMtlApAccess().getGroup_0_1()); }
		(rule__MtlAp__Group_0_1__0)
		{ after(grammarAccess.getMtlApAccess().getGroup_0_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__IdString__Alternatives
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getIdStringAccess().getLeftAssignment_0()); }
		(rule__IdString__LeftAssignment_0)
		{ after(grammarAccess.getIdStringAccess().getLeftAssignment_0()); }
	)
	|
	(
		{ before(grammarAccess.getIdStringAccess().getIdAssignment_1()); }
		(rule__IdString__IdAssignment_1)
		{ after(grammarAccess.getIdStringAccess().getIdAssignment_1()); }
	)
	|
	(
		{ before(grammarAccess.getIdStringAccess().getGroup_2()); }
		(rule__IdString__Group_2__0)
		{ after(grammarAccess.getIdStringAccess().getGroup_2()); }
	)
	|
	(
		{ before(grammarAccess.getIdStringAccess().getGroup_3()); }
		(rule__IdString__Group_3__0)
		{ after(grammarAccess.getIdStringAccess().getGroup_3()); }
	)
	|
	(
		{ before(grammarAccess.getIdStringAccess().getGroup_4()); }
		(rule__IdString__Group_4__0)
		{ after(grammarAccess.getIdStringAccess().getGroup_4()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Interval__Alternatives_0
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getIntervalAccess().getIssAssignment_0_0()); }
		(rule__Interval__IssAssignment_0_0)
		{ after(grammarAccess.getIntervalAccess().getIssAssignment_0_0()); }
	)
	|
	(
		{ before(grammarAccess.getIntervalAccess().getIsnAssignment_0_1()); }
		(rule__Interval__IsnAssignment_0_1)
		{ after(grammarAccess.getIntervalAccess().getIsnAssignment_0_1()); }
	)
	|
	(
		{ before(grammarAccess.getIntervalAccess().getInsAssignment_0_2()); }
		(rule__Interval__InsAssignment_0_2)
		{ after(grammarAccess.getIntervalAccess().getInsAssignment_0_2()); }
	)
	|
	(
		{ before(grammarAccess.getIntervalAccess().getInnAssignment_0_3()); }
		(rule__Interval__InnAssignment_0_3)
		{ after(grammarAccess.getIntervalAccess().getInnAssignment_0_3()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__IntervalSS__Alternatives_3
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getIntervalSSAccess().getUbAssignment_3_0()); }
		(rule__IntervalSS__UbAssignment_3_0)
		{ after(grammarAccess.getIntervalSSAccess().getUbAssignment_3_0()); }
	)
	|
	(
		{ before(grammarAccess.getIntervalSSAccess().getInftyAssignment_3_1()); }
		(rule__IntervalSS__InftyAssignment_3_1)
		{ after(grammarAccess.getIntervalSSAccess().getInftyAssignment_3_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__IntervalNS__Alternatives_3
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getIntervalNSAccess().getUbAssignment_3_0()); }
		(rule__IntervalNS__UbAssignment_3_0)
		{ after(grammarAccess.getIntervalNSAccess().getUbAssignment_3_0()); }
	)
	|
	(
		{ before(grammarAccess.getIntervalNSAccess().getInftyAssignment_3_1()); }
		(rule__IntervalNS__InftyAssignment_3_1)
		{ after(grammarAccess.getIntervalNSAccess().getInftyAssignment_3_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__TimeUnitEnum__Alternatives
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getTimeUnitEnumAccess().getSEnumLiteralDeclaration_0()); }
		('s')
		{ after(grammarAccess.getTimeUnitEnumAccess().getSEnumLiteralDeclaration_0()); }
	)
	|
	(
		{ before(grammarAccess.getTimeUnitEnumAccess().getNSEnumLiteralDeclaration_1()); }
		('ns')
		{ after(grammarAccess.getTimeUnitEnumAccess().getNSEnumLiteralDeclaration_1()); }
	)
	|
	(
		{ before(grammarAccess.getTimeUnitEnumAccess().getUSEnumLiteralDeclaration_2()); }
		('us')
		{ after(grammarAccess.getTimeUnitEnumAccess().getUSEnumLiteralDeclaration_2()); }
	)
	|
	(
		{ before(grammarAccess.getTimeUnitEnumAccess().getMSEnumLiteralDeclaration_3()); }
		('ms')
		{ after(grammarAccess.getTimeUnitEnumAccess().getMSEnumLiteralDeclaration_3()); }
	)
	|
	(
		{ before(grammarAccess.getTimeUnitEnumAccess().getMINEnumLiteralDeclaration_4()); }
		('min')
		{ after(grammarAccess.getTimeUnitEnumAccess().getMINEnumLiteralDeclaration_4()); }
	)
	|
	(
		{ before(grammarAccess.getTimeUnitEnumAccess().getHREnumLiteralDeclaration_5()); }
		('hr')
		{ after(grammarAccess.getTimeUnitEnumAccess().getHREnumLiteralDeclaration_5()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__AndOr__Alternatives
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getAndOrAccess().getANDEnumLiteralDeclaration_0()); }
		('and')
		{ after(grammarAccess.getAndOrAccess().getANDEnumLiteralDeclaration_0()); }
	)
	|
	(
		{ before(grammarAccess.getAndOrAccess().getOREnumLiteralDeclaration_1()); }
		('or')
		{ after(grammarAccess.getAndOrAccess().getOREnumLiteralDeclaration_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__CompOp__Alternatives
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getCompOpAccess().getLEEnumLiteralDeclaration_0()); }
		('<=')
		{ after(grammarAccess.getCompOpAccess().getLEEnumLiteralDeclaration_0()); }
	)
	|
	(
		{ before(grammarAccess.getCompOpAccess().getEQEnumLiteralDeclaration_1()); }
		('==')
		{ after(grammarAccess.getCompOpAccess().getEQEnumLiteralDeclaration_1()); }
	)
	|
	(
		{ before(grammarAccess.getCompOpAccess().getGEEnumLiteralDeclaration_2()); }
		('>=')
		{ after(grammarAccess.getCompOpAccess().getGEEnumLiteralDeclaration_2()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__TopLevelModelElement__Group_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__TopLevelModelElement__Group_0__0__Impl
	rule__TopLevelModelElement__Group_0__1
;
finally {
	restoreStackSize(stackSize);
}

rule__TopLevelModelElement__Group_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getTopLevelModelElementAccess().getSignalDefAction_0_0()); }
	()
	{ after(grammarAccess.getTopLevelModelElementAccess().getSignalDefAction_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__TopLevelModelElement__Group_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__TopLevelModelElement__Group_0__1__Impl
	rule__TopLevelModelElement__Group_0__2
;
finally {
	restoreStackSize(stackSize);
}

rule__TopLevelModelElement__Group_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getTopLevelModelElementAccess().getSignalKeyword_0_1()); }
	'signal'
	{ after(grammarAccess.getTopLevelModelElementAccess().getSignalKeyword_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__TopLevelModelElement__Group_0__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__TopLevelModelElement__Group_0__2__Impl
	rule__TopLevelModelElement__Group_0__3
;
finally {
	restoreStackSize(stackSize);
}

rule__TopLevelModelElement__Group_0__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getTopLevelModelElementAccess().getNameAssignment_0_2()); }
	(rule__TopLevelModelElement__NameAssignment_0_2)
	{ after(grammarAccess.getTopLevelModelElementAccess().getNameAssignment_0_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__TopLevelModelElement__Group_0__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__TopLevelModelElement__Group_0__3__Impl
	rule__TopLevelModelElement__Group_0__4
;
finally {
	restoreStackSize(stackSize);
}

rule__TopLevelModelElement__Group_0__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getTopLevelModelElementAccess().getColonKeyword_0_3()); }
	':'
	{ after(grammarAccess.getTopLevelModelElementAccess().getColonKeyword_0_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__TopLevelModelElement__Group_0__4
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__TopLevelModelElement__Group_0__4__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__TopLevelModelElement__Group_0__4__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getTopLevelModelElementAccess().getSignalAssignment_0_4()); }
	(rule__TopLevelModelElement__SignalAssignment_0_4)
	{ after(grammarAccess.getTopLevelModelElementAccess().getSignalAssignment_0_4()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__TopLevelModelElement__Group_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__TopLevelModelElement__Group_1__0__Impl
	rule__TopLevelModelElement__Group_1__1
;
finally {
	restoreStackSize(stackSize);
}

rule__TopLevelModelElement__Group_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getTopLevelModelElementAccess().getDefAction_1_0()); }
	()
	{ after(grammarAccess.getTopLevelModelElementAccess().getDefAction_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__TopLevelModelElement__Group_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__TopLevelModelElement__Group_1__1__Impl
	rule__TopLevelModelElement__Group_1__2
;
finally {
	restoreStackSize(stackSize);
}

rule__TopLevelModelElement__Group_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getTopLevelModelElementAccess().getDefKeyword_1_1()); }
	'def'
	{ after(grammarAccess.getTopLevelModelElementAccess().getDefKeyword_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__TopLevelModelElement__Group_1__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__TopLevelModelElement__Group_1__2__Impl
	rule__TopLevelModelElement__Group_1__3
;
finally {
	restoreStackSize(stackSize);
}

rule__TopLevelModelElement__Group_1__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getTopLevelModelElementAccess().getNameAssignment_1_2()); }
	(rule__TopLevelModelElement__NameAssignment_1_2)
	{ after(grammarAccess.getTopLevelModelElementAccess().getNameAssignment_1_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__TopLevelModelElement__Group_1__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__TopLevelModelElement__Group_1__3__Impl
	rule__TopLevelModelElement__Group_1__4
;
finally {
	restoreStackSize(stackSize);
}

rule__TopLevelModelElement__Group_1__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getTopLevelModelElementAccess().getGroup_1_3()); }
	(rule__TopLevelModelElement__Group_1_3__0)?
	{ after(grammarAccess.getTopLevelModelElementAccess().getGroup_1_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__TopLevelModelElement__Group_1__4
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__TopLevelModelElement__Group_1__4__Impl
	rule__TopLevelModelElement__Group_1__5
;
finally {
	restoreStackSize(stackSize);
}

rule__TopLevelModelElement__Group_1__4__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getTopLevelModelElementAccess().getColonKeyword_1_4()); }
	':'
	{ after(grammarAccess.getTopLevelModelElementAccess().getColonKeyword_1_4()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__TopLevelModelElement__Group_1__5
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__TopLevelModelElement__Group_1__5__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__TopLevelModelElement__Group_1__5__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getTopLevelModelElementAccess().getFormulaAssignment_1_5()); }
	(rule__TopLevelModelElement__FormulaAssignment_1_5)
	{ after(grammarAccess.getTopLevelModelElementAccess().getFormulaAssignment_1_5()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__TopLevelModelElement__Group_1_3__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__TopLevelModelElement__Group_1_3__0__Impl
	rule__TopLevelModelElement__Group_1_3__1
;
finally {
	restoreStackSize(stackSize);
}

rule__TopLevelModelElement__Group_1_3__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getTopLevelModelElementAccess().getLeftParenthesisKeyword_1_3_0()); }
	'('
	{ after(grammarAccess.getTopLevelModelElementAccess().getLeftParenthesisKeyword_1_3_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__TopLevelModelElement__Group_1_3__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__TopLevelModelElement__Group_1_3__1__Impl
	rule__TopLevelModelElement__Group_1_3__2
;
finally {
	restoreStackSize(stackSize);
}

rule__TopLevelModelElement__Group_1_3__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getTopLevelModelElementAccess().getParamAssignment_1_3_1()); }
	(rule__TopLevelModelElement__ParamAssignment_1_3_1)
	{ after(grammarAccess.getTopLevelModelElementAccess().getParamAssignment_1_3_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__TopLevelModelElement__Group_1_3__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__TopLevelModelElement__Group_1_3__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__TopLevelModelElement__Group_1_3__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getTopLevelModelElementAccess().getRightParenthesisKeyword_1_3_2()); }
	')'
	{ after(grammarAccess.getTopLevelModelElementAccess().getRightParenthesisKeyword_1_3_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__TopLevelModelElement__Group_2__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__TopLevelModelElement__Group_2__0__Impl
	rule__TopLevelModelElement__Group_2__1
;
finally {
	restoreStackSize(stackSize);
}

rule__TopLevelModelElement__Group_2__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getTopLevelModelElementAccess().getCheckAction_2_0()); }
	()
	{ after(grammarAccess.getTopLevelModelElementAccess().getCheckAction_2_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__TopLevelModelElement__Group_2__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__TopLevelModelElement__Group_2__1__Impl
	rule__TopLevelModelElement__Group_2__2
;
finally {
	restoreStackSize(stackSize);
}

rule__TopLevelModelElement__Group_2__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getTopLevelModelElementAccess().getCheckKeyword_2_1()); }
	'check'
	{ after(grammarAccess.getTopLevelModelElementAccess().getCheckKeyword_2_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__TopLevelModelElement__Group_2__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__TopLevelModelElement__Group_2__2__Impl
	rule__TopLevelModelElement__Group_2__3
;
finally {
	restoreStackSize(stackSize);
}

rule__TopLevelModelElement__Group_2__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getTopLevelModelElementAccess().getNameAssignment_2_2()); }
	(rule__TopLevelModelElement__NameAssignment_2_2)
	{ after(grammarAccess.getTopLevelModelElementAccess().getNameAssignment_2_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__TopLevelModelElement__Group_2__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__TopLevelModelElement__Group_2__3__Impl
	rule__TopLevelModelElement__Group_2__4
;
finally {
	restoreStackSize(stackSize);
}

rule__TopLevelModelElement__Group_2__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getTopLevelModelElementAccess().getColonKeyword_2_3()); }
	':'
	{ after(grammarAccess.getTopLevelModelElementAccess().getColonKeyword_2_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__TopLevelModelElement__Group_2__4
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__TopLevelModelElement__Group_2__4__Impl
	rule__TopLevelModelElement__Group_2__5
;
finally {
	restoreStackSize(stackSize);
}

rule__TopLevelModelElement__Group_2__4__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getTopLevelModelElementAccess().getGroup_2_4()); }
	(rule__TopLevelModelElement__Group_2_4__0)?
	{ after(grammarAccess.getTopLevelModelElementAccess().getGroup_2_4()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__TopLevelModelElement__Group_2__5
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__TopLevelModelElement__Group_2__5__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__TopLevelModelElement__Group_2__5__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getTopLevelModelElementAccess().getFormulaAssignment_2_5()); }
	(rule__TopLevelModelElement__FormulaAssignment_2_5)
	{ after(grammarAccess.getTopLevelModelElementAccess().getFormulaAssignment_2_5()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__TopLevelModelElement__Group_2_4__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__TopLevelModelElement__Group_2_4__0__Impl
	rule__TopLevelModelElement__Group_2_4__1
;
finally {
	restoreStackSize(stackSize);
}

rule__TopLevelModelElement__Group_2_4__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getTopLevelModelElementAccess().getForallKeyword_2_4_0()); }
	'forall'
	{ after(grammarAccess.getTopLevelModelElementAccess().getForallKeyword_2_4_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__TopLevelModelElement__Group_2_4__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__TopLevelModelElement__Group_2_4__1__Impl
	rule__TopLevelModelElement__Group_2_4__2
;
finally {
	restoreStackSize(stackSize);
}

rule__TopLevelModelElement__Group_2_4__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getTopLevelModelElementAccess().getLeftParenthesisKeyword_2_4_1()); }
	'('
	{ after(grammarAccess.getTopLevelModelElementAccess().getLeftParenthesisKeyword_2_4_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__TopLevelModelElement__Group_2_4__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__TopLevelModelElement__Group_2_4__2__Impl
	rule__TopLevelModelElement__Group_2_4__3
;
finally {
	restoreStackSize(stackSize);
}

rule__TopLevelModelElement__Group_2_4__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getTopLevelModelElementAccess().getVarAssignment_2_4_2()); }
	(rule__TopLevelModelElement__VarAssignment_2_4_2)
	{ after(grammarAccess.getTopLevelModelElementAccess().getVarAssignment_2_4_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__TopLevelModelElement__Group_2_4__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__TopLevelModelElement__Group_2_4__3__Impl
	rule__TopLevelModelElement__Group_2_4__4
;
finally {
	restoreStackSize(stackSize);
}

rule__TopLevelModelElement__Group_2_4__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getTopLevelModelElementAccess().getColonKeyword_2_4_3()); }
	':'
	{ after(grammarAccess.getTopLevelModelElementAccess().getColonKeyword_2_4_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__TopLevelModelElement__Group_2_4__4
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__TopLevelModelElement__Group_2_4__4__Impl
	rule__TopLevelModelElement__Group_2_4__5
;
finally {
	restoreStackSize(stackSize);
}

rule__TopLevelModelElement__Group_2_4__4__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getTopLevelModelElementAccess().getLbAssignment_2_4_4()); }
	(rule__TopLevelModelElement__LbAssignment_2_4_4)
	{ after(grammarAccess.getTopLevelModelElementAccess().getLbAssignment_2_4_4()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__TopLevelModelElement__Group_2_4__5
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__TopLevelModelElement__Group_2_4__5__Impl
	rule__TopLevelModelElement__Group_2_4__6
;
finally {
	restoreStackSize(stackSize);
}

rule__TopLevelModelElement__Group_2_4__5__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getTopLevelModelElementAccess().getFullStopFullStopFullStopKeyword_2_4_5()); }
	'...'
	{ after(grammarAccess.getTopLevelModelElementAccess().getFullStopFullStopFullStopKeyword_2_4_5()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__TopLevelModelElement__Group_2_4__6
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__TopLevelModelElement__Group_2_4__6__Impl
	rule__TopLevelModelElement__Group_2_4__7
;
finally {
	restoreStackSize(stackSize);
}

rule__TopLevelModelElement__Group_2_4__6__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getTopLevelModelElementAccess().getUbAssignment_2_4_6()); }
	(rule__TopLevelModelElement__UbAssignment_2_4_6)
	{ after(grammarAccess.getTopLevelModelElementAccess().getUbAssignment_2_4_6()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__TopLevelModelElement__Group_2_4__7
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__TopLevelModelElement__Group_2_4__7__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__TopLevelModelElement__Group_2_4__7__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getTopLevelModelElementAccess().getRightParenthesisKeyword_2_4_7()); }
	')'
	{ after(grammarAccess.getTopLevelModelElementAccess().getRightParenthesisKeyword_2_4_7()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__Signal__Group_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Signal__Group_0__0__Impl
	rule__Signal__Group_0__1
;
finally {
	restoreStackSize(stackSize);
}

rule__Signal__Group_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSignalAccess().getTraceSignalAction_0_0()); }
	()
	{ after(grammarAccess.getSignalAccess().getTraceSignalAction_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Signal__Group_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Signal__Group_0__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__Signal__Group_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSignalAccess().getFilterAssignment_0_1()); }
	(rule__Signal__FilterAssignment_0_1)
	{ after(grammarAccess.getSignalAccess().getFilterAssignment_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__Signal__Group_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Signal__Group_1__0__Impl
	rule__Signal__Group_1__1
;
finally {
	restoreStackSize(stackSize);
}

rule__Signal__Group_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSignalAccess().getThroughputSignalAction_1_0()); }
	()
	{ after(grammarAccess.getSignalAccess().getThroughputSignalAction_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Signal__Group_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Signal__Group_1__1__Impl
	rule__Signal__Group_1__2
;
finally {
	restoreStackSize(stackSize);
}

rule__Signal__Group_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSignalAccess().getThroughputKeyword_1_1()); }
	'throughput'
	{ after(grammarAccess.getSignalAccess().getThroughputKeyword_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Signal__Group_1__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Signal__Group_1__2__Impl
	rule__Signal__Group_1__3
;
finally {
	restoreStackSize(stackSize);
}

rule__Signal__Group_1__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSignalAccess().getOfKeyword_1_2()); }
	'of'
	{ after(grammarAccess.getSignalAccess().getOfKeyword_1_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Signal__Group_1__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Signal__Group_1__3__Impl
	rule__Signal__Group_1__4
;
finally {
	restoreStackSize(stackSize);
}

rule__Signal__Group_1__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSignalAccess().getAlternatives_1_3()); }
	(rule__Signal__Alternatives_1_3)
	{ after(grammarAccess.getSignalAccess().getAlternatives_1_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Signal__Group_1__4
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Signal__Group_1__4__Impl
	rule__Signal__Group_1__5
;
finally {
	restoreStackSize(stackSize);
}

rule__Signal__Group_1__4__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSignalAccess().getGroup_1_4()); }
	(rule__Signal__Group_1_4__0)?
	{ after(grammarAccess.getSignalAccess().getGroup_1_4()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Signal__Group_1__5
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Signal__Group_1__5__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__Signal__Group_1__5__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSignalAccess().getConvSpecAssignment_1_5()); }
	(rule__Signal__ConvSpecAssignment_1_5)?
	{ after(grammarAccess.getSignalAccess().getConvSpecAssignment_1_5()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__Signal__Group_1_4__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Signal__Group_1_4__0__Impl
	rule__Signal__Group_1_4__1
;
finally {
	restoreStackSize(stackSize);
}

rule__Signal__Group_1_4__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSignalAccess().getPerKeyword_1_4_0()); }
	'per'
	{ after(grammarAccess.getSignalAccess().getPerKeyword_1_4_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Signal__Group_1_4__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Signal__Group_1_4__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__Signal__Group_1_4__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSignalAccess().getScaleAssignment_1_4_1()); }
	(rule__Signal__ScaleAssignment_1_4_1)
	{ after(grammarAccess.getSignalAccess().getScaleAssignment_1_4_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__Signal__Group_2__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Signal__Group_2__0__Impl
	rule__Signal__Group_2__1
;
finally {
	restoreStackSize(stackSize);
}

rule__Signal__Group_2__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSignalAccess().getLatencySignalAction_2_0()); }
	()
	{ after(grammarAccess.getSignalAccess().getLatencySignalAction_2_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Signal__Group_2__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Signal__Group_2__1__Impl
	rule__Signal__Group_2__2
;
finally {
	restoreStackSize(stackSize);
}

rule__Signal__Group_2__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSignalAccess().getLatencyKeyword_2_1()); }
	'latency'
	{ after(grammarAccess.getSignalAccess().getLatencyKeyword_2_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Signal__Group_2__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Signal__Group_2__2__Impl
	rule__Signal__Group_2__3
;
finally {
	restoreStackSize(stackSize);
}

rule__Signal__Group_2__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSignalAccess().getOfKeyword_2_2()); }
	'of'
	{ after(grammarAccess.getSignalAccess().getOfKeyword_2_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Signal__Group_2__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Signal__Group_2__3__Impl
	rule__Signal__Group_2__4
;
finally {
	restoreStackSize(stackSize);
}

rule__Signal__Group_2__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSignalAccess().getIdAttAssignment_2_3()); }
	(rule__Signal__IdAttAssignment_2_3)
	{ after(grammarAccess.getSignalAccess().getIdAttAssignment_2_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Signal__Group_2__4
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Signal__Group_2__4__Impl
	rule__Signal__Group_2__5
;
finally {
	restoreStackSize(stackSize);
}

rule__Signal__Group_2__4__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSignalAccess().getGroup_2_4()); }
	(rule__Signal__Group_2_4__0)?
	{ after(grammarAccess.getSignalAccess().getGroup_2_4()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Signal__Group_2__5
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Signal__Group_2__5__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__Signal__Group_2__5__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSignalAccess().getConvSpecAssignment_2_5()); }
	(rule__Signal__ConvSpecAssignment_2_5)?
	{ after(grammarAccess.getSignalAccess().getConvSpecAssignment_2_5()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__Signal__Group_2_4__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Signal__Group_2_4__0__Impl
	rule__Signal__Group_2_4__1
;
finally {
	restoreStackSize(stackSize);
}

rule__Signal__Group_2_4__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSignalAccess().getInKeyword_2_4_0()); }
	'in'
	{ after(grammarAccess.getSignalAccess().getInKeyword_2_4_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Signal__Group_2_4__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Signal__Group_2_4__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__Signal__Group_2_4__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSignalAccess().getScaleAssignment_2_4_1()); }
	(rule__Signal__ScaleAssignment_2_4_1)
	{ after(grammarAccess.getSignalAccess().getScaleAssignment_2_4_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__Signal__Group_3__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Signal__Group_3__0__Impl
	rule__Signal__Group_3__1
;
finally {
	restoreStackSize(stackSize);
}

rule__Signal__Group_3__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSignalAccess().getWipSignalAction_3_0()); }
	()
	{ after(grammarAccess.getSignalAccess().getWipSignalAction_3_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Signal__Group_3__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Signal__Group_3__1__Impl
	rule__Signal__Group_3__2
;
finally {
	restoreStackSize(stackSize);
}

rule__Signal__Group_3__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSignalAccess().getWipKeyword_3_1()); }
	'wip'
	{ after(grammarAccess.getSignalAccess().getWipKeyword_3_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Signal__Group_3__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Signal__Group_3__2__Impl
	rule__Signal__Group_3__3
;
finally {
	restoreStackSize(stackSize);
}

rule__Signal__Group_3__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSignalAccess().getOfKeyword_3_2()); }
	'of'
	{ after(grammarAccess.getSignalAccess().getOfKeyword_3_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Signal__Group_3__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Signal__Group_3__3__Impl
	rule__Signal__Group_3__4
;
finally {
	restoreStackSize(stackSize);
}

rule__Signal__Group_3__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSignalAccess().getIdAttAssignment_3_3()); }
	(rule__Signal__IdAttAssignment_3_3)
	{ after(grammarAccess.getSignalAccess().getIdAttAssignment_3_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Signal__Group_3__4
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Signal__Group_3__4__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__Signal__Group_3__4__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSignalAccess().getConvSpecAssignment_3_4()); }
	(rule__Signal__ConvSpecAssignment_3_4)?
	{ after(grammarAccess.getSignalAccess().getConvSpecAssignment_3_4()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__Signal__Group_4__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Signal__Group_4__0__Impl
	rule__Signal__Group_4__1
;
finally {
	restoreStackSize(stackSize);
}

rule__Signal__Group_4__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSignalAccess().getResourceAmountSignalAction_4_0()); }
	()
	{ after(grammarAccess.getSignalAccess().getResourceAmountSignalAction_4_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Signal__Group_4__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Signal__Group_4__1__Impl
	rule__Signal__Group_4__2
;
finally {
	restoreStackSize(stackSize);
}

rule__Signal__Group_4__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSignalAccess().getResourceAmountKeyword_4_1()); }
	'resource-amount'
	{ after(grammarAccess.getSignalAccess().getResourceAmountKeyword_4_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Signal__Group_4__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Signal__Group_4__2__Impl
	rule__Signal__Group_4__3
;
finally {
	restoreStackSize(stackSize);
}

rule__Signal__Group_4__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSignalAccess().getFilterAssignment_4_2()); }
	(rule__Signal__FilterAssignment_4_2)
	{ after(grammarAccess.getSignalAccess().getFilterAssignment_4_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Signal__Group_4__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Signal__Group_4__3__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__Signal__Group_4__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSignalAccess().getConvSpecAssignment_4_3()); }
	(rule__Signal__ConvSpecAssignment_4_3)?
	{ after(grammarAccess.getSignalAccess().getConvSpecAssignment_4_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__Signal__Group_5__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Signal__Group_5__0__Impl
	rule__Signal__Group_5__1
;
finally {
	restoreStackSize(stackSize);
}

rule__Signal__Group_5__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSignalAccess().getResourceClientSignalAction_5_0()); }
	()
	{ after(grammarAccess.getSignalAccess().getResourceClientSignalAction_5_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Signal__Group_5__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Signal__Group_5__1__Impl
	rule__Signal__Group_5__2
;
finally {
	restoreStackSize(stackSize);
}

rule__Signal__Group_5__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSignalAccess().getResourceClientsKeyword_5_1()); }
	'resource-clients'
	{ after(grammarAccess.getSignalAccess().getResourceClientsKeyword_5_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Signal__Group_5__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Signal__Group_5__2__Impl
	rule__Signal__Group_5__3
;
finally {
	restoreStackSize(stackSize);
}

rule__Signal__Group_5__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSignalAccess().getFilterAssignment_5_2()); }
	(rule__Signal__FilterAssignment_5_2)
	{ after(grammarAccess.getSignalAccess().getFilterAssignment_5_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Signal__Group_5__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Signal__Group_5__3__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__Signal__Group_5__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSignalAccess().getConvSpecAssignment_5_3()); }
	(rule__Signal__ConvSpecAssignment_5_3)?
	{ after(grammarAccess.getSignalAccess().getConvSpecAssignment_5_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__ConvSpec__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ConvSpec__Group__0__Impl
	rule__ConvSpec__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__ConvSpec__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getConvSpecAccess().getOverKeyword_0()); }
	'over'
	{ after(grammarAccess.getConvSpecAccess().getOverKeyword_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ConvSpec__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ConvSpec__Group__1__Impl
	rule__ConvSpec__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__ConvSpec__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getConvSpecAccess().getWindowWidthAssignment_1()); }
	(rule__ConvSpec__WindowWidthAssignment_1)
	{ after(grammarAccess.getConvSpecAccess().getWindowWidthAssignment_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ConvSpec__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ConvSpec__Group__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__ConvSpec__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getConvSpecAccess().getWindowUnitAssignment_2()); }
	(rule__ConvSpec__WindowUnitAssignment_2)
	{ after(grammarAccess.getConvSpecAccess().getWindowUnitAssignment_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__Formula__Group_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Formula__Group_0__0__Impl
	rule__Formula__Group_0__1
;
finally {
	restoreStackSize(stackSize);
}

rule__Formula__Group_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFormulaAccess().getReferenceFormulaAction_0_0()); }
	()
	{ after(grammarAccess.getFormulaAccess().getReferenceFormulaAction_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Formula__Group_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Formula__Group_0__1__Impl
	rule__Formula__Group_0__2
;
finally {
	restoreStackSize(stackSize);
}

rule__Formula__Group_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFormulaAccess().getDefAssignment_0_1()); }
	(rule__Formula__DefAssignment_0_1)
	{ after(grammarAccess.getFormulaAccess().getDefAssignment_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Formula__Group_0__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Formula__Group_0__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__Formula__Group_0__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFormulaAccess().getGroup_0_2()); }
	(rule__Formula__Group_0_2__0)?
	{ after(grammarAccess.getFormulaAccess().getGroup_0_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__Formula__Group_0_2__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Formula__Group_0_2__0__Impl
	rule__Formula__Group_0_2__1
;
finally {
	restoreStackSize(stackSize);
}

rule__Formula__Group_0_2__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFormulaAccess().getLeftParenthesisKeyword_0_2_0()); }
	'('
	{ after(grammarAccess.getFormulaAccess().getLeftParenthesisKeyword_0_2_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Formula__Group_0_2__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Formula__Group_0_2__1__Impl
	rule__Formula__Group_0_2__2
;
finally {
	restoreStackSize(stackSize);
}

rule__Formula__Group_0_2__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFormulaAccess().getParamAssignment_0_2_1()); }
	(rule__Formula__ParamAssignment_0_2_1)
	{ after(grammarAccess.getFormulaAccess().getParamAssignment_0_2_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Formula__Group_0_2__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Formula__Group_0_2__2__Impl
	rule__Formula__Group_0_2__3
;
finally {
	restoreStackSize(stackSize);
}

rule__Formula__Group_0_2__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFormulaAccess().getGroup_0_2_2()); }
	(rule__Formula__Group_0_2_2__0)?
	{ after(grammarAccess.getFormulaAccess().getGroup_0_2_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Formula__Group_0_2__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Formula__Group_0_2__3__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__Formula__Group_0_2__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFormulaAccess().getRightParenthesisKeyword_0_2_3()); }
	')'
	{ after(grammarAccess.getFormulaAccess().getRightParenthesisKeyword_0_2_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__Formula__Group_0_2_2__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Formula__Group_0_2_2__0__Impl
	rule__Formula__Group_0_2_2__1
;
finally {
	restoreStackSize(stackSize);
}

rule__Formula__Group_0_2_2__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFormulaAccess().getPlusSignKeyword_0_2_2_0()); }
	'+'
	{ after(grammarAccess.getFormulaAccess().getPlusSignKeyword_0_2_2_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Formula__Group_0_2_2__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Formula__Group_0_2_2__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__Formula__Group_0_2_2__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFormulaAccess().getValAssignment_0_2_2_1()); }
	(rule__Formula__ValAssignment_0_2_2_1)
	{ after(grammarAccess.getFormulaAccess().getValAssignment_0_2_2_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__Formula__Group_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Formula__Group_1__0__Impl
	rule__Formula__Group_1__1
;
finally {
	restoreStackSize(stackSize);
}

rule__Formula__Group_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFormulaAccess().getApFormulaAction_1_0()); }
	()
	{ after(grammarAccess.getFormulaAccess().getApFormulaAction_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Formula__Group_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Formula__Group_1__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__Formula__Group_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFormulaAccess().getMtlAPAssignment_1_1()); }
	(rule__Formula__MtlAPAssignment_1_1)
	{ after(grammarAccess.getFormulaAccess().getMtlAPAssignment_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__Formula__Group_2__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Formula__Group_2__0__Impl
	rule__Formula__Group_2__1
;
finally {
	restoreStackSize(stackSize);
}

rule__Formula__Group_2__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFormulaAccess().getApFormulaAction_2_0()); }
	()
	{ after(grammarAccess.getFormulaAccess().getApFormulaAction_2_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Formula__Group_2__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Formula__Group_2__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__Formula__Group_2__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFormulaAccess().getStlAPAssignment_2_1()); }
	(rule__Formula__StlAPAssignment_2_1)
	{ after(grammarAccess.getFormulaAccess().getStlAPAssignment_2_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__Formula__Group_3__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Formula__Group_3__0__Impl
	rule__Formula__Group_3__1
;
finally {
	restoreStackSize(stackSize);
}

rule__Formula__Group_3__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFormulaAccess().getNotFormulaAction_3_0()); }
	()
	{ after(grammarAccess.getFormulaAccess().getNotFormulaAction_3_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Formula__Group_3__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Formula__Group_3__1__Impl
	rule__Formula__Group_3__2
;
finally {
	restoreStackSize(stackSize);
}

rule__Formula__Group_3__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFormulaAccess().getNotKeyword_3_1()); }
	'not'
	{ after(grammarAccess.getFormulaAccess().getNotKeyword_3_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Formula__Group_3__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Formula__Group_3__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__Formula__Group_3__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFormulaAccess().getFormulaAssignment_3_2()); }
	(rule__Formula__FormulaAssignment_3_2)
	{ after(grammarAccess.getFormulaAccess().getFormulaAssignment_3_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__Formula__Group_4__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Formula__Group_4__0__Impl
	rule__Formula__Group_4__1
;
finally {
	restoreStackSize(stackSize);
}

rule__Formula__Group_4__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFormulaAccess().getAndOrFormulaAction_4_0()); }
	()
	{ after(grammarAccess.getFormulaAccess().getAndOrFormulaAction_4_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Formula__Group_4__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Formula__Group_4__1__Impl
	rule__Formula__Group_4__2
;
finally {
	restoreStackSize(stackSize);
}

rule__Formula__Group_4__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFormulaAccess().getLeftParenthesisKeyword_4_1()); }
	'('
	{ after(grammarAccess.getFormulaAccess().getLeftParenthesisKeyword_4_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Formula__Group_4__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Formula__Group_4__2__Impl
	rule__Formula__Group_4__3
;
finally {
	restoreStackSize(stackSize);
}

rule__Formula__Group_4__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFormulaAccess().getLeftAssignment_4_2()); }
	(rule__Formula__LeftAssignment_4_2)
	{ after(grammarAccess.getFormulaAccess().getLeftAssignment_4_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Formula__Group_4__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Formula__Group_4__3__Impl
	rule__Formula__Group_4__4
;
finally {
	restoreStackSize(stackSize);
}

rule__Formula__Group_4__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFormulaAccess().getOpAssignment_4_3()); }
	(rule__Formula__OpAssignment_4_3)
	{ after(grammarAccess.getFormulaAccess().getOpAssignment_4_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Formula__Group_4__4
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Formula__Group_4__4__Impl
	rule__Formula__Group_4__5
;
finally {
	restoreStackSize(stackSize);
}

rule__Formula__Group_4__4__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFormulaAccess().getRightAssignment_4_4()); }
	(rule__Formula__RightAssignment_4_4)
	{ after(grammarAccess.getFormulaAccess().getRightAssignment_4_4()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Formula__Group_4__5
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Formula__Group_4__5__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__Formula__Group_4__5__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFormulaAccess().getRightParenthesisKeyword_4_5()); }
	')'
	{ after(grammarAccess.getFormulaAccess().getRightParenthesisKeyword_4_5()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__Formula__Group_5__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Formula__Group_5__0__Impl
	rule__Formula__Group_5__1
;
finally {
	restoreStackSize(stackSize);
}

rule__Formula__Group_5__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFormulaAccess().getIfThenFormulaAction_5_0()); }
	()
	{ after(grammarAccess.getFormulaAccess().getIfThenFormulaAction_5_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Formula__Group_5__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Formula__Group_5__1__Impl
	rule__Formula__Group_5__2
;
finally {
	restoreStackSize(stackSize);
}

rule__Formula__Group_5__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFormulaAccess().getIfKeyword_5_1()); }
	'if'
	{ after(grammarAccess.getFormulaAccess().getIfKeyword_5_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Formula__Group_5__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Formula__Group_5__2__Impl
	rule__Formula__Group_5__3
;
finally {
	restoreStackSize(stackSize);
}

rule__Formula__Group_5__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFormulaAccess().getLeftAssignment_5_2()); }
	(rule__Formula__LeftAssignment_5_2)
	{ after(grammarAccess.getFormulaAccess().getLeftAssignment_5_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Formula__Group_5__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Formula__Group_5__3__Impl
	rule__Formula__Group_5__4
;
finally {
	restoreStackSize(stackSize);
}

rule__Formula__Group_5__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFormulaAccess().getThenKeyword_5_3()); }
	'then'
	{ after(grammarAccess.getFormulaAccess().getThenKeyword_5_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Formula__Group_5__4
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Formula__Group_5__4__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__Formula__Group_5__4__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFormulaAccess().getRightAssignment_5_4()); }
	(rule__Formula__RightAssignment_5_4)
	{ after(grammarAccess.getFormulaAccess().getRightAssignment_5_4()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__Formula__Group_6__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Formula__Group_6__0__Impl
	rule__Formula__Group_6__1
;
finally {
	restoreStackSize(stackSize);
}

rule__Formula__Group_6__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFormulaAccess().getGloballyUntimedFormulaAction_6_0()); }
	()
	{ after(grammarAccess.getFormulaAccess().getGloballyUntimedFormulaAction_6_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Formula__Group_6__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Formula__Group_6__1__Impl
	rule__Formula__Group_6__2
;
finally {
	restoreStackSize(stackSize);
}

rule__Formula__Group_6__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFormulaAccess().getGloballyKeyword_6_1()); }
	'globally'
	{ after(grammarAccess.getFormulaAccess().getGloballyKeyword_6_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Formula__Group_6__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Formula__Group_6__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__Formula__Group_6__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFormulaAccess().getFormulaAssignment_6_2()); }
	(rule__Formula__FormulaAssignment_6_2)
	{ after(grammarAccess.getFormulaAccess().getFormulaAssignment_6_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__Formula__Group_7__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Formula__Group_7__0__Impl
	rule__Formula__Group_7__1
;
finally {
	restoreStackSize(stackSize);
}

rule__Formula__Group_7__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFormulaAccess().getGloballyFormulaAction_7_0()); }
	()
	{ after(grammarAccess.getFormulaAccess().getGloballyFormulaAction_7_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Formula__Group_7__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Formula__Group_7__1__Impl
	rule__Formula__Group_7__2
;
finally {
	restoreStackSize(stackSize);
}

rule__Formula__Group_7__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFormulaAccess().getDuringKeyword_7_1()); }
	'during'
	{ after(grammarAccess.getFormulaAccess().getDuringKeyword_7_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Formula__Group_7__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Formula__Group_7__2__Impl
	rule__Formula__Group_7__3
;
finally {
	restoreStackSize(stackSize);
}

rule__Formula__Group_7__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFormulaAccess().getIntervalAssignment_7_2()); }
	(rule__Formula__IntervalAssignment_7_2)
	{ after(grammarAccess.getFormulaAccess().getIntervalAssignment_7_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Formula__Group_7__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Formula__Group_7__3__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__Formula__Group_7__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFormulaAccess().getFormulaAssignment_7_3()); }
	(rule__Formula__FormulaAssignment_7_3)
	{ after(grammarAccess.getFormulaAccess().getFormulaAssignment_7_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__Formula__Group_8__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Formula__Group_8__0__Impl
	rule__Formula__Group_8__1
;
finally {
	restoreStackSize(stackSize);
}

rule__Formula__Group_8__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFormulaAccess().getFinallyUntimedFormulaAction_8_0()); }
	()
	{ after(grammarAccess.getFormulaAccess().getFinallyUntimedFormulaAction_8_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Formula__Group_8__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Formula__Group_8__1__Impl
	rule__Formula__Group_8__2
;
finally {
	restoreStackSize(stackSize);
}

rule__Formula__Group_8__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFormulaAccess().getFinallyKeyword_8_1()); }
	'finally'
	{ after(grammarAccess.getFormulaAccess().getFinallyKeyword_8_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Formula__Group_8__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Formula__Group_8__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__Formula__Group_8__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFormulaAccess().getFormulaAssignment_8_2()); }
	(rule__Formula__FormulaAssignment_8_2)
	{ after(grammarAccess.getFormulaAccess().getFormulaAssignment_8_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__Formula__Group_9__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Formula__Group_9__0__Impl
	rule__Formula__Group_9__1
;
finally {
	restoreStackSize(stackSize);
}

rule__Formula__Group_9__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFormulaAccess().getFinallyFormulaAction_9_0()); }
	()
	{ after(grammarAccess.getFormulaAccess().getFinallyFormulaAction_9_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Formula__Group_9__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Formula__Group_9__1__Impl
	rule__Formula__Group_9__2
;
finally {
	restoreStackSize(stackSize);
}

rule__Formula__Group_9__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFormulaAccess().getWithinKeyword_9_1()); }
	'within'
	{ after(grammarAccess.getFormulaAccess().getWithinKeyword_9_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Formula__Group_9__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Formula__Group_9__2__Impl
	rule__Formula__Group_9__3
;
finally {
	restoreStackSize(stackSize);
}

rule__Formula__Group_9__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFormulaAccess().getIntervalAssignment_9_2()); }
	(rule__Formula__IntervalAssignment_9_2)
	{ after(grammarAccess.getFormulaAccess().getIntervalAssignment_9_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Formula__Group_9__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Formula__Group_9__3__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__Formula__Group_9__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFormulaAccess().getFormulaAssignment_9_3()); }
	(rule__Formula__FormulaAssignment_9_3)
	{ after(grammarAccess.getFormulaAccess().getFormulaAssignment_9_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__Formula__Group_10__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Formula__Group_10__0__Impl
	rule__Formula__Group_10__1
;
finally {
	restoreStackSize(stackSize);
}

rule__Formula__Group_10__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFormulaAccess().getUntilUntimedFormulaAction_10_0()); }
	()
	{ after(grammarAccess.getFormulaAccess().getUntilUntimedFormulaAction_10_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Formula__Group_10__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Formula__Group_10__1__Impl
	rule__Formula__Group_10__2
;
finally {
	restoreStackSize(stackSize);
}

rule__Formula__Group_10__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFormulaAccess().getUntilKeyword_10_1()); }
	'until'
	{ after(grammarAccess.getFormulaAccess().getUntilKeyword_10_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Formula__Group_10__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Formula__Group_10__2__Impl
	rule__Formula__Group_10__3
;
finally {
	restoreStackSize(stackSize);
}

rule__Formula__Group_10__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFormulaAccess().getRightAssignment_10_2()); }
	(rule__Formula__RightAssignment_10_2)
	{ after(grammarAccess.getFormulaAccess().getRightAssignment_10_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Formula__Group_10__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Formula__Group_10__3__Impl
	rule__Formula__Group_10__4
;
finally {
	restoreStackSize(stackSize);
}

rule__Formula__Group_10__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFormulaAccess().getWeKeyword_10_3()); }
	'we'
	{ after(grammarAccess.getFormulaAccess().getWeKeyword_10_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Formula__Group_10__4
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Formula__Group_10__4__Impl
	rule__Formula__Group_10__5
;
finally {
	restoreStackSize(stackSize);
}

rule__Formula__Group_10__4__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFormulaAccess().getHaveKeyword_10_4()); }
	'have'
	{ after(grammarAccess.getFormulaAccess().getHaveKeyword_10_4()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Formula__Group_10__5
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Formula__Group_10__5__Impl
	rule__Formula__Group_10__6
;
finally {
	restoreStackSize(stackSize);
}

rule__Formula__Group_10__5__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFormulaAccess().getThatKeyword_10_5()); }
	'that'
	{ after(grammarAccess.getFormulaAccess().getThatKeyword_10_5()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Formula__Group_10__6
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Formula__Group_10__6__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__Formula__Group_10__6__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFormulaAccess().getLeftAssignment_10_6()); }
	(rule__Formula__LeftAssignment_10_6)
	{ after(grammarAccess.getFormulaAccess().getLeftAssignment_10_6()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__Formula__Group_11__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Formula__Group_11__0__Impl
	rule__Formula__Group_11__1
;
finally {
	restoreStackSize(stackSize);
}

rule__Formula__Group_11__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFormulaAccess().getUntilFormulaAction_11_0()); }
	()
	{ after(grammarAccess.getFormulaAccess().getUntilFormulaAction_11_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Formula__Group_11__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Formula__Group_11__1__Impl
	rule__Formula__Group_11__2
;
finally {
	restoreStackSize(stackSize);
}

rule__Formula__Group_11__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFormulaAccess().getByKeyword_11_1()); }
	'by'
	{ after(grammarAccess.getFormulaAccess().getByKeyword_11_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Formula__Group_11__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Formula__Group_11__2__Impl
	rule__Formula__Group_11__3
;
finally {
	restoreStackSize(stackSize);
}

rule__Formula__Group_11__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFormulaAccess().getIntervalAssignment_11_2()); }
	(rule__Formula__IntervalAssignment_11_2)
	{ after(grammarAccess.getFormulaAccess().getIntervalAssignment_11_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Formula__Group_11__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Formula__Group_11__3__Impl
	rule__Formula__Group_11__4
;
finally {
	restoreStackSize(stackSize);
}

rule__Formula__Group_11__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFormulaAccess().getRightAssignment_11_3()); }
	(rule__Formula__RightAssignment_11_3)
	{ after(grammarAccess.getFormulaAccess().getRightAssignment_11_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Formula__Group_11__4
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Formula__Group_11__4__Impl
	rule__Formula__Group_11__5
;
finally {
	restoreStackSize(stackSize);
}

rule__Formula__Group_11__4__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFormulaAccess().getAndKeyword_11_4()); }
	'and'
	{ after(grammarAccess.getFormulaAccess().getAndKeyword_11_4()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Formula__Group_11__5
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Formula__Group_11__5__Impl
	rule__Formula__Group_11__6
;
finally {
	restoreStackSize(stackSize);
}

rule__Formula__Group_11__5__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFormulaAccess().getUntilKeyword_11_5()); }
	'until'
	{ after(grammarAccess.getFormulaAccess().getUntilKeyword_11_5()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Formula__Group_11__6
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Formula__Group_11__6__Impl
	rule__Formula__Group_11__7
;
finally {
	restoreStackSize(stackSize);
}

rule__Formula__Group_11__6__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFormulaAccess().getThenKeyword_11_6()); }
	'then'
	{ after(grammarAccess.getFormulaAccess().getThenKeyword_11_6()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Formula__Group_11__7
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Formula__Group_11__7__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__Formula__Group_11__7__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFormulaAccess().getLeftAssignment_11_7()); }
	(rule__Formula__LeftAssignment_11_7)
	{ after(grammarAccess.getFormulaAccess().getLeftAssignment_11_7()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__StlAp__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__StlAp__Group__0__Impl
	rule__StlAp__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__StlAp__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getStlApAccess().getAlternatives_0()); }
	(rule__StlAp__Alternatives_0)
	{ after(grammarAccess.getStlApAccess().getAlternatives_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__StlAp__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__StlAp__Group__1__Impl
	rule__StlAp__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__StlAp__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getStlApAccess().getCompOpAssignment_1()); }
	(rule__StlAp__CompOpAssignment_1)
	{ after(grammarAccess.getStlApAccess().getCompOpAssignment_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__StlAp__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__StlAp__Group__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__StlAp__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getStlApAccess().getValAssignment_2()); }
	(rule__StlAp__ValAssignment_2)
	{ after(grammarAccess.getStlApAccess().getValAssignment_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__StlAp__Group_0_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__StlAp__Group_0_1__0__Impl
	rule__StlAp__Group_0_1__1
;
finally {
	restoreStackSize(stackSize);
}

rule__StlAp__Group_0_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getStlApAccess().getStlApDerivAction_0_1_0()); }
	()
	{ after(grammarAccess.getStlApAccess().getStlApDerivAction_0_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__StlAp__Group_0_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__StlAp__Group_0_1__1__Impl
	rule__StlAp__Group_0_1__2
;
finally {
	restoreStackSize(stackSize);
}

rule__StlAp__Group_0_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getStlApAccess().getDKeyword_0_1_1()); }
	'd'
	{ after(grammarAccess.getStlApAccess().getDKeyword_0_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__StlAp__Group_0_1__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__StlAp__Group_0_1__2__Impl
	rule__StlAp__Group_0_1__3
;
finally {
	restoreStackSize(stackSize);
}

rule__StlAp__Group_0_1__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getStlApAccess().getRefAssignment_0_1_2()); }
	(rule__StlAp__RefAssignment_0_1_2)
	{ after(grammarAccess.getStlApAccess().getRefAssignment_0_1_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__StlAp__Group_0_1__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__StlAp__Group_0_1__3__Impl
	rule__StlAp__Group_0_1__4
;
finally {
	restoreStackSize(stackSize);
}

rule__StlAp__Group_0_1__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getStlApAccess().getSolidusKeyword_0_1_3()); }
	'/'
	{ after(grammarAccess.getStlApAccess().getSolidusKeyword_0_1_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__StlAp__Group_0_1__4
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__StlAp__Group_0_1__4__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__StlAp__Group_0_1__4__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getStlApAccess().getDtKeyword_0_1_4()); }
	'dt'
	{ after(grammarAccess.getStlApAccess().getDtKeyword_0_1_4()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__MtlAp__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__MtlAp__Group__0__Impl
	rule__MtlAp__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__MtlAp__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getMtlApAccess().getAlternatives_0()); }
	(rule__MtlAp__Alternatives_0)?
	{ after(grammarAccess.getMtlApAccess().getAlternatives_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__MtlAp__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__MtlAp__Group__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__MtlAp__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getMtlApAccess().getFilterAssignment_1()); }
	(rule__MtlAp__FilterAssignment_1)
	{ after(grammarAccess.getMtlApAccess().getFilterAssignment_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__MtlAp__Group_0_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__MtlAp__Group_0_0__0__Impl
	rule__MtlAp__Group_0_0__1
;
finally {
	restoreStackSize(stackSize);
}

rule__MtlAp__Group_0_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getMtlApAccess().getMtlApStartAction_0_0_0()); }
	()
	{ after(grammarAccess.getMtlApAccess().getMtlApStartAction_0_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__MtlAp__Group_0_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__MtlAp__Group_0_0__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__MtlAp__Group_0_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getMtlApAccess().getStartKeyword_0_0_1()); }
	'start'
	{ after(grammarAccess.getMtlApAccess().getStartKeyword_0_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__MtlAp__Group_0_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__MtlAp__Group_0_1__0__Impl
	rule__MtlAp__Group_0_1__1
;
finally {
	restoreStackSize(stackSize);
}

rule__MtlAp__Group_0_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getMtlApAccess().getMtlApEndAction_0_1_0()); }
	()
	{ after(grammarAccess.getMtlApAccess().getMtlApEndAction_0_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__MtlAp__Group_0_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__MtlAp__Group_0_1__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__MtlAp__Group_0_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getMtlApAccess().getEndKeyword_0_1_1()); }
	'end'
	{ after(grammarAccess.getMtlApAccess().getEndKeyword_0_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__AttributeFilter__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__AttributeFilter__Group__0__Impl
	rule__AttributeFilter__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__AttributeFilter__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAttributeFilterAccess().getLeftCurlyBracketKeyword_0()); }
	'{'
	{ after(grammarAccess.getAttributeFilterAccess().getLeftCurlyBracketKeyword_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__AttributeFilter__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__AttributeFilter__Group__1__Impl
	rule__AttributeFilter__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__AttributeFilter__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAttributeFilterAccess().getKeyValsAssignment_1()); }
	(rule__AttributeFilter__KeyValsAssignment_1)
	{ after(grammarAccess.getAttributeFilterAccess().getKeyValsAssignment_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__AttributeFilter__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__AttributeFilter__Group__2__Impl
	rule__AttributeFilter__Group__3
;
finally {
	restoreStackSize(stackSize);
}

rule__AttributeFilter__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAttributeFilterAccess().getGroup_2()); }
	(rule__AttributeFilter__Group_2__0)*
	{ after(grammarAccess.getAttributeFilterAccess().getGroup_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__AttributeFilter__Group__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__AttributeFilter__Group__3__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__AttributeFilter__Group__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAttributeFilterAccess().getRightCurlyBracketKeyword_3()); }
	'}'
	{ after(grammarAccess.getAttributeFilterAccess().getRightCurlyBracketKeyword_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__AttributeFilter__Group_2__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__AttributeFilter__Group_2__0__Impl
	rule__AttributeFilter__Group_2__1
;
finally {
	restoreStackSize(stackSize);
}

rule__AttributeFilter__Group_2__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAttributeFilterAccess().getCommaKeyword_2_0()); }
	','
	{ after(grammarAccess.getAttributeFilterAccess().getCommaKeyword_2_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__AttributeFilter__Group_2__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__AttributeFilter__Group_2__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__AttributeFilter__Group_2__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAttributeFilterAccess().getKeyValsAssignment_2_1()); }
	(rule__AttributeFilter__KeyValsAssignment_2_1)
	{ after(grammarAccess.getAttributeFilterAccess().getKeyValsAssignment_2_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__KeyVal__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__KeyVal__Group__0__Impl
	rule__KeyVal__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__KeyVal__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getKeyValAccess().getAttAssignment_0()); }
	(rule__KeyVal__AttAssignment_0)
	{ after(grammarAccess.getKeyValAccess().getAttAssignment_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__KeyVal__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__KeyVal__Group__1__Impl
	rule__KeyVal__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__KeyVal__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getKeyValAccess().getEqualsSignKeyword_1()); }
	'='
	{ after(grammarAccess.getKeyValAccess().getEqualsSignKeyword_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__KeyVal__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__KeyVal__Group__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__KeyVal__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getKeyValAccess().getValAssignment_2()); }
	(rule__KeyVal__ValAssignment_2)
	{ after(grammarAccess.getKeyValAccess().getValAssignment_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__IdString__Group_2__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__IdString__Group_2__0__Impl
	rule__IdString__Group_2__1
;
finally {
	restoreStackSize(stackSize);
}

rule__IdString__Group_2__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getIdStringAccess().getLeftAssignment_2_0()); }
	(rule__IdString__LeftAssignment_2_0)
	{ after(grammarAccess.getIdStringAccess().getLeftAssignment_2_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__IdString__Group_2__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__IdString__Group_2__1__Impl
	rule__IdString__Group_2__2
;
finally {
	restoreStackSize(stackSize);
}

rule__IdString__Group_2__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getIdStringAccess().getPlusSignKeyword_2_1()); }
	'+'
	{ after(grammarAccess.getIdStringAccess().getPlusSignKeyword_2_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__IdString__Group_2__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__IdString__Group_2__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__IdString__Group_2__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getIdStringAccess().getIdAssignment_2_2()); }
	(rule__IdString__IdAssignment_2_2)
	{ after(grammarAccess.getIdStringAccess().getIdAssignment_2_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__IdString__Group_3__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__IdString__Group_3__0__Impl
	rule__IdString__Group_3__1
;
finally {
	restoreStackSize(stackSize);
}

rule__IdString__Group_3__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getIdStringAccess().getIdAssignment_3_0()); }
	(rule__IdString__IdAssignment_3_0)
	{ after(grammarAccess.getIdStringAccess().getIdAssignment_3_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__IdString__Group_3__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__IdString__Group_3__1__Impl
	rule__IdString__Group_3__2
;
finally {
	restoreStackSize(stackSize);
}

rule__IdString__Group_3__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getIdStringAccess().getPlusSignKeyword_3_1()); }
	'+'
	{ after(grammarAccess.getIdStringAccess().getPlusSignKeyword_3_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__IdString__Group_3__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__IdString__Group_3__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__IdString__Group_3__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getIdStringAccess().getRightAssignment_3_2()); }
	(rule__IdString__RightAssignment_3_2)
	{ after(grammarAccess.getIdStringAccess().getRightAssignment_3_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__IdString__Group_4__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__IdString__Group_4__0__Impl
	rule__IdString__Group_4__1
;
finally {
	restoreStackSize(stackSize);
}

rule__IdString__Group_4__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getIdStringAccess().getLeftAssignment_4_0()); }
	(rule__IdString__LeftAssignment_4_0)
	{ after(grammarAccess.getIdStringAccess().getLeftAssignment_4_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__IdString__Group_4__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__IdString__Group_4__1__Impl
	rule__IdString__Group_4__2
;
finally {
	restoreStackSize(stackSize);
}

rule__IdString__Group_4__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getIdStringAccess().getPlusSignKeyword_4_1()); }
	'+'
	{ after(grammarAccess.getIdStringAccess().getPlusSignKeyword_4_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__IdString__Group_4__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__IdString__Group_4__2__Impl
	rule__IdString__Group_4__3
;
finally {
	restoreStackSize(stackSize);
}

rule__IdString__Group_4__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getIdStringAccess().getIdAssignment_4_2()); }
	(rule__IdString__IdAssignment_4_2)
	{ after(grammarAccess.getIdStringAccess().getIdAssignment_4_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__IdString__Group_4__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__IdString__Group_4__3__Impl
	rule__IdString__Group_4__4
;
finally {
	restoreStackSize(stackSize);
}

rule__IdString__Group_4__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getIdStringAccess().getPlusSignKeyword_4_3()); }
	'+'
	{ after(grammarAccess.getIdStringAccess().getPlusSignKeyword_4_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__IdString__Group_4__4
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__IdString__Group_4__4__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__IdString__Group_4__4__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getIdStringAccess().getRightAssignment_4_4()); }
	(rule__IdString__RightAssignment_4_4)
	{ after(grammarAccess.getIdStringAccess().getRightAssignment_4_4()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__Interval__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Interval__Group__0__Impl
	rule__Interval__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__Interval__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getIntervalAccess().getAlternatives_0()); }
	(rule__Interval__Alternatives_0)
	{ after(grammarAccess.getIntervalAccess().getAlternatives_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Interval__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Interval__Group__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__Interval__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getIntervalAccess().getTimeUnitAssignment_1()); }
	(rule__Interval__TimeUnitAssignment_1)
	{ after(grammarAccess.getIntervalAccess().getTimeUnitAssignment_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__IntervalSS__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__IntervalSS__Group__0__Impl
	rule__IntervalSS__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__IntervalSS__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getIntervalSSAccess().getLeftParenthesisKeyword_0()); }
	'('
	{ after(grammarAccess.getIntervalSSAccess().getLeftParenthesisKeyword_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__IntervalSS__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__IntervalSS__Group__1__Impl
	rule__IntervalSS__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__IntervalSS__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getIntervalSSAccess().getLbAssignment_1()); }
	(rule__IntervalSS__LbAssignment_1)
	{ after(grammarAccess.getIntervalSSAccess().getLbAssignment_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__IntervalSS__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__IntervalSS__Group__2__Impl
	rule__IntervalSS__Group__3
;
finally {
	restoreStackSize(stackSize);
}

rule__IntervalSS__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getIntervalSSAccess().getCommaKeyword_2()); }
	','
	{ after(grammarAccess.getIntervalSSAccess().getCommaKeyword_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__IntervalSS__Group__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__IntervalSS__Group__3__Impl
	rule__IntervalSS__Group__4
;
finally {
	restoreStackSize(stackSize);
}

rule__IntervalSS__Group__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getIntervalSSAccess().getAlternatives_3()); }
	(rule__IntervalSS__Alternatives_3)
	{ after(grammarAccess.getIntervalSSAccess().getAlternatives_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__IntervalSS__Group__4
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__IntervalSS__Group__4__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__IntervalSS__Group__4__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getIntervalSSAccess().getRightParenthesisKeyword_4()); }
	')'
	{ after(grammarAccess.getIntervalSSAccess().getRightParenthesisKeyword_4()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__IntervalSN__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__IntervalSN__Group__0__Impl
	rule__IntervalSN__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__IntervalSN__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getIntervalSNAccess().getLeftParenthesisKeyword_0()); }
	'('
	{ after(grammarAccess.getIntervalSNAccess().getLeftParenthesisKeyword_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__IntervalSN__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__IntervalSN__Group__1__Impl
	rule__IntervalSN__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__IntervalSN__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getIntervalSNAccess().getLbAssignment_1()); }
	(rule__IntervalSN__LbAssignment_1)
	{ after(grammarAccess.getIntervalSNAccess().getLbAssignment_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__IntervalSN__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__IntervalSN__Group__2__Impl
	rule__IntervalSN__Group__3
;
finally {
	restoreStackSize(stackSize);
}

rule__IntervalSN__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getIntervalSNAccess().getCommaKeyword_2()); }
	','
	{ after(grammarAccess.getIntervalSNAccess().getCommaKeyword_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__IntervalSN__Group__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__IntervalSN__Group__3__Impl
	rule__IntervalSN__Group__4
;
finally {
	restoreStackSize(stackSize);
}

rule__IntervalSN__Group__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getIntervalSNAccess().getUbAssignment_3()); }
	(rule__IntervalSN__UbAssignment_3)
	{ after(grammarAccess.getIntervalSNAccess().getUbAssignment_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__IntervalSN__Group__4
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__IntervalSN__Group__4__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__IntervalSN__Group__4__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getIntervalSNAccess().getRightSquareBracketKeyword_4()); }
	']'
	{ after(grammarAccess.getIntervalSNAccess().getRightSquareBracketKeyword_4()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__IntervalNS__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__IntervalNS__Group__0__Impl
	rule__IntervalNS__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__IntervalNS__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getIntervalNSAccess().getLeftSquareBracketKeyword_0()); }
	'['
	{ after(grammarAccess.getIntervalNSAccess().getLeftSquareBracketKeyword_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__IntervalNS__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__IntervalNS__Group__1__Impl
	rule__IntervalNS__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__IntervalNS__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getIntervalNSAccess().getLbAssignment_1()); }
	(rule__IntervalNS__LbAssignment_1)
	{ after(grammarAccess.getIntervalNSAccess().getLbAssignment_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__IntervalNS__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__IntervalNS__Group__2__Impl
	rule__IntervalNS__Group__3
;
finally {
	restoreStackSize(stackSize);
}

rule__IntervalNS__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getIntervalNSAccess().getCommaKeyword_2()); }
	','
	{ after(grammarAccess.getIntervalNSAccess().getCommaKeyword_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__IntervalNS__Group__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__IntervalNS__Group__3__Impl
	rule__IntervalNS__Group__4
;
finally {
	restoreStackSize(stackSize);
}

rule__IntervalNS__Group__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getIntervalNSAccess().getAlternatives_3()); }
	(rule__IntervalNS__Alternatives_3)
	{ after(grammarAccess.getIntervalNSAccess().getAlternatives_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__IntervalNS__Group__4
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__IntervalNS__Group__4__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__IntervalNS__Group__4__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getIntervalNSAccess().getRightParenthesisKeyword_4()); }
	')'
	{ after(grammarAccess.getIntervalNSAccess().getRightParenthesisKeyword_4()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__IntervalNN__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__IntervalNN__Group__0__Impl
	rule__IntervalNN__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__IntervalNN__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getIntervalNNAccess().getLeftSquareBracketKeyword_0()); }
	'['
	{ after(grammarAccess.getIntervalNNAccess().getLeftSquareBracketKeyword_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__IntervalNN__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__IntervalNN__Group__1__Impl
	rule__IntervalNN__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__IntervalNN__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getIntervalNNAccess().getLbAssignment_1()); }
	(rule__IntervalNN__LbAssignment_1)
	{ after(grammarAccess.getIntervalNNAccess().getLbAssignment_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__IntervalNN__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__IntervalNN__Group__2__Impl
	rule__IntervalNN__Group__3
;
finally {
	restoreStackSize(stackSize);
}

rule__IntervalNN__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getIntervalNNAccess().getCommaKeyword_2()); }
	','
	{ after(grammarAccess.getIntervalNNAccess().getCommaKeyword_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__IntervalNN__Group__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__IntervalNN__Group__3__Impl
	rule__IntervalNN__Group__4
;
finally {
	restoreStackSize(stackSize);
}

rule__IntervalNN__Group__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getIntervalNNAccess().getUbAssignment_3()); }
	(rule__IntervalNN__UbAssignment_3)
	{ after(grammarAccess.getIntervalNNAccess().getUbAssignment_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__IntervalNN__Group__4
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__IntervalNN__Group__4__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__IntervalNN__Group__4__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getIntervalNNAccess().getRightSquareBracketKeyword_4()); }
	']'
	{ after(grammarAccess.getIntervalNNAccess().getRightSquareBracketKeyword_4()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__EtlModel__ElementsAssignment
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getEtlModelAccess().getElementsTopLevelModelElementParserRuleCall_0()); }
		ruleTopLevelModelElement
		{ after(grammarAccess.getEtlModelAccess().getElementsTopLevelModelElementParserRuleCall_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__TopLevelModelElement__NameAssignment_0_2
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getTopLevelModelElementAccess().getNameIDTerminalRuleCall_0_2_0()); }
		RULE_ID
		{ after(grammarAccess.getTopLevelModelElementAccess().getNameIDTerminalRuleCall_0_2_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__TopLevelModelElement__SignalAssignment_0_4
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getTopLevelModelElementAccess().getSignalSignalParserRuleCall_0_4_0()); }
		ruleSignal
		{ after(grammarAccess.getTopLevelModelElementAccess().getSignalSignalParserRuleCall_0_4_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__TopLevelModelElement__NameAssignment_1_2
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getTopLevelModelElementAccess().getNameIDTerminalRuleCall_1_2_0()); }
		RULE_ID
		{ after(grammarAccess.getTopLevelModelElementAccess().getNameIDTerminalRuleCall_1_2_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__TopLevelModelElement__ParamAssignment_1_3_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getTopLevelModelElementAccess().getParamIDTerminalRuleCall_1_3_1_0()); }
		RULE_ID
		{ after(grammarAccess.getTopLevelModelElementAccess().getParamIDTerminalRuleCall_1_3_1_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__TopLevelModelElement__FormulaAssignment_1_5
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getTopLevelModelElementAccess().getFormulaFormulaParserRuleCall_1_5_0()); }
		ruleFormula
		{ after(grammarAccess.getTopLevelModelElementAccess().getFormulaFormulaParserRuleCall_1_5_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__TopLevelModelElement__NameAssignment_2_2
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getTopLevelModelElementAccess().getNameIDTerminalRuleCall_2_2_0()); }
		RULE_ID
		{ after(grammarAccess.getTopLevelModelElementAccess().getNameIDTerminalRuleCall_2_2_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__TopLevelModelElement__VarAssignment_2_4_2
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getTopLevelModelElementAccess().getVarIDTerminalRuleCall_2_4_2_0()); }
		RULE_ID
		{ after(grammarAccess.getTopLevelModelElementAccess().getVarIDTerminalRuleCall_2_4_2_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__TopLevelModelElement__LbAssignment_2_4_4
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getTopLevelModelElementAccess().getLbINT_TTerminalRuleCall_2_4_4_0()); }
		RULE_INT_T
		{ after(grammarAccess.getTopLevelModelElementAccess().getLbINT_TTerminalRuleCall_2_4_4_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__TopLevelModelElement__UbAssignment_2_4_6
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getTopLevelModelElementAccess().getUbINT_TTerminalRuleCall_2_4_6_0()); }
		RULE_INT_T
		{ after(grammarAccess.getTopLevelModelElementAccess().getUbINT_TTerminalRuleCall_2_4_6_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__TopLevelModelElement__FormulaAssignment_2_5
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getTopLevelModelElementAccess().getFormulaFormulaParserRuleCall_2_5_0()); }
		ruleFormula
		{ after(grammarAccess.getTopLevelModelElementAccess().getFormulaFormulaParserRuleCall_2_5_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Signal__FilterAssignment_0_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getSignalAccess().getFilterAttributeFilterParserRuleCall_0_1_0()); }
		ruleAttributeFilter
		{ after(grammarAccess.getSignalAccess().getFilterAttributeFilterParserRuleCall_0_1_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Signal__IdAttAssignment_1_3_0
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getSignalAccess().getIdAttIDTerminalRuleCall_1_3_0_0()); }
		RULE_ID
		{ after(grammarAccess.getSignalAccess().getIdAttIDTerminalRuleCall_1_3_0_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Signal__ApAssignment_1_3_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getSignalAccess().getApMtlApParserRuleCall_1_3_1_0()); }
		ruleMtlAp
		{ after(grammarAccess.getSignalAccess().getApMtlApParserRuleCall_1_3_1_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Signal__ScaleAssignment_1_4_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getSignalAccess().getScaleTimeUnitEnumEnumRuleCall_1_4_1_0()); }
		ruleTimeUnitEnum
		{ after(grammarAccess.getSignalAccess().getScaleTimeUnitEnumEnumRuleCall_1_4_1_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Signal__ConvSpecAssignment_1_5
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getSignalAccess().getConvSpecConvSpecParserRuleCall_1_5_0()); }
		ruleConvSpec
		{ after(grammarAccess.getSignalAccess().getConvSpecConvSpecParserRuleCall_1_5_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Signal__IdAttAssignment_2_3
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getSignalAccess().getIdAttIDTerminalRuleCall_2_3_0()); }
		RULE_ID
		{ after(grammarAccess.getSignalAccess().getIdAttIDTerminalRuleCall_2_3_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Signal__ScaleAssignment_2_4_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getSignalAccess().getScaleTimeUnitEnumEnumRuleCall_2_4_1_0()); }
		ruleTimeUnitEnum
		{ after(grammarAccess.getSignalAccess().getScaleTimeUnitEnumEnumRuleCall_2_4_1_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Signal__ConvSpecAssignment_2_5
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getSignalAccess().getConvSpecConvSpecParserRuleCall_2_5_0()); }
		ruleConvSpec
		{ after(grammarAccess.getSignalAccess().getConvSpecConvSpecParserRuleCall_2_5_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Signal__IdAttAssignment_3_3
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getSignalAccess().getIdAttIDTerminalRuleCall_3_3_0()); }
		RULE_ID
		{ after(grammarAccess.getSignalAccess().getIdAttIDTerminalRuleCall_3_3_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Signal__ConvSpecAssignment_3_4
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getSignalAccess().getConvSpecConvSpecParserRuleCall_3_4_0()); }
		ruleConvSpec
		{ after(grammarAccess.getSignalAccess().getConvSpecConvSpecParserRuleCall_3_4_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Signal__FilterAssignment_4_2
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getSignalAccess().getFilterAttributeFilterParserRuleCall_4_2_0()); }
		ruleAttributeFilter
		{ after(grammarAccess.getSignalAccess().getFilterAttributeFilterParserRuleCall_4_2_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Signal__ConvSpecAssignment_4_3
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getSignalAccess().getConvSpecConvSpecParserRuleCall_4_3_0()); }
		ruleConvSpec
		{ after(grammarAccess.getSignalAccess().getConvSpecConvSpecParserRuleCall_4_3_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Signal__FilterAssignment_5_2
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getSignalAccess().getFilterAttributeFilterParserRuleCall_5_2_0()); }
		ruleAttributeFilter
		{ after(grammarAccess.getSignalAccess().getFilterAttributeFilterParserRuleCall_5_2_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Signal__ConvSpecAssignment_5_3
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getSignalAccess().getConvSpecConvSpecParserRuleCall_5_3_0()); }
		ruleConvSpec
		{ after(grammarAccess.getSignalAccess().getConvSpecConvSpecParserRuleCall_5_3_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__ConvSpec__WindowWidthAssignment_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getConvSpecAccess().getWindowWidthDOUBLE_TTerminalRuleCall_1_0()); }
		RULE_DOUBLE_T
		{ after(grammarAccess.getConvSpecAccess().getWindowWidthDOUBLE_TTerminalRuleCall_1_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__ConvSpec__WindowUnitAssignment_2
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getConvSpecAccess().getWindowUnitTimeUnitEnumEnumRuleCall_2_0()); }
		ruleTimeUnitEnum
		{ after(grammarAccess.getConvSpecAccess().getWindowUnitTimeUnitEnumEnumRuleCall_2_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Formula__DefAssignment_0_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getFormulaAccess().getDefDefCrossReference_0_1_0()); }
		(
			{ before(grammarAccess.getFormulaAccess().getDefDefIDTerminalRuleCall_0_1_0_1()); }
			RULE_ID
			{ after(grammarAccess.getFormulaAccess().getDefDefIDTerminalRuleCall_0_1_0_1()); }
		)
		{ after(grammarAccess.getFormulaAccess().getDefDefCrossReference_0_1_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Formula__ParamAssignment_0_2_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getFormulaAccess().getParamIDTerminalRuleCall_0_2_1_0()); }
		RULE_ID
		{ after(grammarAccess.getFormulaAccess().getParamIDTerminalRuleCall_0_2_1_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Formula__ValAssignment_0_2_2_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getFormulaAccess().getValINT_TTerminalRuleCall_0_2_2_1_0()); }
		RULE_INT_T
		{ after(grammarAccess.getFormulaAccess().getValINT_TTerminalRuleCall_0_2_2_1_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Formula__MtlAPAssignment_1_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getFormulaAccess().getMtlAPMtlApParserRuleCall_1_1_0()); }
		ruleMtlAp
		{ after(grammarAccess.getFormulaAccess().getMtlAPMtlApParserRuleCall_1_1_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Formula__StlAPAssignment_2_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getFormulaAccess().getStlAPStlApParserRuleCall_2_1_0()); }
		ruleStlAp
		{ after(grammarAccess.getFormulaAccess().getStlAPStlApParserRuleCall_2_1_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Formula__FormulaAssignment_3_2
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getFormulaAccess().getFormulaFormulaParserRuleCall_3_2_0()); }
		ruleFormula
		{ after(grammarAccess.getFormulaAccess().getFormulaFormulaParserRuleCall_3_2_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Formula__LeftAssignment_4_2
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getFormulaAccess().getLeftFormulaParserRuleCall_4_2_0()); }
		ruleFormula
		{ after(grammarAccess.getFormulaAccess().getLeftFormulaParserRuleCall_4_2_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Formula__OpAssignment_4_3
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getFormulaAccess().getOpAndOrEnumRuleCall_4_3_0()); }
		ruleAndOr
		{ after(grammarAccess.getFormulaAccess().getOpAndOrEnumRuleCall_4_3_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Formula__RightAssignment_4_4
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getFormulaAccess().getRightFormulaParserRuleCall_4_4_0()); }
		ruleFormula
		{ after(grammarAccess.getFormulaAccess().getRightFormulaParserRuleCall_4_4_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Formula__LeftAssignment_5_2
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getFormulaAccess().getLeftFormulaParserRuleCall_5_2_0()); }
		ruleFormula
		{ after(grammarAccess.getFormulaAccess().getLeftFormulaParserRuleCall_5_2_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Formula__RightAssignment_5_4
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getFormulaAccess().getRightFormulaParserRuleCall_5_4_0()); }
		ruleFormula
		{ after(grammarAccess.getFormulaAccess().getRightFormulaParserRuleCall_5_4_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Formula__FormulaAssignment_6_2
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getFormulaAccess().getFormulaFormulaParserRuleCall_6_2_0()); }
		ruleFormula
		{ after(grammarAccess.getFormulaAccess().getFormulaFormulaParserRuleCall_6_2_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Formula__IntervalAssignment_7_2
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getFormulaAccess().getIntervalIntervalParserRuleCall_7_2_0()); }
		ruleInterval
		{ after(grammarAccess.getFormulaAccess().getIntervalIntervalParserRuleCall_7_2_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Formula__FormulaAssignment_7_3
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getFormulaAccess().getFormulaFormulaParserRuleCall_7_3_0()); }
		ruleFormula
		{ after(grammarAccess.getFormulaAccess().getFormulaFormulaParserRuleCall_7_3_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Formula__FormulaAssignment_8_2
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getFormulaAccess().getFormulaFormulaParserRuleCall_8_2_0()); }
		ruleFormula
		{ after(grammarAccess.getFormulaAccess().getFormulaFormulaParserRuleCall_8_2_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Formula__IntervalAssignment_9_2
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getFormulaAccess().getIntervalIntervalParserRuleCall_9_2_0()); }
		ruleInterval
		{ after(grammarAccess.getFormulaAccess().getIntervalIntervalParserRuleCall_9_2_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Formula__FormulaAssignment_9_3
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getFormulaAccess().getFormulaFormulaParserRuleCall_9_3_0()); }
		ruleFormula
		{ after(grammarAccess.getFormulaAccess().getFormulaFormulaParserRuleCall_9_3_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Formula__RightAssignment_10_2
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getFormulaAccess().getRightFormulaParserRuleCall_10_2_0()); }
		ruleFormula
		{ after(grammarAccess.getFormulaAccess().getRightFormulaParserRuleCall_10_2_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Formula__LeftAssignment_10_6
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getFormulaAccess().getLeftFormulaParserRuleCall_10_6_0()); }
		ruleFormula
		{ after(grammarAccess.getFormulaAccess().getLeftFormulaParserRuleCall_10_6_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Formula__IntervalAssignment_11_2
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getFormulaAccess().getIntervalIntervalParserRuleCall_11_2_0()); }
		ruleInterval
		{ after(grammarAccess.getFormulaAccess().getIntervalIntervalParserRuleCall_11_2_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Formula__RightAssignment_11_3
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getFormulaAccess().getRightFormulaParserRuleCall_11_3_0()); }
		ruleFormula
		{ after(grammarAccess.getFormulaAccess().getRightFormulaParserRuleCall_11_3_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Formula__LeftAssignment_11_7
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getFormulaAccess().getLeftFormulaParserRuleCall_11_7_0()); }
		ruleFormula
		{ after(grammarAccess.getFormulaAccess().getLeftFormulaParserRuleCall_11_7_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__StlAp__RefAssignment_0_0
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getStlApAccess().getRefSignalDefCrossReference_0_0_0()); }
		(
			{ before(grammarAccess.getStlApAccess().getRefSignalDefIDTerminalRuleCall_0_0_0_1()); }
			RULE_ID
			{ after(grammarAccess.getStlApAccess().getRefSignalDefIDTerminalRuleCall_0_0_0_1()); }
		)
		{ after(grammarAccess.getStlApAccess().getRefSignalDefCrossReference_0_0_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__StlAp__RefAssignment_0_1_2
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getStlApAccess().getRefSignalDefCrossReference_0_1_2_0()); }
		(
			{ before(grammarAccess.getStlApAccess().getRefSignalDefIDTerminalRuleCall_0_1_2_0_1()); }
			RULE_ID
			{ after(grammarAccess.getStlApAccess().getRefSignalDefIDTerminalRuleCall_0_1_2_0_1()); }
		)
		{ after(grammarAccess.getStlApAccess().getRefSignalDefCrossReference_0_1_2_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__StlAp__CompOpAssignment_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getStlApAccess().getCompOpCompOpEnumRuleCall_1_0()); }
		ruleCompOp
		{ after(grammarAccess.getStlApAccess().getCompOpCompOpEnumRuleCall_1_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__StlAp__ValAssignment_2
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getStlApAccess().getValDOUBLE_TTerminalRuleCall_2_0()); }
		RULE_DOUBLE_T
		{ after(grammarAccess.getStlApAccess().getValDOUBLE_TTerminalRuleCall_2_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__MtlAp__FilterAssignment_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getMtlApAccess().getFilterAttributeFilterParserRuleCall_1_0()); }
		ruleAttributeFilter
		{ after(grammarAccess.getMtlApAccess().getFilterAttributeFilterParserRuleCall_1_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__AttributeFilter__KeyValsAssignment_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getAttributeFilterAccess().getKeyValsKeyValParserRuleCall_1_0()); }
		ruleKeyVal
		{ after(grammarAccess.getAttributeFilterAccess().getKeyValsKeyValParserRuleCall_1_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__AttributeFilter__KeyValsAssignment_2_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getAttributeFilterAccess().getKeyValsKeyValParserRuleCall_2_1_0()); }
		ruleKeyVal
		{ after(grammarAccess.getAttributeFilterAccess().getKeyValsKeyValParserRuleCall_2_1_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__KeyVal__AttAssignment_0
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getKeyValAccess().getAttIdStringParserRuleCall_0_0()); }
		ruleIdString
		{ after(grammarAccess.getKeyValAccess().getAttIdStringParserRuleCall_0_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__KeyVal__ValAssignment_2
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getKeyValAccess().getValIdStringParserRuleCall_2_0()); }
		ruleIdString
		{ after(grammarAccess.getKeyValAccess().getValIdStringParserRuleCall_2_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__IdString__LeftAssignment_0
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getIdStringAccess().getLeftSTRINGTerminalRuleCall_0_0()); }
		RULE_STRING
		{ after(grammarAccess.getIdStringAccess().getLeftSTRINGTerminalRuleCall_0_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__IdString__IdAssignment_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getIdStringAccess().getIdIDTerminalRuleCall_1_0()); }
		RULE_ID
		{ after(grammarAccess.getIdStringAccess().getIdIDTerminalRuleCall_1_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__IdString__LeftAssignment_2_0
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getIdStringAccess().getLeftSTRINGTerminalRuleCall_2_0_0()); }
		RULE_STRING
		{ after(grammarAccess.getIdStringAccess().getLeftSTRINGTerminalRuleCall_2_0_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__IdString__IdAssignment_2_2
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getIdStringAccess().getIdIDTerminalRuleCall_2_2_0()); }
		RULE_ID
		{ after(grammarAccess.getIdStringAccess().getIdIDTerminalRuleCall_2_2_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__IdString__IdAssignment_3_0
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getIdStringAccess().getIdIDTerminalRuleCall_3_0_0()); }
		RULE_ID
		{ after(grammarAccess.getIdStringAccess().getIdIDTerminalRuleCall_3_0_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__IdString__RightAssignment_3_2
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getIdStringAccess().getRightSTRINGTerminalRuleCall_3_2_0()); }
		RULE_STRING
		{ after(grammarAccess.getIdStringAccess().getRightSTRINGTerminalRuleCall_3_2_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__IdString__LeftAssignment_4_0
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getIdStringAccess().getLeftSTRINGTerminalRuleCall_4_0_0()); }
		RULE_STRING
		{ after(grammarAccess.getIdStringAccess().getLeftSTRINGTerminalRuleCall_4_0_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__IdString__IdAssignment_4_2
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getIdStringAccess().getIdIDTerminalRuleCall_4_2_0()); }
		RULE_ID
		{ after(grammarAccess.getIdStringAccess().getIdIDTerminalRuleCall_4_2_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__IdString__RightAssignment_4_4
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getIdStringAccess().getRightSTRINGTerminalRuleCall_4_4_0()); }
		RULE_STRING
		{ after(grammarAccess.getIdStringAccess().getRightSTRINGTerminalRuleCall_4_4_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Interval__IssAssignment_0_0
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getIntervalAccess().getIssIntervalSSParserRuleCall_0_0_0()); }
		ruleIntervalSS
		{ after(grammarAccess.getIntervalAccess().getIssIntervalSSParserRuleCall_0_0_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Interval__IsnAssignment_0_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getIntervalAccess().getIsnIntervalSNParserRuleCall_0_1_0()); }
		ruleIntervalSN
		{ after(grammarAccess.getIntervalAccess().getIsnIntervalSNParserRuleCall_0_1_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Interval__InsAssignment_0_2
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getIntervalAccess().getInsIntervalNSParserRuleCall_0_2_0()); }
		ruleIntervalNS
		{ after(grammarAccess.getIntervalAccess().getInsIntervalNSParserRuleCall_0_2_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Interval__InnAssignment_0_3
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getIntervalAccess().getInnIntervalNNParserRuleCall_0_3_0()); }
		ruleIntervalNN
		{ after(grammarAccess.getIntervalAccess().getInnIntervalNNParserRuleCall_0_3_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Interval__TimeUnitAssignment_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getIntervalAccess().getTimeUnitTimeUnitEnumEnumRuleCall_1_0()); }
		ruleTimeUnitEnum
		{ after(grammarAccess.getIntervalAccess().getTimeUnitTimeUnitEnumEnumRuleCall_1_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__IntervalSS__LbAssignment_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getIntervalSSAccess().getLbDOUBLE_TTerminalRuleCall_1_0()); }
		RULE_DOUBLE_T
		{ after(grammarAccess.getIntervalSSAccess().getLbDOUBLE_TTerminalRuleCall_1_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__IntervalSS__UbAssignment_3_0
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getIntervalSSAccess().getUbDOUBLE_TTerminalRuleCall_3_0_0()); }
		RULE_DOUBLE_T
		{ after(grammarAccess.getIntervalSSAccess().getUbDOUBLE_TTerminalRuleCall_3_0_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__IntervalSS__InftyAssignment_3_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getIntervalSSAccess().getInftyInftyKeyword_3_1_0()); }
		(
			{ before(grammarAccess.getIntervalSSAccess().getInftyInftyKeyword_3_1_0()); }
			'Infty'
			{ after(grammarAccess.getIntervalSSAccess().getInftyInftyKeyword_3_1_0()); }
		)
		{ after(grammarAccess.getIntervalSSAccess().getInftyInftyKeyword_3_1_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__IntervalSN__LbAssignment_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getIntervalSNAccess().getLbDOUBLE_TTerminalRuleCall_1_0()); }
		RULE_DOUBLE_T
		{ after(grammarAccess.getIntervalSNAccess().getLbDOUBLE_TTerminalRuleCall_1_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__IntervalSN__UbAssignment_3
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getIntervalSNAccess().getUbDOUBLE_TTerminalRuleCall_3_0()); }
		RULE_DOUBLE_T
		{ after(grammarAccess.getIntervalSNAccess().getUbDOUBLE_TTerminalRuleCall_3_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__IntervalNS__LbAssignment_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getIntervalNSAccess().getLbDOUBLE_TTerminalRuleCall_1_0()); }
		RULE_DOUBLE_T
		{ after(grammarAccess.getIntervalNSAccess().getLbDOUBLE_TTerminalRuleCall_1_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__IntervalNS__UbAssignment_3_0
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getIntervalNSAccess().getUbDOUBLE_TTerminalRuleCall_3_0_0()); }
		RULE_DOUBLE_T
		{ after(grammarAccess.getIntervalNSAccess().getUbDOUBLE_TTerminalRuleCall_3_0_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__IntervalNS__InftyAssignment_3_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getIntervalNSAccess().getInftyInftyKeyword_3_1_0()); }
		(
			{ before(grammarAccess.getIntervalNSAccess().getInftyInftyKeyword_3_1_0()); }
			'Infty'
			{ after(grammarAccess.getIntervalNSAccess().getInftyInftyKeyword_3_1_0()); }
		)
		{ after(grammarAccess.getIntervalNSAccess().getInftyInftyKeyword_3_1_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__IntervalNN__LbAssignment_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getIntervalNNAccess().getLbDOUBLE_TTerminalRuleCall_1_0()); }
		RULE_DOUBLE_T
		{ after(grammarAccess.getIntervalNNAccess().getLbDOUBLE_TTerminalRuleCall_1_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__IntervalNN__UbAssignment_3
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getIntervalNNAccess().getUbDOUBLE_TTerminalRuleCall_3_0()); }
		RULE_DOUBLE_T
		{ after(grammarAccess.getIntervalNNAccess().getUbDOUBLE_TTerminalRuleCall_3_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

RULE_INT_T : '-'? RULE_INT;

RULE_DOUBLE_T : '-'? RULE_INT '.' RULE_INT;

RULE_ID : '^'? ('a'..'z'|'A'..'Z'|'_') ('a'..'z'|'A'..'Z'|'_'|'0'..'9')*;

fragment RULE_INT : ('0'..'9')+;

RULE_STRING : ('"' ('\\' .|~(('\\'|'"')))* '"'|'\'' ('\\' .|~(('\\'|'\'')))* '\'');

RULE_ML_COMMENT : '/*' ( options {greedy=false;} : . )*'*/';

RULE_SL_COMMENT : '//' ~(('\n'|'\r'))* ('\r'? '\n')?;

RULE_WS : (' '|'\t'|'\r'|'\n')+;

RULE_ANY_OTHER : .;
