/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.trace4cps.core.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.eclipse.trace4cps.core.IAttributeAware;
import org.eclipse.trace4cps.core.IAttributeFilter;
import org.eclipse.trace4cps.core.IClaim;
import org.eclipse.trace4cps.core.IClaimEvent;
import org.eclipse.trace4cps.core.IDependency;
import org.eclipse.trace4cps.core.IEvent;
import org.eclipse.trace4cps.core.IExtendableTrace;
import org.eclipse.trace4cps.core.IFilteredTrace;
import org.eclipse.trace4cps.core.IPsop;
import org.eclipse.trace4cps.core.IResource;
import org.eclipse.trace4cps.core.ITimeSeries;
import org.eclipse.trace4cps.core.ITrace;
import org.eclipse.trace4cps.core.TracePart;

public class ModifiableTrace
implements IFilteredTrace,
IExtendableTrace {
    private final List<IAttributeFilter> claimFilters = new ArrayList<IAttributeFilter>();
    private final List<IAttributeFilter> resourceFilters = new ArrayList<IAttributeFilter>();
    private final List<IAttributeFilter> eventFilters = new ArrayList<IAttributeFilter>();
    private final List<IAttributeFilter> signalFilters = new ArrayList<IAttributeFilter>();
    private final List<IAttributeFilter> timeSeriesFilters = new ArrayList<IAttributeFilter>();
    private final List<IAttributeFilter> dependencyFilters = new ArrayList<IAttributeFilter>();
    private final ITrace wrapped;
    private List<IClaim> claims;
    private List<IResource> resources;
    private List<IEvent> events;
    private List<IDependency> dependencies;
    private List<IPsop> signals;
    private List<ITimeSeries> timeSeries;
    private List<IDependency> extDependencies = new ArrayList<IDependency>();
    private List<IPsop> extSignals = new ArrayList<IPsop>();
    private List<ITimeSeries> extTimeSeries = new ArrayList<ITimeSeries>();
    private List<IEvent> extEvents = new ArrayList<IEvent>();
    private List<IClaim> extClaims = new ArrayList<IClaim>();
    private List<IResource> extResources = new ArrayList<IResource>();
    private static final Comparator<IEvent> EVENT_COMP = new Comparator<IEvent>(){

        @Override
        public int compare(IEvent e1, IEvent e2) {
            return Double.compare(e1.getTimestamp().doubleValue(), e2.getTimestamp().doubleValue());
        }
    };

    public ModifiableTrace(ITrace trace) {
        this.wrapped = trace;
        this.clearFilter(TracePart.ALL);
    }

    @Override
    public void addDependencies(Collection<IDependency> dependencies) {
        this.extDependencies.addAll(dependencies);
        this.recalculate();
    }

    @Override
    public void addSignal(IPsop p) {
        this.extSignals.add(p);
        this.recalculate();
    }

    @Override
    public void addTimeSeries(ITimeSeries series) {
        this.extTimeSeries.add(series);
        this.recalculate();
    }

    @Override
    public void addEvents(Collection<IEvent> events) {
        this.extEvents.addAll(events);
        this.recalculate();
    }

    @Override
    public void addClaims(Collection<IClaim> claims) {
        this.extClaims.addAll(claims);
        for (IClaim claim : claims) {
            this.extEvents.add(claim.getStartEvent());
            this.extEvents.add(claim.getEndEvent());
            if (this.extResources.contains(claim.getResource())) continue;
            this.extResources.add(claim.getResource());
        }
        this.recalculate();
    }

    @Override
    public boolean hasExtension(TracePart part) {
        switch (part) {
            case ALL: {
                return !this.extSignals.isEmpty() || !this.extTimeSeries.isEmpty() || !this.extDependencies.isEmpty() || !this.extEvents.isEmpty();
            }
            case SIGNAL: {
                return !this.extSignals.isEmpty();
            }
            case TIMESERIES: {
                return !this.extTimeSeries.isEmpty();
            }
            case DEPENDENCY: {
                return !this.extDependencies.isEmpty();
            }
            case EVENT: {
                return !this.extEvents.isEmpty();
            }
            case CLAIM: {
                return !this.extClaims.isEmpty();
            }
        }
        return false;
    }

    @Override
    public void clearExtension(TracePart part) {
        switch (part) {
            case ALL: {
                this.extSignals.clear();
                this.extTimeSeries.clear();
                this.extDependencies.clear();
                this.extEvents.clear();
                this.extClaims.clear();
                this.extResources.clear();
                break;
            }
            case SIGNAL: {
                this.extSignals.clear();
                break;
            }
            case TIMESERIES: {
                this.extTimeSeries.clear();
                break;
            }
            case DEPENDENCY: {
                this.extDependencies.clear();
                break;
            }
            case EVENT: {
                this.extEvents.clear();
                for (IClaim c : this.extClaims) {
                    this.extEvents.add(c.getStartEvent());
                    this.extEvents.add(c.getEndEvent());
                }
                Collections.sort(this.extEvents, EVENT_COMP);
                break;
            }
            case CLAIM: {
                this.extResources.clear();
                for (IClaim c : this.extClaims) {
                    this.extEvents.remove(c.getStartEvent());
                    this.extEvents.remove(c.getEndEvent());
                }
                this.extClaims.clear();
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        this.recalculate();
    }

    @Override
    public void clearFilter(TracePart type) {
        if (type == TracePart.ALL) {
            this.clearInt(TracePart.CLAIM);
            this.clearInt(TracePart.EVENT);
            this.clearInt(TracePart.RESOURCE);
            this.clearInt(TracePart.DEPENDENCY);
            this.clearInt(TracePart.SIGNAL);
            this.clearInt(TracePart.TIMESERIES);
        } else {
            this.clearInt(type);
        }
        this.recalculate();
    }

    private void clearInt(TracePart type) {
        switch (type) {
            case CLAIM: {
                this.claimFilters.clear();
                break;
            }
            case EVENT: {
                this.eventFilters.clear();
                break;
            }
            case RESOURCE: {
                this.resourceFilters.clear();
                break;
            }
            case DEPENDENCY: {
                this.dependencyFilters.clear();
                break;
            }
            case SIGNAL: {
                this.signalFilters.clear();
                break;
            }
            case TIMESERIES: {
                this.timeSeriesFilters.clear();
                break;
            }
            case ALL: {
                throw new IllegalStateException("should not be called");
            }
        }
    }

    public void addFilter(TracePart type, IAttributeFilter filter) {
        this.addFilter(type, false, filter);
    }

    public void addFilterAndRecalculate(TracePart type, IAttributeFilter filter) {
        this.addFilter(type, true, filter);
    }

    private void addFilter(TracePart type, boolean recalc, IAttributeFilter filter) {
        switch (type) {
            case CLAIM: {
                this.addFilter(this.claimFilters, filter);
                break;
            }
            case RESOURCE: {
                this.addFilter(this.resourceFilters, filter);
                break;
            }
            case EVENT: {
                this.addFilter(this.eventFilters, filter);
                break;
            }
            case SIGNAL: {
                this.addFilter(this.signalFilters, filter);
                break;
            }
            case TIMESERIES: {
                this.addFilter(this.timeSeriesFilters, filter);
                break;
            }
            case DEPENDENCY: {
                this.addFilter(this.dependencyFilters, filter);
                break;
            }
            case ALL: {
                this.addFilter(this.claimFilters, filter);
                this.addFilter(this.resourceFilters, filter);
                this.addFilter(this.eventFilters, filter);
                this.addFilter(this.signalFilters, filter);
                this.addFilter(this.timeSeriesFilters, filter);
                this.addFilter(this.dependencyFilters, filter);
            }
        }
        if (recalc) {
            this.recalculate();
        }
    }

    private void addFilter(List<IAttributeFilter> l, IAttributeFilter filter) {
        if (filter != null) {
            l.add(filter);
        }
    }

    @Override
    public void recalculate() {
        this.recalcResources();
        this.recalcClaims();
        this.recalcEvents();
        this.recalcDependencies();
        this.recalcSignals();
        this.recalcTimeSeries();
    }

    private void recalcSignals() {
        this.signals = new ArrayList<IPsop>();
        this.signals.addAll(this.wrapped.getSignals());
        this.signals.addAll(this.extSignals);
        if (!this.signalFilters.isEmpty()) {
            this.signals = this.recalc(this.signals, this.signalFilters, null);
        }
    }

    private void recalcTimeSeries() {
        this.timeSeries = new ArrayList<ITimeSeries>();
        this.timeSeries.addAll(this.wrapped.getTimeSeries());
        this.timeSeries.addAll(this.extTimeSeries);
        if (!this.timeSeriesFilters.isEmpty()) {
            this.timeSeries = this.recalc(this.timeSeries, this.timeSeriesFilters, null);
        }
    }

    private void recalcDependencies() {
        this.dependencies = new ArrayList<IDependency>();
        this.dependencies.addAll(this.wrapped.getDependencies());
        this.dependencies.addAll(this.extDependencies);
        if (!(this.dependencyFilters.isEmpty() && this.eventFilters.isEmpty() && this.claimFilters.isEmpty() && this.resourceFilters.isEmpty())) {
            this.dependencies = this.recalc(this.dependencies, this.dependencyFilters, new InclusionConstraint<IDependency>(this){

                @Override
                boolean include(IDependency a) {
                    return events.contains(a.getSrc()) && events.contains(a.getDst());
                }
            });
        }
    }

    private void recalcEvents() {
        this.events = new ArrayList<IEvent>();
        this.events.addAll(this.extEvents);
        this.events.addAll(this.wrapped.getEvents());
        Collections.sort(this.events, EVENT_COMP);
        if (!(this.eventFilters.isEmpty() && this.claimFilters.isEmpty() && this.resourceFilters.isEmpty())) {
            this.events = this.recalc(this.events, this.eventFilters, new InclusionConstraint<IEvent>(this){

                @Override
                boolean include(IEvent a) {
                    if (a instanceof IClaimEvent) {
                        return claims.contains(((IClaimEvent)a).getClaim());
                    }
                    return true;
                }
            });
        }
    }

    private void recalcClaims() {
        this.claims = new ArrayList<IClaim>();
        this.claims.addAll(this.extClaims);
        this.claims.addAll(this.wrapped.getClaims());
        if (!this.claimFilters.isEmpty() || !this.resourceFilters.isEmpty()) {
            this.claims = this.recalc(this.claims, this.claimFilters, new InclusionConstraint<IClaim>(this){

                @Override
                boolean include(IClaim c) {
                    return resources.contains(c.getResource());
                }
            });
        }
    }

    private void recalcResources() {
        this.resources = new ArrayList<IResource>();
        this.resources.addAll(this.extResources);
        this.resources.addAll(this.wrapped.getResources());
        if (!this.resourceFilters.isEmpty()) {
            this.resources = this.recalc(this.resources, this.resourceFilters, null);
        }
    }

    private <T extends IAttributeAware> List<T> recalc(List<T> origList, List<IAttributeFilter> filters, InclusionConstraint<T> constraint) {
        ArrayList<IAttributeAware> filteredList = new ArrayList<IAttributeAware>();
        for (IAttributeAware r : origList) {
            if (!this.matches(r, filters) || constraint != null && !constraint.include(r)) continue;
            filteredList.add(r);
        }
        return filteredList;
    }

    private boolean matches(IAttributeAware a, List<IAttributeFilter> filters) {
        if (filters.isEmpty()) {
            return true;
        }
        for (IAttributeFilter f : filters) {
            if (f.include(a)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Number getTimeOffset() {
        return this.wrapped.getTimeOffset();
    }

    @Override
    public TimeUnit getTimeUnit() {
        return this.wrapped.getTimeUnit();
    }

    @Override
    public List<IClaim> getClaims() {
        return this.claims;
    }

    @Override
    public List<IResource> getResources() {
        return this.resources;
    }

    @Override
    public List<IEvent> getEvents() {
        return this.events;
    }

    @Override
    public List<IDependency> getDependencies() {
        return this.dependencies;
    }

    @Override
    public List<IPsop> getSignals() {
        return this.signals;
    }

    @Override
    public List<ITimeSeries> getTimeSeries() {
        return this.timeSeries;
    }

    @Override
    public String getAttributeValue(String key) {
        return this.wrapped.getAttributeValue(key);
    }

    @Override
    public Map<String, String> getAttributes() {
        return this.wrapped.getAttributes();
    }

    @Override
    public void setAttribute(String key, String value) {
        this.wrapped.setAttribute(key, value);
    }

    @Override
    public void clearAttributes() {
        this.wrapped.clearAttributes();
    }

    private abstract class InclusionConstraint<T extends IAttributeAware> {
        private InclusionConstraint() {
        }

        abstract boolean include(T var1);
    }
}

