/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.trace4cps.common.jfreechart.data.xy;

import java.util.Objects;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.eclipse.trace4cps.common.jfreechart.data.xy.XYEdgeSeriesCollection;
import org.jfree.chart.plot.XYPlot;
import org.jfree.data.time.TimePeriodValuesCollection;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.time.ohlc.OHLCSeriesCollection;
import org.jfree.data.xy.VectorSeriesCollection;
import org.jfree.data.xy.XIntervalSeriesCollection;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYIntervalSeriesCollection;
import org.jfree.data.xy.XYSeriesCollection;
import org.jfree.data.xy.YIntervalSeriesCollection;

public class XYDataItemResolver {
    public static final XYDataItemResolver DEFAULT = new XYDataItemResolver();

    public Stream<Object> resolveAllDataItems(XYPlot plot) {
        return plot.getDatasets().values().stream().flatMap(this::resolveAllDataItems);
    }

    public Stream<Object> resolveAllDataItems(XYDataset dataset) {
        Stream<Integer> seriesStream = IntStream.range(0, dataset.getSeriesCount()).boxed();
        return seriesStream.flatMap(series -> {
            IntStream itemStream = IntStream.range(0, dataset.getItemCount(series.intValue()));
            return itemStream.mapToObj(item -> this.resolveDataItem(dataset, (int)series, item)).filter(Objects::nonNull);
        });
    }

    public Object resolveDataItem(XYDataset dataset, int series, int item) {
        if (series >= dataset.getSeriesCount() || item >= dataset.getItemCount(series)) {
            return null;
        }
        if (dataset instanceof XYIntervalSeriesCollection) {
            return ((XYIntervalSeriesCollection)dataset).getSeries(series).getDataItem(item);
        }
        if (dataset instanceof XYSeriesCollection) {
            return ((XYSeriesCollection)dataset).getSeries(series).getDataItem(item);
        }
        if (dataset instanceof XYEdgeSeriesCollection) {
            return ((XYEdgeSeriesCollection)dataset).getSeries(series).getDataItem(item);
        }
        if (dataset instanceof XIntervalSeriesCollection) {
            return ((XIntervalSeriesCollection)dataset).getSeries(series).getDataItem(item);
        }
        if (dataset instanceof YIntervalSeriesCollection) {
            return ((YIntervalSeriesCollection)dataset).getSeries(series).getDataItem(item);
        }
        if (dataset instanceof OHLCSeriesCollection) {
            return ((OHLCSeriesCollection)dataset).getSeries(series).getDataItem(item);
        }
        if (dataset instanceof TimePeriodValuesCollection) {
            return ((TimePeriodValuesCollection)dataset).getSeries(series).getDataItem(item);
        }
        if (dataset instanceof TimeSeriesCollection) {
            return ((TimeSeriesCollection)dataset).getSeries(series).getDataItem(item);
        }
        if (dataset instanceof VectorSeriesCollection) {
            return ((VectorSeriesCollection)dataset).getSeries(series).getDataItem(item);
        }
        return null;
    }
}

