/*
 * Copyright (c) 2021, 2025 Contributors to the Eclipse Foundation
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 */

package org.eclipse.trace4cps.core;

import org.eclipse.trace4cps.core.impl.TimeValuePair;

/**
 * Data block which forms a {@link ITSSeries}
 */
public interface ITSPoints extends Comparable<ITSPoints> {
    /**
     * The {@link TimeValuePair} are ordered by their time-domain and are consecutive.
     *
     * @return the TimeSeriesPoints of this {@link ITSPoints}
     */
    Iterable<TimeValuePair> getData();

    /**
     * @return the number of points in this {@link ITSPoints}
     */
    int getSize();

    /**
     * @return the first recorded timestamp in this {@link ITSPoints}
     */
    Double getFirstTimeStamp();

    /**
     * @return the last recorded timestamp in this {@link ITSPoints}
     */
    Double getLastTimeStamp();
}
