/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.trace.indexer.checkpoint;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.common.core.log.TraceCompassLog;
import org.eclipse.tracecompass.common.core.log.TraceCompassLogUtils;
import org.eclipse.tracecompass.internal.tmf.core.Messages;
import org.eclipse.tracecompass.internal.tmf.core.TmfCoreTracer;
import org.eclipse.tracecompass.internal.tmf.core.trace.indexer.TmfMemoryIndex;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.request.ITmfEventRequest;
import org.eclipse.tracecompass.tmf.core.request.TmfEventRequest;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceUpdatedSignal;
import org.eclipse.tracecompass.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimeRange;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestamp;
import org.eclipse.tracecompass.tmf.core.trace.ITmfContext;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTraceKnownSize;
import org.eclipse.tracecompass.tmf.core.trace.indexer.ITmfTraceIndexer;
import org.eclipse.tracecompass.tmf.core.trace.indexer.checkpoint.ITmfCheckpoint;
import org.eclipse.tracecompass.tmf.core.trace.indexer.checkpoint.ITmfCheckpointIndex;
import org.eclipse.tracecompass.tmf.core.trace.indexer.checkpoint.TmfCheckpoint;
import org.eclipse.tracecompass.tmf.core.trace.location.ITmfLocation;

public class TmfCheckpointIndexer
implements ITmfTraceIndexer {
    private static final @NonNull Logger LOGGER = TraceCompassLog.getLogger(TmfCheckpointIndexer.class);
    protected final ITmfTrace fTrace;
    private final int fCheckpointInterval;
    private boolean fIsIndexing;
    protected final ITmfCheckpointIndex fTraceIndex;
    private ITmfEventRequest fIndexingRequest = null;
    private boolean fBuiltOnce;

    public TmfCheckpointIndexer(ITmfTrace trace) {
        this(trace, 50000);
    }

    public TmfCheckpointIndexer(ITmfTrace trace, int interval) {
        this.fTrace = trace;
        this.fCheckpointInterval = interval;
        this.fTraceIndex = this.createIndex(trace);
        this.fIsIndexing = false;
    }

    protected ITmfCheckpointIndex createIndex(ITmfTrace trace) {
        return new TmfMemoryIndex(trace);
    }

    @Override
    public void dispose() {
        if (this.fIndexingRequest != null && !this.fIndexingRequest.isCompleted()) {
            this.fIndexingRequest.cancel();
        }
        this.fTraceIndex.dispose();
    }

    @Override
    public boolean isIndexing() {
        return this.fIsIndexing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void buildIndex(long offset, TmfTimeRange range, boolean waitForCompletion) {
        long indexingOffset = offset;
        TmfTimeRange indexingTimeRange = range;
        ITmfCheckpointIndex iTmfCheckpointIndex = this.fTraceIndex;
        synchronized (iTmfCheckpointIndex) {
            if (this.fIsIndexing) {
                return;
            }
            this.fIsIndexing = true;
        }
        if (!this.fTraceIndex.isCreatedFromScratch() && !this.fBuiltOnce && this.fTraceIndex.getNbEvents() > 0L) {
            indexingOffset = this.fTraceIndex.getNbEvents();
            indexingTimeRange = new TmfTimeRange(this.fTraceIndex.getTimeRange().getStartTime(), TmfTimestamp.BIG_CRUNCH);
            TmfCoreTracer.traceIndexer("restoring index. nbEvents: " + this.fTraceIndex.getNbEvents() + " time range: " + this.fTraceIndex.getTimeRange());
            TmfTraceUpdatedSignal signal = new TmfTraceUpdatedSignal(this, this.fTrace, new TmfTimeRange(this.fTraceIndex.getTimeRange().getStartTime(), this.fTraceIndex.getTimeRange().getEndTime()), indexingOffset);
            this.fTrace.broadcast(signal);
        }
        TmfCoreTracer.traceIndexer("buildIndex. offset: " + indexingOffset + " (requested " + offset + ")" + " time range: " + range);
        final TmfIndexingJob job = new TmfIndexingJob("Indexing " + this.fTrace.getName() + "...");
        job.setSystem(this.fBuiltOnce);
        this.fBuiltOnce = true;
        job.schedule();
        this.fIndexingRequest = new TmfEventRequest(ITmfEvent.class, indexingTimeRange, indexingOffset, Integer.MAX_VALUE, ITmfEventRequest.ExecutionType.BACKGROUND){

            @Override
            public void handleData(ITmfEvent event) {
                super.handleData(event);
                if (this.getNbRead() % TmfCheckpointIndexer.this.fCheckpointInterval == 0) {
                    this.updateTraceStatus();
                }
            }

            @Override
            public void handleSuccess() {
                this.updateTraceStatus();
            }

            @Override
            public void handleCompleted() {
                job.cancel();
                TmfCheckpointIndexer.this.fTraceIndex.setTimeRange(TmfCheckpointIndexer.this.fTrace.getTimeRange());
                TmfCheckpointIndexer.this.fTraceIndex.setNbEvents(TmfCheckpointIndexer.this.fTrace.getNbEvents());
                super.handleCompleted();
                TmfCheckpointIndexer.this.fIsIndexing = false;
                TmfCoreTracer.traceIndexer("Build index request completed. nbEvents: " + TmfCheckpointIndexer.this.fTraceIndex.getNbEvents() + " time range: " + TmfCheckpointIndexer.this.fTraceIndex.getTimeRange());
            }

            @Override
            public void fail(Exception e) {
                super.fail(e);
                job.setException(e);
            }

            private void updateTraceStatus() {
                if (TmfCheckpointIndexer.this.fTrace.getNbEvents() > 0L) {
                    TmfCheckpointIndexer.this.signalNewTimeRange(TmfCheckpointIndexer.this.fTrace.getStartTime(), TmfCheckpointIndexer.this.fTrace.getEndTime());
                }
            }
        };
        this.fTrace.sendRequest(this.fIndexingRequest);
        if (waitForCompletion) {
            try {
                this.fIndexingRequest.waitForCompletion();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private void signalNewTimeRange(@NonNull ITmfTimestamp startTime, @NonNull ITmfTimestamp endTime) {
        this.fTrace.broadcast(new TmfTraceUpdatedSignal(this.fTrace, this.fTrace, new TmfTimeRange(startTime, endTime), this.fTrace.getNbEvents()));
    }

    @Override
    public synchronized void updateIndex(ITmfContext context, ITmfTimestamp timestamp) {
        if (context.getRank() % (long)this.fCheckpointInterval == 0L) {
            long position = context.getRank() / (long)this.fCheckpointInterval;
            if ((long)this.fTraceIndex.size() == position) {
                TmfCheckpoint checkpoint = new TmfCheckpoint(timestamp, context.getLocation(), position);
                TmfCoreTracer.traceIndexer("Inserting checkpoint: " + checkpoint);
                this.fTraceIndex.insert(checkpoint);
            }
        }
    }

    @Override
    public synchronized ITmfContext seekIndex(ITmfTimestamp timestamp) {
        if (timestamp == null) {
            return this.fTrace.seekEvent(0L);
        }
        long index = this.fTraceIndex.binarySearch(new TmfCheckpoint(timestamp, null, 0L));
        index = index < 0L ? Math.max(0L, -(index + 2L)) : Math.max(0L, index - 1L);
        return this.restoreCheckpoint(index);
    }

    @Override
    public ITmfContext seekIndex(long rank) {
        if (rank < 0L) {
            return this.fTrace.seekEvent(0L);
        }
        int index = (int)rank / this.fCheckpointInterval;
        return this.restoreCheckpoint(index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ITmfContext restoreCheckpoint(long checkpointIndex) {
        ITmfLocation location = null;
        long index = 0L;
        ITmfCheckpointIndex iTmfCheckpointIndex = this.fTraceIndex;
        synchronized (iTmfCheckpointIndex) {
            if (!this.fTraceIndex.isEmpty()) {
                index = checkpointIndex;
                if (index >= (long)this.fTraceIndex.size()) {
                    index = this.fTraceIndex.size() - 1;
                }
                ITmfCheckpoint checkpoint = this.fTraceIndex.get(index);
                TmfCoreTracer.traceIndexer("Restored checkpoint: " + checkpoint);
                if (checkpoint == null) {
                    return this.fTrace.seekEvent((ITmfLocation)null);
                }
                location = checkpoint.getLocation();
            }
        }
        ITmfContext context = this.fTrace.seekEvent(location);
        context.setRank(index * (long)this.fCheckpointInterval);
        return context;
    }

    protected ITmfCheckpointIndex getTraceIndex() {
        return this.fTraceIndex;
    }

    private final class TmfIndexingJob
    extends Job {
        private Exception fException;
        private final ITmfTraceKnownSize fTraceWithSize;

        private TmfIndexingJob(String name) {
            super(name);
            this.fException = null;
            this.fTraceWithSize = TmfCheckpointIndexer.this.fTrace instanceof ITmfTraceKnownSize ? (ITmfTraceKnownSize)((Object)TmfCheckpointIndexer.this.fTrace) : null;
        }

        protected IStatus run(IProgressMonitor monitor) {
            int alreadyDone = 0;
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor);
            if (this.fTraceWithSize != null) {
                subMonitor.beginTask("", this.fTraceWithSize.size());
            } else {
                subMonitor.beginTask("", -1);
            }
            while (!monitor.isCanceled()) {
                try {
                    long prevNbEvents = TmfCheckpointIndexer.this.fTrace.getNbEvents();
                    Thread.sleep(250L);
                    long nbEvents = TmfCheckpointIndexer.this.fTrace.getNbEvents();
                    if (this.fTraceWithSize != null) {
                        int done = this.fTraceWithSize.progress();
                        subMonitor.setWorkRemaining(this.fTraceWithSize.size() - done);
                        subMonitor.worked(done - alreadyDone);
                        alreadyDone = done;
                    }
                    this.setName(String.valueOf(Messages.TmfCheckpointIndexer_Indexing) + ' ' + TmfCheckpointIndexer.this.fTrace.getName() + " (" + String.format("%,d", nbEvents) + ")");
                    long rate = (nbEvents - prevNbEvents) * 4L;
                    TraceCompassLogUtils.traceCounter((Logger)LOGGER, (Level)Level.FINE, (String)TmfCheckpointIndexer.this.fTrace.getName(), (Object[])new Object[]{"indexed", nbEvents - prevNbEvents});
                    subMonitor.setTaskName(String.valueOf(String.format("%,d", rate)) + " " + Messages.TmfCheckpointIndexer_EventsPerSecond);
                }
                catch (InterruptedException interruptedException) {
                    return Status.OK_STATUS;
                }
            }
            subMonitor.done();
            monitor.done();
            return this.fException != null ? new Status(4, "org.eclipse.tracecompass.tmf.core", this.fException.getMessage(), (Throwable)this.fException) : Status.OK_STATUS;
        }

        public void setException(Exception e) {
            this.fException = e;
        }
    }
}

