/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.debugging.sourcemap.Util;
import com.google.javascript.jscomp.CodeConsumer;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.JSDocInfoPrinter;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.OutputCharsetEncoder;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.Token;
import com.google.javascript.rhino.TokenStream;
import java.util.HashMap;
import java.util.Map;

class CodeGenerator {
    private static final String LT_ESCAPED = "\\x3c";
    private static final String GT_ESCAPED = "\\x3e";
    private final Map<String, String> escapedJsStrings = new HashMap<String, String>();
    private final CodeConsumer cc;
    private final OutputCharsetEncoder outputCharsetEncoder;
    private final boolean preferSingleQuotes;
    private final boolean preserveTypeAnnotations;
    private final boolean trustedStrings;
    private final CompilerOptions.LanguageMode languageMode;

    private CodeGenerator(CodeConsumer consumer) {
        this.cc = consumer;
        this.outputCharsetEncoder = null;
        this.preferSingleQuotes = false;
        this.trustedStrings = true;
        this.languageMode = CompilerOptions.LanguageMode.ECMASCRIPT5;
        this.preserveTypeAnnotations = false;
    }

    static CodeGenerator forCostEstimation(CodeConsumer consumer) {
        return new CodeGenerator(consumer);
    }

    CodeGenerator(CodeConsumer consumer, CompilerOptions options) {
        this.cc = consumer;
        this.outputCharsetEncoder = new OutputCharsetEncoder(options.getOutputCharset());
        this.preferSingleQuotes = options.preferSingleQuotes;
        this.trustedStrings = options.trustedStrings;
        this.languageMode = options.getLanguageOut();
        this.preserveTypeAnnotations = options.preserveTypeAnnotations;
    }

    public void tagAsStrict() {
        this.add("'use strict';");
    }

    void add(String str) {
        this.cc.add(str);
    }

    private void addIdentifier(String identifier) {
        this.cc.addIdentifier(CodeGenerator.identifierEscape(identifier));
    }

    void add(Node n) {
        this.add(n, Context.OTHER);
    }

    void add(Node n, Context context) {
        if (!this.cc.continueProcessing()) {
            return;
        }
        if (this.preserveTypeAnnotations && n.getJSDocInfo() != null) {
            this.add(JSDocInfoPrinter.print(n.getJSDocInfo()));
        }
        int type = n.getType();
        String opstr = NodeUtil.opToStr(type);
        int childCount = n.getChildCount();
        Node first = n.getFirstChild();
        Node last = n.getLastChild();
        if (opstr != null && first != last) {
            boolean needsParens;
            Preconditions.checkState((childCount == 2 ? 1 : 0) != 0, (String)"Bad binary operator \"%s\": expected 2 arguments but got %s", (Object[])new Object[]{opstr, childCount});
            int p = NodeUtil.precedence(type);
            Context rhsContext = CodeGenerator.getContextForNoInOperator(context);
            boolean bl = needsParens = context == Context.START_OF_EXPR && first.isObjectPattern();
            if (n.isAssign() && needsParens) {
                this.add("(");
            }
            if (NodeUtil.isAssignmentOp(n) && NodeUtil.isAssignmentOp(last)) {
                this.addExpr(first, p, context);
                this.cc.addOp(opstr, true);
                this.addExpr(last, p, rhsContext);
            } else {
                this.unrollBinaryOperator(n, type, opstr, context, rhsContext, p, p + 1);
            }
            if (n.isAssign() && needsParens) {
                this.add(")");
            }
            return;
        }
        this.cc.startSourceMapping(n);
        switch (type) {
            case 77: {
                Preconditions.checkState((first.getNext().isBlock() && !first.getNext().hasMoreThanOneChild() ? 1 : 0) != 0);
                Preconditions.checkState((childCount >= 2 && childCount <= 3 ? 1 : 0) != 0);
                this.add("try");
                this.add(first, Context.PRESERVE_BLOCK);
                Node catchblock = first.getNext().getFirstChild();
                if (catchblock != null) {
                    this.add(catchblock);
                }
                if (childCount != 3) break;
                this.cc.maybeInsertSpace();
                this.add("finally");
                this.add(last, Context.PRESERVE_BLOCK);
                break;
            }
            case 120: {
                Preconditions.checkState((childCount == 2 ? 1 : 0) != 0);
                this.cc.maybeInsertSpace();
                this.add("catch");
                this.cc.maybeInsertSpace();
                this.add("(");
                this.add(first);
                this.add(")");
                this.add(last, Context.PRESERVE_BLOCK);
                break;
            }
            case 49: {
                Preconditions.checkState((childCount == 1 ? 1 : 0) != 0);
                this.add("throw");
                this.cc.maybeInsertSpace();
                this.add(first);
                this.cc.endStatement(true);
                break;
            }
            case 4: {
                this.add("return");
                if (childCount == 1) {
                    this.cc.maybeInsertSpace();
                    this.add(first);
                } else {
                    Preconditions.checkState((childCount == 0 ? 1 : 0) != 0);
                }
                this.cc.endStatement();
                break;
            }
            case 118: {
                if (first == null) break;
                this.add("var ");
                this.addList(first, false, CodeGenerator.getContextForNoInOperator(context), ",");
                break;
            }
            case 149: {
                this.add("const ");
                this.addList(first, false, CodeGenerator.getContextForNoInOperator(context), ",");
                break;
            }
            case 162: {
                this.add("let ");
                this.addList(first, false, CodeGenerator.getContextForNoInOperator(context), ",");
                break;
            }
            case 153: {
                Preconditions.checkState((!n.getString().isEmpty() ? 1 : 0) != 0);
                this.addIdentifier(n.getString());
                break;
            }
            case 38: {
                this.addIdentifier(n.getString());
                this.maybeAddOptional(n);
                this.maybeAddTypeDecl(n);
                if (first == null || first.isEmpty()) break;
                Preconditions.checkState((childCount == 1 ? 1 : 0) != 0);
                this.cc.addOp("=", true);
                if (first.isComma()) {
                    this.addExpr(first, NodeUtil.precedence(86), Context.OTHER);
                    break;
                }
                this.addExpr(first, 0, CodeGenerator.getContextForNoInOperator(context));
                break;
            }
            case 63: {
                this.add("[");
                this.addArrayList(first);
                this.add("]");
                break;
            }
            case 156: {
                this.addArrayPattern(n);
                this.maybeAddTypeDecl(n);
                break;
            }
            case 83: {
                this.add("(");
                this.addList(first);
                this.add(")");
                break;
            }
            case 179: {
                this.add(first);
                this.maybeAddTypeDecl(n);
                this.cc.addOp("=", true);
                this.add(first.getNext());
                break;
            }
            case 85: {
                Preconditions.checkState((childCount == 2 ? 1 : 0) != 0);
                this.unrollBinaryOperator(n, 85, ",", context, CodeGenerator.getContextForNoInOperator(context), 0, 0);
                break;
            }
            case 39: {
                Preconditions.checkState((childCount == 0 ? 1 : 0) != 0);
                this.cc.addNumber(n.getDouble());
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 32: 
            case 122: {
                Preconditions.checkState((childCount == 1 ? 1 : 0) != 0);
                this.cc.addOp(NodeUtil.opToStrNoFail(type), false);
                this.addExpr(first, NodeUtil.precedence(type), Context.OTHER);
                break;
            }
            case 29: {
                Preconditions.checkState((childCount == 1 ? 1 : 0) != 0);
                if (n.getFirstChild().isNumber()) {
                    this.cc.addNumber(-n.getFirstChild().getDouble());
                    break;
                }
                this.cc.addOp(NodeUtil.opToStrNoFail(type), false);
                this.addExpr(first, NodeUtil.precedence(type), Context.OTHER);
                break;
            }
            case 98: {
                Preconditions.checkState((childCount == 3 ? 1 : 0) != 0);
                int p = NodeUtil.precedence(type);
                Context rhsContext = CodeGenerator.getContextForNoInOperator(context);
                this.addExpr(first, p + 1, context);
                this.cc.addOp("?", true);
                this.addExpr(first.getNext(), 1, rhsContext);
                this.cc.addOp(":", true);
                this.addExpr(last, 1, rhsContext);
                break;
            }
            case 47: {
                if (!first.isString() || !last.isString()) {
                    throw new Error("Expected children to be strings");
                }
                String regexp = this.regexpEscape(first.getString(), this.outputCharsetEncoder);
                if (childCount == 2) {
                    this.add(regexp + last.getString());
                    break;
                }
                Preconditions.checkState((childCount == 1 ? 1 : 0) != 0);
                this.add(regexp);
                break;
            }
            case 105: {
                if (n.getClass() != Node.class) {
                    throw new Error("Unexpected Node subclass.");
                }
                Preconditions.checkState((childCount == 3 ? 1 : 0) != 0);
                if (n.isArrowFunction()) {
                    this.addArrowFunction(n, first, last, context);
                    break;
                }
                this.addFunction(n, first, last, context);
                break;
            }
            case 173: {
                this.add("...");
                this.add(first.getString());
                this.maybeAddTypeDecl(n);
                break;
            }
            case 174: {
                this.add("...");
                this.add(n.getFirstChild());
                break;
            }
            case 169: {
                this.add("export");
                if (n.getBooleanProp(62)) {
                    this.add("default");
                }
                if (n.getBooleanProp(63)) {
                    this.add("*");
                    Preconditions.checkState((first != null && first.isEmpty() ? 1 : 0) != 0);
                } else {
                    this.add(first);
                }
                if (childCount == 2) {
                    this.add("from");
                    this.add(last);
                }
                this.processEnd(first, context);
                break;
            }
            case 165: {
                this.add("import");
                Node second = first.getNext();
                if (!first.isEmpty()) {
                    this.add(first);
                    if (!second.isEmpty()) {
                        this.cc.listSeparator();
                    }
                }
                if (!second.isEmpty()) {
                    this.add(second);
                }
                if (!first.isEmpty() || !second.isEmpty()) {
                    this.add("from");
                }
                this.add(last);
                this.cc.endStatement();
                break;
            }
            case 166: 
            case 170: {
                this.add("{");
                for (Node c = first; c != null; c = c.getNext()) {
                    if (c != first) {
                        this.cc.listSeparator();
                    }
                    this.add(c);
                }
                this.add("}");
                break;
            }
            case 167: 
            case 171: {
                this.add(first);
                if (first == last) break;
                this.add("as");
                this.add(last);
                break;
            }
            case 168: {
                this.add("*");
                this.add("as");
                this.add(n.getString());
                break;
            }
            case 158: {
                Node interfaces;
                boolean classNeedsParens;
                Preconditions.checkState((childCount == 3 ? 1 : 0) != 0);
                boolean bl = classNeedsParens = context == Context.START_OF_EXPR;
                if (classNeedsParens) {
                    this.add("(");
                }
                Node name = first;
                Node superClass = first.getNext();
                Node members = last;
                this.add("class");
                if (!name.isEmpty()) {
                    this.add(name);
                }
                this.maybeAddGenericTypes(first);
                if (!superClass.isEmpty()) {
                    this.add("extends");
                    this.add(superClass);
                }
                if ((interfaces = (Node)n.getProp(82)) != null) {
                    this.add("implements");
                    Node child = interfaces.getFirstChild();
                    this.add(child);
                    while ((child = child.getNext()) != null) {
                        this.add(",");
                        this.cc.maybeInsertSpace();
                        this.add(child);
                    }
                }
                this.add(members);
                this.cc.endClass(context == Context.STATEMENT);
                if (!classNeedsParens) break;
                this.add(")");
                break;
            }
            case 159: 
            case 313: 
            case 322: {
                this.cc.beginBlock();
                for (Node c = first; c != null; c = c.getNext()) {
                    this.add(c);
                    this.processEnd(c, context);
                    this.cc.endLine();
                }
                this.cc.endBlock(false);
                break;
            }
            case 315: {
                this.cc.beginBlock();
                for (Node c = first; c != null; c = c.getNext()) {
                    this.add(c);
                    if (c.getNext() != null) {
                        this.add(",");
                    }
                    this.cc.endLine();
                }
                this.cc.endBlock(false);
                break;
            }
            case 147: 
            case 148: 
            case 160: 
            case 319: {
                n.getParent().toStringTree();
                Preconditions.checkState((n.getParent().isObjectLit() || n.getParent().isClassMembers() || n.getParent().isInterfaceMembers() || n.getParent().isRecordType() || n.getParent().isIndexSignature() ? 1 : 0) != 0);
                this.maybeAddAccessibilityModifier(n);
                if (n.isStaticMember()) {
                    this.add("static ");
                }
                if (!n.isMemberVariableDef() && n.getFirstChild().isGeneratorFunction()) {
                    Preconditions.checkState((type == 160 ? 1 : 0) != 0);
                    this.add("*");
                }
                switch (type) {
                    case 147: {
                        Preconditions.checkState((!first.getSecondChild().hasChildren() ? 1 : 0) != 0);
                        this.add("get ");
                        break;
                    }
                    case 148: {
                        Preconditions.checkState((boolean)first.getSecondChild().hasOneChild());
                        this.add("set ");
                        break;
                    }
                }
                String name = n.getString();
                if (n.isMemberVariableDef()) {
                    this.add(n.getString());
                    this.maybeAddOptional(n);
                    this.maybeAddTypeDecl(n);
                    break;
                }
                Preconditions.checkState((childCount == 1 ? 1 : 0) != 0);
                Preconditions.checkState((boolean)first.isFunction());
                Preconditions.checkState((boolean)first.getFirstChild().getString().isEmpty());
                Node fn = first;
                Node parameters = fn.getSecondChild();
                Node body = fn.getLastChild();
                if (!n.isQuotedString() && TokenStream.isJSIdentifier(name) && NodeUtil.isLatin(name)) {
                    this.add(name);
                    this.maybeAddGenericTypes(fn.getFirstChild());
                } else {
                    double d = CodeGenerator.getSimpleNumber(name);
                    if (!Double.isNaN(d)) {
                        this.cc.addNumber(d);
                    } else {
                        this.addJsString(n);
                    }
                }
                this.maybeAddOptional(fn);
                this.add(parameters);
                this.maybeAddTypeDecl(fn);
                this.add(body, Context.PRESERVE_BLOCK);
                break;
            }
            case 125: 
            case 132: {
                boolean preserveBlock;
                if (n.getClass() != Node.class) {
                    throw new Error("Unexpected Node subclass.");
                }
                boolean bl = preserveBlock = context == Context.PRESERVE_BLOCK;
                if (preserveBlock) {
                    this.cc.beginBlock();
                }
                boolean preferLineBreaks = type == 132 || type == 125 && !preserveBlock && n.getParent() != null && n.getParent().isScript();
                for (Node c = first; c != null; c = c.getNext()) {
                    this.add(c, Context.STATEMENT);
                    if (NodeUtil.isNameDeclaration(c)) {
                        this.cc.endStatement();
                    }
                    if (c.isFunction() || c.isClass()) {
                        this.cc.maybeLineBreak();
                    }
                    if (!preferLineBreaks) continue;
                    this.cc.notePreferredLineBreak();
                }
                if (!preserveBlock) break;
                this.cc.endBlock(this.cc.breakAfterBlockFor(n, context == Context.STATEMENT));
                break;
            }
            case 115: {
                if (childCount == 4) {
                    this.add("for");
                    this.cc.maybeInsertSpace();
                    this.add("(");
                    if (NodeUtil.isNameDeclaration(first)) {
                        this.add(first, Context.IN_FOR_INIT_CLAUSE);
                    } else {
                        this.addExpr(first, 0, Context.IN_FOR_INIT_CLAUSE);
                    }
                    this.add(";");
                    this.add(first.getNext());
                    this.add(";");
                    this.add(first.getNext().getNext());
                    this.add(")");
                    this.addNonEmptyStatement(last, CodeGenerator.getContextForNonEmptyExpression(context), false);
                    break;
                }
                Preconditions.checkState((childCount == 3 ? 1 : 0) != 0);
                this.add("for");
                this.cc.maybeInsertSpace();
                this.add("(");
                this.add(first);
                this.add("in");
                this.add(first.getNext());
                this.add(")");
                this.addNonEmptyStatement(last, CodeGenerator.getContextForNonEmptyExpression(context), false);
                break;
            }
            case 163: {
                Preconditions.checkState((childCount == 3 ? 1 : 0) != 0);
                this.add("for");
                this.cc.maybeInsertSpace();
                this.add("(");
                this.add(first);
                this.add("of");
                this.add(first.getNext());
                this.add(")");
                this.addNonEmptyStatement(last, CodeGenerator.getContextForNonEmptyExpression(context), false);
                break;
            }
            case 114: {
                Preconditions.checkState((childCount == 2 ? 1 : 0) != 0);
                this.add("do");
                this.addNonEmptyStatement(first, Context.OTHER, false);
                this.cc.maybeInsertSpace();
                this.add("while");
                this.cc.maybeInsertSpace();
                this.add("(");
                this.add(last);
                this.add(")");
                this.cc.endStatement();
                break;
            }
            case 113: {
                Preconditions.checkState((childCount == 2 ? 1 : 0) != 0);
                this.add("while");
                this.cc.maybeInsertSpace();
                this.add("(");
                this.add(first);
                this.add(")");
                this.addNonEmptyStatement(last, CodeGenerator.getContextForNonEmptyExpression(context), false);
                break;
            }
            case 124: {
                Preconditions.checkState((childCount == 0 ? 1 : 0) != 0);
                break;
            }
            case 33: {
                Preconditions.checkState((childCount == 2 ? 1 : 0) != 0, (String)"Bad GETPROP: expected 2 children, but got %s", (Object[])new Object[]{childCount});
                Preconditions.checkState((boolean)last.isString(), (Object)"Bad GETPROP: RHS should be STRING");
                boolean needsParens = first.isNumber();
                if (needsParens) {
                    this.add("(");
                }
                this.addExpr(first, NodeUtil.precedence(type), context);
                if (needsParens) {
                    this.add(")");
                }
                if (this.languageMode == CompilerOptions.LanguageMode.ECMASCRIPT3 && TokenStream.isKeyword(last.getString())) {
                    this.add("[");
                    this.add(last);
                    this.add("]");
                    break;
                }
                this.add(".");
                this.addIdentifier(last.getString());
                break;
            }
            case 35: {
                Preconditions.checkState((childCount == 2 ? 1 : 0) != 0, (String)"Bad GETELEM node: Expected 2 children but got %s. For node: %s", (Object[])new Object[]{childCount, n});
                this.addExpr(first, NodeUtil.precedence(type), context);
                this.add("[");
                this.add(first.getNext());
                this.add("]");
                break;
            }
            case 119: {
                Preconditions.checkState((childCount == 2 ? 1 : 0) != 0);
                this.add("with(");
                this.add(first);
                this.add(")");
                this.addNonEmptyStatement(last, CodeGenerator.getContextForNonEmptyExpression(context), false);
                break;
            }
            case 102: 
            case 103: {
                Preconditions.checkState((childCount == 1 ? 1 : 0) != 0);
                String o = type == 102 ? "++" : "--";
                boolean postProp = n.getBooleanProp(32);
                if (postProp) {
                    this.addExpr(first, NodeUtil.precedence(type), context);
                    this.cc.addOp(o, false);
                    break;
                }
                this.cc.addOp(o, false);
                this.add(first);
                break;
            }
            case 37: {
                if (CodeGenerator.isIndirectEval(first) || n.getBooleanProp(50) && NodeUtil.isGet(first)) {
                    this.add("(0,");
                    this.addExpr(first, NodeUtil.precedence(85), Context.OTHER);
                    this.add(")");
                } else {
                    this.addExpr(first, NodeUtil.precedence(type), context);
                }
                Node args = first.getNext();
                this.add("(");
                this.addList(args);
                this.add(")");
                break;
            }
            case 108: {
                boolean ambiguousElseClause;
                boolean hasElse = childCount == 3;
                boolean bl = ambiguousElseClause = context == Context.BEFORE_DANGLING_ELSE && !hasElse;
                if (ambiguousElseClause) {
                    this.cc.beginBlock();
                }
                this.add("if");
                this.cc.maybeInsertSpace();
                this.add("(");
                this.add(first);
                this.add(")");
                if (childCount == 1) break;
                if (hasElse) {
                    this.addNonEmptyStatement(first.getNext(), Context.BEFORE_DANGLING_ELSE, false);
                    this.cc.maybeInsertSpace();
                    this.add("else");
                    this.addNonEmptyStatement(last, CodeGenerator.getContextForNonEmptyExpression(context), false);
                } else {
                    this.addNonEmptyStatement(first.getNext(), Context.OTHER, false);
                    Preconditions.checkState((childCount == 2 ? 1 : 0) != 0);
                }
                if (!ambiguousElseClause) break;
                this.cc.endBlock();
                break;
            }
            case 41: {
                Preconditions.checkState((childCount == 0 ? 1 : 0) != 0);
                this.cc.addConstant("null");
                break;
            }
            case 42: {
                Preconditions.checkState((childCount == 0 ? 1 : 0) != 0);
                this.add("this");
                break;
            }
            case 161: {
                Preconditions.checkState((childCount == 0 ? 1 : 0) != 0);
                this.add("super");
                break;
            }
            case 164: {
                this.add("yield");
                if (n.isYieldFor()) {
                    Preconditions.checkNotNull((Object)first);
                    this.add("*");
                }
                if (first == null) break;
                this.cc.maybeInsertSpace();
                this.addExpr(first, NodeUtil.precedence(type), Context.OTHER);
                break;
            }
            case 43: {
                Preconditions.checkState((childCount == 0 ? 1 : 0) != 0);
                this.cc.addConstant("false");
                break;
            }
            case 44: {
                Preconditions.checkState((childCount == 0 ? 1 : 0) != 0);
                this.cc.addConstant("true");
                break;
            }
            case 117: {
                Preconditions.checkState((childCount <= 1 ? 1 : 0) != 0);
                this.add("continue");
                if (childCount == 1) {
                    if (!first.isLabelName()) {
                        throw new Error("Unexpected token type. Should be LABEL_NAME.");
                    }
                    this.add(" ");
                    this.add(first);
                }
                this.cc.endStatement();
                break;
            }
            case 152: {
                Preconditions.checkState((childCount == 0 ? 1 : 0) != 0);
                this.add("debugger");
                this.cc.endStatement();
                break;
            }
            case 116: {
                Preconditions.checkState((childCount <= 1 ? 1 : 0) != 0);
                this.add("break");
                if (childCount == 1) {
                    if (!first.isLabelName()) {
                        throw new Error("Unexpected token type. Should be LABEL_NAME.");
                    }
                    this.add(" ");
                    this.add(first);
                }
                this.cc.endStatement();
                break;
            }
            case 130: {
                Preconditions.checkState((childCount == 1 ? 1 : 0) != 0);
                this.add(first, Context.START_OF_EXPR);
                this.cc.endStatement();
                break;
            }
            case 30: {
                this.add("new ");
                int precedence = NodeUtil.precedence(type);
                if (NodeUtil.containsType(first, 37, NodeUtil.MATCH_NOT_FUNCTION)) {
                    precedence = NodeUtil.precedence(first.getType()) + 1;
                }
                this.addExpr(first, precedence, Context.OTHER);
                Node next = first.getNext();
                if (next == null) break;
                this.add("(");
                this.addList(next);
                this.add(")");
                break;
            }
            case 154: {
                this.addStringKey(n);
                break;
            }
            case 40: {
                Preconditions.checkState((childCount == 0 ? 1 : 0) != 0, (Object)"A string may not have children");
                this.addJsString(n);
                break;
            }
            case 31: {
                Preconditions.checkState((childCount == 1 ? 1 : 0) != 0);
                this.add("delete ");
                this.add(first);
                break;
            }
            case 64: {
                boolean needsParens;
                boolean bl = needsParens = context == Context.START_OF_EXPR;
                if (needsParens) {
                    this.add("(");
                }
                this.add("{");
                for (Node c = first; c != null; c = c.getNext()) {
                    if (c != first) {
                        this.cc.listSeparator();
                    }
                    Preconditions.checkState((c.isComputedProp() || c.isGetterDef() || c.isSetterDef() || c.isStringKey() || c.isMemberFunctionDef() ? 1 : 0) != 0);
                    this.add(c);
                }
                this.add("}");
                if (!needsParens) break;
                this.add(")");
                break;
            }
            case 175: {
                this.maybeAddAccessibilityModifier(n);
                if (n.getBooleanProp(58)) {
                    this.add("static ");
                }
                if (n.getBooleanProp(73)) {
                    this.add("get ");
                } else if (n.getBooleanProp(74)) {
                    this.add("set ");
                } else if (last.getBooleanProp(59)) {
                    this.add("*");
                }
                this.add("[");
                this.add(first);
                this.add("]");
                this.maybeAddTypeDecl(n);
                if (n.getBooleanProp(72) || n.getBooleanProp(73) || n.getBooleanProp(74)) {
                    Node function = first.getNext();
                    Node params = function.getSecondChild();
                    Node body = function.getLastChild();
                    this.add(params);
                    this.add(body, Context.PRESERVE_BLOCK);
                    break;
                }
                boolean isInClass = n.getParent().getType() == 159;
                Node initializer = first.getNext();
                if (initializer != null) {
                    Preconditions.checkState((!isInClass ? 1 : 0) != 0, (Object)"initializers should only exist in object literals, not classes");
                    this.cc.addOp(":", false);
                    this.add(initializer);
                    break;
                }
                Preconditions.checkState((boolean)n.getBooleanProp(75), (Object)n);
                break;
            }
            case 157: {
                this.addObjectPattern(n);
                this.maybeAddTypeDecl(n);
                break;
            }
            case 110: {
                this.add("switch(");
                this.add(first);
                this.add(")");
                this.cc.beginBlock();
                this.addAllSiblings(first.getNext());
                this.cc.endBlock(context == Context.STATEMENT);
                break;
            }
            case 111: {
                Preconditions.checkState((childCount == 2 ? 1 : 0) != 0);
                this.add("case ");
                this.add(first);
                this.addCaseBody(last);
                break;
            }
            case 112: {
                Preconditions.checkState((childCount == 1 ? 1 : 0) != 0);
                this.add("default");
                this.addCaseBody(first);
                break;
            }
            case 126: {
                Preconditions.checkState((childCount == 2 ? 1 : 0) != 0);
                if (!first.isLabelName()) {
                    throw new Error("Unexpected token type. Should be LABEL_NAME.");
                }
                this.add(first);
                this.add(":");
                if (!last.isBlock()) {
                    this.cc.maybeInsertSpace();
                }
                this.addNonEmptyStatement(last, CodeGenerator.getContextForNonEmptyExpression(context), true);
                break;
            }
            case 155: {
                this.add("(");
                this.add(first);
                this.add(")");
                break;
            }
            case 176: {
                this.add(first, Context.START_OF_EXPR);
                this.add(first.getNext());
                break;
            }
            case 177: {
                this.add("`");
                for (Node c = first; c != null; c = c.getNext()) {
                    if (c.isString()) {
                        this.add(c.getString());
                        continue;
                    }
                    this.cc.append("${");
                    this.add(c.getFirstChild(), Context.START_OF_EXPR);
                    this.add("}");
                }
                this.add("`");
                break;
            }
            case 200: {
                this.add("string");
                break;
            }
            case 201: {
                this.add("boolean");
                break;
            }
            case 202: {
                this.add("number");
                break;
            }
            case 206: {
                this.add("any");
                break;
            }
            case 209: {
                this.add("void");
                break;
            }
            case 211: {
                this.add(first);
                break;
            }
            case 215: {
                this.addExpr(first, NodeUtil.precedence(215), context);
                this.add("[]");
                break;
            }
            case 203: {
                Node returnType = first;
                this.add("(");
                this.addList(first.getNext());
                this.add(")");
                this.cc.addOp("=>", true);
                this.add(returnType);
                break;
            }
            case 205: {
                this.addList(first, "|");
                break;
            }
            case 213: {
                this.add("{");
                this.addList(first, false, Context.OTHER, ",");
                this.add("}");
                break;
            }
            case 204: {
                this.add(first);
                this.add("<");
                this.addList(first.getNext());
                this.add(">");
                break;
            }
            case 217: {
                this.add("<");
                this.addList(first, false, Context.STATEMENT, ",");
                this.add(">");
                break;
            }
            case 216: {
                this.addIdentifier(n.getString());
                if (!n.hasChildren()) break;
                this.add("extends");
                this.cc.maybeInsertSpace();
                this.add(n.getFirstChild());
                break;
            }
            case 311: {
                Preconditions.checkState((childCount == 3 ? 1 : 0) != 0);
                Node name = first;
                Node superTypes = first.getNext();
                Node members = last;
                this.add("interface");
                this.add(name);
                this.maybeAddGenericTypes(name);
                if (!superTypes.isEmpty()) {
                    this.add("extends");
                    Node superType = superTypes.getFirstChild();
                    this.add(superType);
                    while ((superType = superType.getNext()) != null) {
                        this.add(",");
                        this.cc.maybeInsertSpace();
                        this.add(superType);
                    }
                }
                this.add(members);
                break;
            }
            case 314: {
                Preconditions.checkState((childCount == 2 ? 1 : 0) != 0);
                Node name = first;
                Node members = last;
                this.add("enum");
                this.add(name);
                this.add(members);
                break;
            }
            case 172: {
                Preconditions.checkState((childCount == 2 ? 1 : 0) != 0);
                Node name = first;
                Node elements = last;
                this.add("namespace");
                this.add(name);
                this.add(elements);
                break;
            }
            case 317: {
                this.add("type");
                this.add(n.getString());
                this.cc.addOp("=", true);
                this.add(last);
                this.cc.endStatement(true);
                break;
            }
            case 318: {
                this.add("declare");
                this.add(first);
                this.processEnd(n, context);
                break;
            }
            case 320: {
                this.add("[");
                this.add(first);
                this.add("]");
                this.maybeAddTypeDecl(n);
                this.cc.endStatement(true);
                break;
            }
            case 321: {
                if (n.getBooleanProp(83)) {
                    this.add("new ");
                }
                this.maybeAddGenericTypes(n);
                this.add(first);
                this.maybeAddTypeDecl(n);
                this.cc.endStatement(true);
                break;
            }
            default: {
                throw new RuntimeException("Unknown type " + Token.name(type) + "\n" + n.toStringTree());
            }
        }
        this.cc.endSourceMapping(n);
    }

    private boolean arrowFunctionNeedsParens(Node parent, Context context) {
        if (parent == null) {
            return false;
        }
        switch (parent.getType()) {
            case 85: 
            case 130: {
                return false;
            }
        }
        return context == Context.START_OF_EXPR;
    }

    private void addArrowFunction(Node n, Node first, Node last, Context context) {
        Preconditions.checkState((boolean)first.getString().isEmpty());
        boolean funcNeedsParens = this.arrowFunctionNeedsParens(n.getParent(), context);
        if (funcNeedsParens) {
            this.add("(");
        }
        this.maybeAddGenericTypes(first);
        this.add(first.getNext());
        this.maybeAddTypeDecl(n);
        this.cc.addOp("=>", true);
        if (last.isBlock()) {
            this.add(last, Context.PRESERVE_BLOCK);
        } else {
            this.addExpr(last, NodeUtil.precedence(85) + 1, Context.PRESERVE_BLOCK);
        }
        this.cc.endFunction(context == Context.STATEMENT);
        if (funcNeedsParens) {
            this.add(")");
        }
    }

    private void addFunction(Node n, Node first, Node last, Context context) {
        boolean funcNeedsParens;
        boolean bl = funcNeedsParens = context == Context.START_OF_EXPR;
        if (funcNeedsParens) {
            this.add("(");
        }
        this.add("function");
        if (n.isGeneratorFunction()) {
            this.add("*");
            if (!first.getString().isEmpty()) {
                this.cc.maybeInsertSpace();
            }
        }
        this.add(first);
        this.maybeAddGenericTypes(first);
        this.add(first.getNext());
        this.maybeAddTypeDecl(n);
        this.add(last, Context.PRESERVE_BLOCK);
        this.cc.endFunction(context == Context.STATEMENT);
        if (funcNeedsParens) {
            this.add(")");
        }
    }

    private void maybeAddAccessibilityModifier(Node n) {
        JSDocInfo.Visibility access = (JSDocInfo.Visibility)((Object)n.getProp(84));
        if (access != null) {
            this.add(access.toString().toLowerCase() + " ");
        }
    }

    private void maybeAddTypeDecl(Node n) {
        if (n.getDeclaredTypeExpression() != null) {
            this.add(":");
            this.cc.maybeInsertSpace();
            this.add(n.getDeclaredTypeExpression());
        }
    }

    private void maybeAddGenericTypes(Node n) {
        Node generics = (Node)n.getProp(81);
        if (generics != null) {
            this.add(generics);
        }
    }

    private void maybeAddOptional(Node n) {
        if (n.getBooleanProp(80)) {
            this.add("?");
        }
    }

    private void unrollBinaryOperator(Node n, int op, String opStr, Context context, Context rhsContext, int leftPrecedence, int rightPrecedence) {
        Node firstNonOperator = n.getFirstChild();
        while (firstNonOperator.getType() == op) {
            firstNonOperator = firstNonOperator.getFirstChild();
        }
        this.addExpr(firstNonOperator, leftPrecedence, context);
        Node current = firstNonOperator;
        do {
            current = current.getParent();
            this.cc.addOp(opStr, true);
            this.addExpr(current.getSecondChild(), rightPrecedence, rhsContext);
        } while (current != n);
    }

    static boolean isSimpleNumber(String s) {
        int len = s.length();
        if (len == 0) {
            return false;
        }
        for (int index = 0; index < len; ++index) {
            char c = s.charAt(index);
            if (c >= '0' && c <= '9') continue;
            return false;
        }
        return len == 1 || s.charAt(0) != '0';
    }

    static double getSimpleNumber(String s) {
        if (CodeGenerator.isSimpleNumber(s)) {
            try {
                long l = Long.parseLong(s);
                if (l < 0x20000000000000L) {
                    return l;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return Double.NaN;
    }

    private static boolean isIndirectEval(Node n) {
        return n.isName() && "eval".equals(n.getString()) && !n.getBooleanProp(49);
    }

    private void addNonEmptyStatement(Node n, Context context, boolean allowNonBlockChild) {
        Node nodeToProcess = n;
        if (!allowNonBlockChild && !n.isBlock()) {
            throw new Error("Missing BLOCK child.");
        }
        if (n.isBlock()) {
            int count = CodeGenerator.getNonEmptyChildCount(n, 2);
            if (count == 0) {
                if (this.cc.shouldPreserveExtraBlocks()) {
                    this.cc.beginBlock();
                    this.cc.endBlock(this.cc.breakAfterBlockFor(n, context == Context.STATEMENT));
                } else {
                    this.cc.endStatement(true);
                }
                return;
            }
            if (count == 1) {
                Node firstAndOnlyChild = CodeGenerator.getFirstNonEmptyChild(n);
                boolean alwaysWrapInBlock = this.cc.shouldPreserveExtraBlocks();
                if (alwaysWrapInBlock || CodeGenerator.isBlockDeclOrDo(firstAndOnlyChild)) {
                    this.cc.beginBlock();
                    this.add(firstAndOnlyChild, Context.STATEMENT);
                    this.cc.maybeLineBreak();
                    this.cc.endBlock(this.cc.breakAfterBlockFor(n, context == Context.STATEMENT));
                    return;
                }
                nodeToProcess = firstAndOnlyChild;
            }
            if (count > 1) {
                context = Context.PRESERVE_BLOCK;
            }
        }
        if (nodeToProcess.isEmpty()) {
            this.cc.endStatement(true);
        } else {
            this.add(nodeToProcess, context);
            if (nodeToProcess.isVar()) {
                this.cc.endStatement();
            }
        }
    }

    private static boolean isBlockDeclOrDo(Node n) {
        if (n.isLabel()) {
            Node labeledStatement = n.getLastChild();
            if (!labeledStatement.isBlock()) {
                return CodeGenerator.isBlockDeclOrDo(labeledStatement);
            }
            if (CodeGenerator.getNonEmptyChildCount(n, 2) == 1) {
                return CodeGenerator.isBlockDeclOrDo(CodeGenerator.getFirstNonEmptyChild(n));
            }
            return false;
        }
        switch (n.getType()) {
            case 105: 
            case 114: 
            case 149: 
            case 158: 
            case 162: {
                return true;
            }
        }
        return false;
    }

    private void addExpr(Node n, int minPrecedence, Context context) {
        if (NodeUtil.precedence(n.getType()) < minPrecedence || context == Context.IN_FOR_INIT_CLAUSE && n.isIn()) {
            this.add("(");
            this.add(n, Context.OTHER);
            this.add(")");
        } else {
            this.add(n, context);
        }
    }

    void addList(Node firstInList) {
        this.addList(firstInList, true, Context.OTHER, ",");
    }

    void addList(Node firstInList, String separator) {
        this.addList(firstInList, true, Context.OTHER, separator);
    }

    void addList(Node firstInList, boolean isArrayOrFunctionArgument, Context lhsContext, String separator) {
        for (Node n = firstInList; n != null; n = n.getNext()) {
            boolean isFirst;
            boolean bl = isFirst = n == firstInList;
            if (isFirst) {
                this.addExpr(n, isArrayOrFunctionArgument ? 1 : 0, lhsContext);
                continue;
            }
            this.cc.addOp(separator, true);
            this.addExpr(n, isArrayOrFunctionArgument ? 1 : 0, CodeGenerator.getContextForNoInOperator(lhsContext));
        }
    }

    void addStringKey(Node n) {
        String key = n.getString();
        if (!n.isQuotedString() && (this.languageMode != CompilerOptions.LanguageMode.ECMASCRIPT3 || !TokenStream.isKeyword(key)) && TokenStream.isJSIdentifier(key) && NodeUtil.isLatin(key)) {
            this.add(key);
        } else {
            double d = CodeGenerator.getSimpleNumber(key);
            if (!Double.isNaN(d)) {
                this.cc.addNumber(d);
            } else {
                this.addJsString(n);
            }
        }
        if (n.hasChildren()) {
            this.add(":");
            this.addExpr(n.getFirstChild(), 1, Context.OTHER);
        }
    }

    private boolean isPatternInitializer(Node n) {
        Node parent = n.getParent();
        Preconditions.checkState((boolean)parent.isDestructuringPattern());
        if (n != parent.getLastChild()) {
            return false;
        }
        Node decl = parent.getParent();
        if (!NodeUtil.isNameDeclaration(decl)) {
            return false;
        }
        return !NodeUtil.isEnhancedFor(decl.getParent()) || decl != decl.getParent().getFirstChild();
    }

    void addArrayPattern(Node n) {
        boolean hasInitializer = false;
        this.add("[");
        for (Node child = n.getFirstChild(); child != null; child = child.getNext()) {
            if (this.isPatternInitializer(child)) {
                hasInitializer = true;
                this.add("]");
                this.add("=");
            } else if (child != n.getFirstChild()) {
                this.add(",");
            }
            this.add(child);
        }
        if (!hasInitializer) {
            this.add("]");
        }
    }

    void addObjectPattern(Node n) {
        boolean hasInitializer = false;
        this.add("{");
        for (Node child = n.getFirstChild(); child != null; child = child.getNext()) {
            if (this.isPatternInitializer(child)) {
                hasInitializer = true;
                this.add("}");
                this.add("=");
            } else if (child != n.getFirstChild()) {
                this.add(",");
            }
            this.add(child);
        }
        if (!hasInitializer) {
            this.add("}");
        }
    }

    void addArrayList(Node firstInList) {
        boolean lastWasEmpty = false;
        for (Node n = firstInList; n != null; n = n.getNext()) {
            if (n != firstInList) {
                this.cc.listSeparator();
            }
            this.addExpr(n, 1, Context.OTHER);
            lastWasEmpty = n.isEmpty();
        }
        if (lastWasEmpty) {
            this.cc.listSeparator();
        }
    }

    void addCaseBody(Node caseBody) {
        this.cc.beginCaseBody();
        this.add(caseBody);
        this.cc.endCaseBody();
    }

    void addAllSiblings(Node n) {
        for (Node c = n; c != null; c = c.getNext()) {
            this.add(c);
        }
    }

    private void addJsString(Node n) {
        String s = n.getString();
        boolean useSlashV = n.getBooleanProp(54);
        if (useSlashV) {
            this.add(this.jsString(n.getString(), useSlashV));
        } else {
            String cached = this.escapedJsStrings.get(s);
            if (cached == null) {
                cached = this.jsString(n.getString(), useSlashV);
                this.escapedJsStrings.put(s, cached);
            }
            this.add(cached);
        }
    }

    private String jsString(String s, boolean useSlashV) {
        String singlequote;
        String doublequote;
        char quote;
        int singleq = 0;
        int doubleq = 0;
        block4: for (int i = 0; i < s.length(); ++i) {
            switch (s.charAt(i)) {
                case '\"': {
                    ++doubleq;
                    continue block4;
                }
                case '\'': {
                    ++singleq;
                }
            }
        }
        if (this.preferSingleQuotes ? singleq <= doubleq : singleq < doubleq) {
            quote = '\'';
            doublequote = "\"";
            singlequote = "\\'";
        } else {
            quote = '\"';
            doublequote = "\\\"";
            singlequote = "'";
        }
        return this.strEscape(s, quote, doublequote, singlequote, "\\\\", this.outputCharsetEncoder, useSlashV, false);
    }

    String regexpEscape(String s, OutputCharsetEncoder outputCharsetEncoder) {
        return this.strEscape(s, '/', "\"", "'", "\\", outputCharsetEncoder, false, true);
    }

    String regexpEscape(String s) {
        return this.regexpEscape(s, null);
    }

    private String strEscape(String s, char quote, String doublequoteEscape, String singlequoteEscape, String backslashEscape, OutputCharsetEncoder outputCharsetEncoder, boolean useSlashV, boolean isRegexp) {
        StringBuilder sb = new StringBuilder(s.length() + 2);
        sb.append(quote);
        block18: for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '\u0000': {
                    sb.append("\\x00");
                    continue block18;
                }
                case '\u000b': {
                    if (useSlashV) {
                        sb.append("\\v");
                        continue block18;
                    }
                    sb.append("\\x0B");
                    continue block18;
                }
                case '\b': {
                    sb.append("\\b");
                    continue block18;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block18;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block18;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block18;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block18;
                }
                case '\\': {
                    sb.append(backslashEscape);
                    continue block18;
                }
                case '\"': {
                    sb.append(doublequoteEscape);
                    continue block18;
                }
                case '\'': {
                    sb.append(singlequoteEscape);
                    continue block18;
                }
                case '\u2028': {
                    sb.append("\\u2028");
                    continue block18;
                }
                case '\u2029': {
                    sb.append("\\u2029");
                    continue block18;
                }
                case '=': {
                    if (this.trustedStrings || isRegexp) {
                        sb.append(c);
                        continue block18;
                    }
                    sb.append("\\x3d");
                    continue block18;
                }
                case '&': {
                    if (this.trustedStrings || isRegexp) {
                        sb.append(c);
                        continue block18;
                    }
                    sb.append("\\x26");
                    continue block18;
                }
                case '>': {
                    if (!this.trustedStrings && !isRegexp) {
                        sb.append(GT_ESCAPED);
                        continue block18;
                    }
                    if (i >= 2 && (s.charAt(i - 1) == '-' && s.charAt(i - 2) == '-' || s.charAt(i - 1) == ']' && s.charAt(i - 2) == ']')) {
                        sb.append(GT_ESCAPED);
                        continue block18;
                    }
                    sb.append(c);
                    continue block18;
                }
                case '<': {
                    if (!this.trustedStrings && !isRegexp) {
                        sb.append(LT_ESCAPED);
                        continue block18;
                    }
                    String endScript = "/script";
                    String startComment = "!--";
                    if (s.regionMatches(true, i + 1, "/script", 0, "/script".length())) {
                        sb.append(LT_ESCAPED);
                        continue block18;
                    }
                    if (s.regionMatches(false, i + 1, "!--", 0, "!--".length())) {
                        sb.append(LT_ESCAPED);
                        continue block18;
                    }
                    sb.append(c);
                    continue block18;
                }
                default: {
                    if (outputCharsetEncoder != null && outputCharsetEncoder.canEncode(c) || c > '\u001f' && c < '\u007f') {
                        sb.append(c);
                        continue block18;
                    }
                    Util.appendHexJavaScriptRepresentation(sb, c);
                }
            }
        }
        sb.append(quote);
        return sb.toString();
    }

    static String identifierEscape(String s) {
        if (NodeUtil.isLatin(s)) {
            return s;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c > '\u001f' && c < '\u007f') {
                sb.append(c);
                continue;
            }
            Util.appendHexJavaScriptRepresentation(sb, c);
        }
        return sb.toString();
    }

    private static int getNonEmptyChildCount(Node n, int maxCount) {
        int i = 0;
        for (Node c = n.getFirstChild(); c != null && i < maxCount; c = c.getNext()) {
            if (c.isBlock()) {
                i += CodeGenerator.getNonEmptyChildCount(c, maxCount - i);
                continue;
            }
            if (c.isEmpty()) continue;
            ++i;
        }
        return i;
    }

    private static Node getFirstNonEmptyChild(Node n) {
        for (Node c = n.getFirstChild(); c != null; c = c.getNext()) {
            if (c.isBlock()) {
                Node result = CodeGenerator.getFirstNonEmptyChild(c);
                if (result == null) continue;
                return result;
            }
            if (c.isEmpty()) continue;
            return c;
        }
        return null;
    }

    private static Context getContextForNonEmptyExpression(Context currentContext) {
        return currentContext == Context.BEFORE_DANGLING_ELSE ? Context.BEFORE_DANGLING_ELSE : Context.OTHER;
    }

    private static Context getContextForNoInOperator(Context context) {
        return context == Context.IN_FOR_INIT_CLAUSE ? Context.IN_FOR_INIT_CLAUSE : Context.OTHER;
    }

    private void processEnd(Node n, Context context) {
        switch (n.getType()) {
            case 158: 
            case 172: 
            case 311: 
            case 314: {
                this.cc.endClass(context == Context.STATEMENT);
                break;
            }
            case 105: {
                if (n.getLastChild().isEmpty()) {
                    this.cc.endStatement(true);
                    break;
                }
                this.cc.endFunction(context == Context.STATEMENT);
                break;
            }
            case 318: {
                if (n.getParent().getType() == 322) break;
                this.processEnd(n.getFirstChild(), context);
                break;
            }
            case 169: {
                if (n.getParent().getType() == 322 || n.getFirstChild().getType() == 318) break;
                this.processEnd(n.getFirstChild(), context);
                break;
            }
            case 175: {
                if (!n.hasOneChild()) break;
                this.cc.endStatement(true);
                break;
            }
            case 147: 
            case 148: 
            case 160: {
                if (!n.getFirstChild().getLastChild().isEmpty()) break;
                this.cc.endStatement(true);
                break;
            }
            case 319: {
                this.cc.endStatement(true);
                break;
            }
            default: {
                if (context != Context.STATEMENT) break;
                this.cc.endStatement();
            }
        }
    }

    static enum Context {
        STATEMENT,
        BEFORE_DANGLING_ELSE,
        START_OF_EXPR,
        PRESERVE_BLOCK,
        IN_FOR_INIT_CLAUSE,
        OTHER;

    }
}

