/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;

class ObjectLitAssignmentShortening
implements CompilerPass {
    private final AbstractCompiler compiler;

    ObjectLitAssignmentShortening(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    @Override
    public void process(Node externs, Node root) {
        NodeTraversal.traverseEs6(this.compiler, root, new ObjectLitShorteningCallback(this.compiler));
    }

    private class ObjectLitShorteningCallback
    extends NodeTraversal.AbstractPostOrderCallback {
        AbstractCompiler compiler;

        ObjectLitShorteningCallback(AbstractCompiler compiler) {
            this.compiler = compiler;
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            if (parent != null && parent.isObjectLit() && n.isStringKey()) {
                if (!n.hasChildren()) {
                    return;
                }
                Node valueNode = n.getFirstChild();
                if (valueNode.isName() && n.getString().equals(valueNode.getString())) {
                    n.removeChild(valueNode);
                    this.compiler.reportCodeChange();
                } else if (valueNode.isFunction() && !valueNode.isArrowFunction()) {
                    this.functionAssignmentShortening(n, valueNode, parent);
                }
            }
        }

        private void functionAssignmentShortening(Node n, Node functionNode, Node parent) {
            n.removeChild(functionNode);
            Node memDefNode = IR.memberFunctionDef(n.getString(), functionNode);
            parent.replaceChild(n, memDefNode);
            this.compiler.reportCodeChange();
        }
    }
}

