/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.newtypes;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.javascript.jscomp.newtypes.DeclaredFunctionType;
import com.google.javascript.jscomp.newtypes.FunctionType;
import com.google.javascript.jscomp.newtypes.JSType;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class FunctionTypeBuilder {
    private final List<JSType> requiredFormals = new ArrayList<JSType>();
    private final List<JSType> optionalFormals = new ArrayList<JSType>();
    private final Map<String, JSType> outerVars = new LinkedHashMap<String, JSType>();
    private JSType restFormals = null;
    private JSType returnType = null;
    private boolean loose = false;
    private JSType nominalType;
    private JSType receiverType;
    private ImmutableList<String> typeParameters = ImmutableList.of();

    static FunctionTypeBuilder qmarkFunctionBuilder() {
        FunctionTypeBuilder builder = new FunctionTypeBuilder();
        builder.addRestFormals(JSType.UNKNOWN);
        builder.addRetType(JSType.UNKNOWN);
        return builder;
    }

    public FunctionTypeBuilder addPlaceholderFormal() {
        if (this.restFormals == null) {
            if (!this.optionalFormals.isEmpty()) {
                this.optionalFormals.add(JSType.UNKNOWN);
            } else {
                this.requiredFormals.add(JSType.UNKNOWN);
            }
        }
        return this;
    }

    public FunctionTypeBuilder addReqFormal(JSType t) throws WrongParameterOrderException {
        if (!this.optionalFormals.isEmpty() || this.restFormals != null) {
            throw new WrongParameterOrderException("Cannot add required formal after optional or rest args");
        }
        this.requiredFormals.add(t);
        return this;
    }

    public FunctionTypeBuilder addOptFormal(JSType t) throws WrongParameterOrderException {
        if (this.restFormals != null) {
            throw new WrongParameterOrderException("Cannot add optional formal after rest args");
        }
        if (t == null) {
            this.optionalFormals.add(null);
        } else {
            Preconditions.checkArgument((!t.isBottom() ? 1 : 0) != 0);
            this.optionalFormals.add(JSType.join(t, JSType.UNDEFINED));
        }
        return this;
    }

    public FunctionTypeBuilder addOuterVarPrecondition(String name, JSType t) {
        this.outerVars.put(name, t);
        return this;
    }

    public FunctionTypeBuilder addRestFormals(JSType t) {
        Preconditions.checkState((this.restFormals == null ? 1 : 0) != 0);
        this.restFormals = t;
        return this;
    }

    public FunctionTypeBuilder addRetType(JSType t) {
        Preconditions.checkState((this.returnType == null ? 1 : 0) != 0);
        this.returnType = t;
        return this;
    }

    public FunctionTypeBuilder addLoose() {
        this.loose = true;
        return this;
    }

    public FunctionTypeBuilder addNominalType(JSType t) {
        Preconditions.checkState((this.nominalType == null ? 1 : 0) != 0);
        this.nominalType = t;
        return this;
    }

    public FunctionTypeBuilder addTypeParameters(ImmutableList<String> typeParameters) {
        Preconditions.checkNotNull(typeParameters);
        Preconditions.checkState((boolean)this.typeParameters.isEmpty());
        this.typeParameters = typeParameters;
        return this;
    }

    public FunctionTypeBuilder addReceiverType(JSType t) {
        this.receiverType = t;
        return this;
    }

    public DeclaredFunctionType buildDeclaration() {
        Preconditions.checkState((!this.loose ? 1 : 0) != 0);
        Preconditions.checkState((boolean)this.outerVars.isEmpty());
        return DeclaredFunctionType.make(this.requiredFormals, this.optionalFormals, this.restFormals, this.returnType, this.nominalType, this.receiverType, this.typeParameters);
    }

    public FunctionType buildFunction() {
        if (this.requiredFormals.isEmpty() && this.optionalFormals.isEmpty() && this.restFormals != null && this.restFormals.isUnknown() && this.returnType != null && this.returnType.isUnknown() && this.nominalType == null && this.receiverType == null && this.typeParameters.isEmpty() && this.outerVars.isEmpty()) {
            return FunctionType.QMARK_FUNCTION;
        }
        FunctionType result = FunctionType.normalized(this.requiredFormals, this.optionalFormals, this.restFormals, this.returnType, this.nominalType, this.receiverType, this.outerVars, this.typeParameters, this.loose);
        result.checkValid();
        return result;
    }

    static class WrongParameterOrderException
    extends RuntimeException {
        WrongParameterOrderException(String message) {
            super(message);
        }
    }
}

