/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.lang.python.ui.completion;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.ease.ICompletionContext;
import org.eclipse.ease.IScriptEngine;
import org.eclipse.ease.Logger;
import org.eclipse.ease.lang.python.debugger.ResourceHelper;
import org.eclipse.ease.ui.completion.ICompletionProvider;
import org.eclipse.ease.ui.completion.ScriptCompletionProposal;

public class PythonCompletionProviderWrapper
implements ICompletionProvider {
    private ICompletionProvider fPythonProvider = null;

    public void setPythonPprovider(ICompletionProvider provider) {
        this.fPythonProvider = provider;
    }

    public Collection<? extends ScriptCompletionProposal> getProposals(ICompletionContext context) {
        if (!this.isActive(context)) {
            return new ArrayList();
        }
        IScriptEngine engine = context.getScriptEngine();
        if (engine != null) {
            if (this.fPythonProvider == null) {
                try {
                    InputStream stream = ResourceHelper.getResourceStream("org.eclipse.ease.lang.python", "pysrc/autocomplete.py");
                    engine.setVariable("_pyease_jedi_completion_provider_wrapper", (Object)this);
                    engine.inject((Object)stream, false);
                }
                catch (Throwable e) {
                    Logger.error((String)"org.eclipse.ease.lang.python", (String)"Cannot instantiate completion provider in Python world.", (Throwable)e);
                    return new ArrayList();
                }
            }
            if (this.fPythonProvider != null) {
                return this.fPythonProvider.getProposals(context);
            }
        }
        return new ArrayList();
    }

    public boolean isActive(ICompletionContext context) {
        if (this.fPythonProvider == null) {
            return context.getScriptEngine() != null && context.getScriptEngine().getDescription().supports("Python");
        }
        return this.fPythonProvider.isActive(context);
    }
}

