/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.ui.launching;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.debug.ui.ILaunchConfigurationTab;
import org.eclipse.ease.tools.ResourceTools;
import org.eclipse.ease.ui.Activator;
import org.eclipse.ease.ui.launching.FileExtensionFilter;
import org.eclipse.ease.ui.launching.LaunchConstants;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class LibrariesTab
extends AbstractLaunchConfigurationTab
implements ILaunchConfigurationTab {
    private final List<String> fLibraries = new ArrayList<String>();
    private TableViewer tableViewer;
    private Button fBtnRemove;

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("Libraries", "");
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        this.fLibraries.clear();
        try {
            this.fLibraries.addAll(LaunchConstants.getLibraries(configuration));
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        this.tableViewer.refresh();
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("Libraries", LaunchConstants.serializeLibraries(this.fLibraries));
    }

    public String getMessage() {
        return "Please select JAR files to load within the interpreter.";
    }

    public String getName() {
        return "Libraries";
    }

    public void createControl(Composite parent) {
        Composite topControl = new Composite(parent, 0);
        topControl.setLayout((Layout)new GridLayout(2, false));
        Label lblStartupCode = new Label(topControl, 0);
        lblStartupCode.setText("Additional li&braries:");
        lblStartupCode.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 2, 1));
        this.tableViewer = new TableViewer(topControl, 2560);
        Table table = this.tableViewer.getTable();
        table.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LibrariesTab.this.updateButtonStatus();
            }
        });
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new JarTableProvider());
        this.tableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.tableViewer.setInput(this.fLibraries);
        Composite composite = new Composite(topControl, 0);
        composite.setLayoutData((Object)new GridData(16384, 128, false, false, 1, 1));
        FillLayout fl_composite = new FillLayout(512);
        fl_composite.spacing = 10;
        composite.setLayout((Layout)fl_composite);
        Button btnAddJar = new Button(composite, 0);
        btnAddJar.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LibrariesTab.this.addWorkspaceJar();
            }
        });
        btnAddJar.setText("Add &JARs...");
        Button btnAddExternalJar = new Button(composite, 0);
        btnAddExternalJar.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LibrariesTab.this.addExternalJar();
            }
        });
        btnAddExternalJar.setText("Add E&xternal JARs...");
        this.fBtnRemove = new Button(composite, 0);
        this.fBtnRemove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LibrariesTab.this.removeJar();
            }
        });
        this.fBtnRemove.setText("R&emove");
        this.updateButtonStatus();
        this.setControl((Control)topControl);
    }

    private void refresh() {
        this.tableViewer.refresh();
        this.updateLaunchConfigurationDialog();
        this.updateButtonStatus();
    }

    private void updateButtonStatus() {
        boolean isEnable = !this.tableViewer.getStructuredSelection().isEmpty();
        this.fBtnRemove.setEnabled(isEnable);
    }

    private void addWorkspaceJar() {
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(this.getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
        dialog.setTitle("Select JAR file");
        dialog.setMessage("Select the JAR file to include:");
        dialog.addFilter((ViewerFilter)new FileExtensionFilter(new String[]{"jar"}));
        dialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        if (dialog.open() == 0) {
            this.fLibraries.add("workspace:/" + ((IFile)dialog.getFirstResult()).getFullPath().toPortableString());
            this.refresh();
        }
    }

    private void addExternalJar() {
        FileDialog dialog = new FileDialog(this.getShell(), 4098);
        dialog.setFilterExtensions(new String[]{"*.jar"});
        dialog.setFilterNames(new String[]{"Java Archives (*.jar)"});
        dialog.setText("JAR Selection");
        String filePath = dialog.open();
        if (filePath != null) {
            String[] stringArray = dialog.getFileNames();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String filename = stringArray[n2];
                String path = String.valueOf(dialog.getFilterPath()) + File.separator + filename;
                this.fLibraries.add(ResourceTools.toAbsoluteLocation((Object)path, null));
                ++n2;
            }
            this.refresh();
        }
    }

    private void removeJar() {
        IStructuredSelection selection = (IStructuredSelection)this.tableViewer.getSelection();
        Object element = selection.getFirstElement();
        if (element instanceof String) {
            this.fLibraries.remove(element);
            this.refresh();
        }
    }

    public Image getImage() {
        return Activator.getImage("org.eclipse.ease.ui", "/icons/eobj16/library_tab.gif", true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isValid(ILaunchConfiguration launchConfig) {
        this.setErrorMessage(null);
        try {
            String jarPath;
            Object jarFile;
            Collection<String> jarList = LaunchConstants.getLibraries(launchConfig);
            Iterator<String> iterator = jarList.iterator();
            do {
                if (iterator.hasNext()) continue;
                return true;
            } while (ResourceTools.isFile((Object)(jarFile = ResourceTools.resolve((Object)(jarPath = iterator.next())))));
            this.setErrorMessage("Invalid JAR file(s) selected.");
            return false;
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return true;
    }

    private class JarTableProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private JarTableProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (element instanceof String) {
                switch (columnIndex) {
                    case 0: {
                        return Activator.getImage("org.eclipse.ease.ui", "/icons/eobj16/jar_entry.png", true);
                    }
                }
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof String) {
                switch (columnIndex) {
                    case 0: {
                        return element.toString();
                    }
                }
            }
            return "";
        }
    }
}

