/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.ui.sdk.scheduler;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.equinox.internal.p2.ui.sdk.scheduler.AutomaticUpdateMessages;
import org.eclipse.equinox.internal.p2.ui.sdk.scheduler.AutomaticUpdatePlugin;
import org.eclipse.equinox.internal.p2.ui.sdk.scheduler.AutomaticUpdatesPopup;
import org.eclipse.equinox.internal.p2.ui.sdk.scheduler.LastAutoCheckForUpdateMemo;
import org.eclipse.equinox.internal.p2.ui.sdk.scheduler.StatusLineCLabelContribution;
import org.eclipse.equinox.internal.provisional.p2.core.eventbus.IProvisioningEventBus;
import org.eclipse.equinox.internal.provisional.p2.core.eventbus.ProvisioningListener;
import org.eclipse.equinox.internal.provisional.p2.updatechecker.IUpdateListener;
import org.eclipse.equinox.internal.provisional.p2.updatechecker.UpdateEvent;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.IProfileEvent;
import org.eclipse.equinox.p2.engine.IProfileRegistry;
import org.eclipse.equinox.p2.engine.PhaseSetFactory;
import org.eclipse.equinox.p2.engine.ProvisioningContext;
import org.eclipse.equinox.p2.engine.query.UserVisibleRootQuery;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.operations.ProfileModificationJob;
import org.eclipse.equinox.p2.operations.ProvisioningSession;
import org.eclipse.equinox.p2.operations.UpdateOperation;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.ui.ProvisioningUI;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.statushandlers.StatusManager;

public class AutomaticUpdater
implements IUpdateListener {
    StatusLineCLabelContribution updateAffordance;
    IStatusLineManager statusLineManager;
    Collection<IInstallableUnit> iusWithUpdates;
    String profileId;
    ProvisioningListener profileListener;
    AutomaticUpdatesPopup popup;
    boolean alreadyDownloaded = false;
    UpdateOperation operation;
    private static final String AUTO_UPDATE_STATUS_ITEM = "AutoUpdatesStatus";

    public AutomaticUpdater() {
        this.createProfileListener();
    }

    private void createProfileListener() {
        this.profileListener = o -> {
            IProfileEvent event;
            if (o instanceof IProfileEvent && (event = (IProfileEvent)o).getReason() == 2 && this.sameProfile(event.getProfileId())) {
                this.triggerNewUpdateNotification();
            }
        };
        this.getProvisioningEventBus().addListener(this.profileListener);
    }

    boolean sameProfile(String another) {
        IProfile profile;
        if ("_SELF_".equals(another) && (profile = this.getProfileRegistry().getProfile(another)) != null) {
            another = profile.getProfileId();
        }
        if ("_SELF_".equals(this.profileId) && (profile = this.getProfileRegistry().getProfile(this.profileId)) != null) {
            this.profileId = profile.getProfileId();
        }
        return this.profileId == another || this.profileId != null && this.profileId.equals(another);
    }

    public void updatesAvailable(UpdateEvent event) {
        this.updatesAvailable(event, true);
    }

    public void checkingForUpdates() {
        new LastAutoCheckForUpdateMemo(AutomaticUpdatePlugin.getDefault().getAgentLocation()).store(Calendar.getInstance().getTime());
    }

    void updatesAvailable(UpdateEvent event, final boolean notifyWithPopup) {
        boolean download = this.getPreferenceStore().getBoolean("download");
        this.profileId = event.getProfileId();
        this.iusWithUpdates = event.getIUs();
        this.validateIusToUpdate();
        this.alreadyDownloaded = false;
        final boolean showUpdateWizard = this.getPreferenceStore().getBoolean("showUpdateWizard");
        this.operation = new UpdateOperation(this.getSession(), this.iusWithUpdates);
        this.operation.setProfileId(event.getProfileId());
        IStatus status = this.operation.resolveModal((IProgressMonitor)new NullProgressMonitor());
        if (!status.isOK() || this.operation.getPossibleUpdates() == null || this.operation.getPossibleUpdates().length == 0) {
            if (PlatformUI.isWorkbenchRunning()) {
                PlatformUI.getWorkbench().getDisplay().asyncExec(() -> this.clearUpdateAffordances());
            }
            return;
        }
        if (download) {
            ProfileModificationJob job = new ProfileModificationJob(AutomaticUpdateMessages.AutomaticUpdater_AutomaticDownloadOperationName, this.getSession(), event.getProfileId(), this.operation.getProvisioningPlan(), new ProvisioningContext(this.getSession().getProvisioningAgent()));
            job.setPhaseSet(PhaseSetFactory.createPhaseSetIncluding((String[])new String[]{PhaseSetFactory.PHASE_COLLECT}));
            job.setUser(false);
            job.setSystem(true);
            job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                public void done(IJobChangeEvent jobEvent) {
                    IStatus jobStatus = jobEvent.getResult();
                    if (jobStatus.isOK()) {
                        AutomaticUpdater.this.alreadyDownloaded = true;
                        PlatformUI.getWorkbench().getDisplay().asyncExec(() -> AutomaticUpdater.this.notifyUserOfUpdates(AutomaticUpdater.this.operation.getResolutionResult().isOK(), notifyWithPopup, showUpdateWizard));
                    } else if (jobStatus.getSeverity() != 8) {
                        StatusManager.getManager().handle(jobStatus, 1);
                    }
                }
            });
            job.schedule();
        } else {
            PlatformUI.getWorkbench().getDisplay().asyncExec(() -> this.notifyUserOfUpdates(this.operation.getResolutionResult().isOK(), notifyWithPopup, showUpdateWizard));
        }
    }

    ProvisioningSession getSession() {
        return AutomaticUpdatePlugin.getDefault().getSession();
    }

    ProvisioningUI getProvisioningUI() {
        return ProvisioningUI.getDefaultUI();
    }

    void validateIusToUpdate() {
        ArrayList<IInstallableUnit> list = new ArrayList<IInstallableUnit>(this.iusWithUpdates.size());
        IProfile profile = this.getProfileRegistry().getProfile(this.profileId);
        if (profile != null) {
            for (IInstallableUnit iuWithUpdate : this.iusWithUpdates) {
                try {
                    if (!this.validToUpdate(profile, iuWithUpdate)) continue;
                    list.add(iuWithUpdate);
                }
                catch (OperationCanceledException operationCanceledException) {}
            }
        }
        this.iusWithUpdates = list;
    }

    private boolean validToUpdate(IProfile profile, IInstallableUnit iu) {
        int lock = 0;
        boolean isRoot = false;
        try {
            String value = profile.getInstallableUnitProperty(iu, "org.eclipse.equinox.p2.type.lock");
            if (value != null) {
                lock = Integer.parseInt(value);
            }
            isRoot = (value = profile.getInstallableUnitProperty(iu, "org.eclipse.equinox.p2.type.root")) == null ? false : Boolean.parseBoolean(value);
        }
        catch (NumberFormatException numberFormatException) {}
        return isRoot && (lock & 2) == 0;
    }

    Shell getWorkbenchWindowShell() {
        IWorkbenchWindow activeWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        return activeWindow != null ? activeWindow.getShell() : null;
    }

    IStatusLineManager getStatusLineManager() {
        if (this.statusLineManager != null) {
            return this.statusLineManager;
        }
        IWorkbenchWindow activeWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (activeWindow == null) {
            return null;
        }
        try {
            Method method = activeWindow.getClass().getDeclaredMethod("getStatusLineManager", new Class[0]);
            try {
                Object statusLine = method.invoke((Object)activeWindow, new Object[0]);
                if (statusLine instanceof IStatusLineManager) {
                    this.statusLineManager = (IStatusLineManager)statusLine;
                    return this.statusLineManager;
                }
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (IllegalAccessException illegalAccessException) {}
        }
        catch (NoSuchMethodException noSuchMethodException) {}
        IWorkbenchPage page = activeWindow.getActivePage();
        if (page == null) {
            return null;
        }
        IWorkbenchPart part = page.getActivePart();
        if (part == null) {
            return null;
        }
        IWorkbenchPartSite site = part.getSite();
        if (site instanceof IViewSite) {
            this.statusLineManager = ((IViewSite)site).getActionBars().getStatusLineManager();
        } else if (site instanceof IEditorSite) {
            this.statusLineManager = ((IEditorSite)site).getActionBars().getStatusLineManager();
        }
        return this.statusLineManager;
    }

    void updateStatusLine() {
        IStatusLineManager manager = this.getStatusLineManager();
        if (manager != null) {
            manager.update(true);
        }
    }

    void createUpdateAffordance() {
        this.updateAffordance = new StatusLineCLabelContribution(AUTO_UPDATE_STATUS_ITEM, 5);
        this.updateAffordance.addListener(3, event -> this.launchUpdate());
        IStatusLineManager manager = this.getStatusLineManager();
        if (manager != null) {
            manager.add((IContributionItem)this.updateAffordance);
            manager.update(true);
        }
    }

    void notifyUserOfUpdates(boolean isValid, boolean showPopup, boolean showUpdateWizard) {
        if (this.updateAffordance == null) {
            this.createUpdateAffordance();
        }
        if (isValid) {
            if (showPopup) {
                if (showUpdateWizard) {
                    this.launchUpdate();
                } else {
                    this.openUpdatePopup();
                }
            }
            this.updateAffordance.setTooltip(AutomaticUpdateMessages.AutomaticUpdater_ClickToReviewUpdates);
            this.updateAffordance.setImage(AutomaticUpdatePlugin.getDefault().getImageRegistry().get("tool/update.png"));
        } else {
            this.updateAffordance.setTooltip(AutomaticUpdateMessages.AutomaticUpdater_ClickToReviewUpdatesWithProblems);
            this.updateAffordance.setImage(AutomaticUpdatePlugin.getDefault().getImageRegistry().get("tool/update_problems.png"));
        }
        IStatusLineManager manager = this.getStatusLineManager();
        if (manager != null) {
            manager.update(true);
        }
    }

    void checkUpdateAffordanceEnablement() {
        IStatusLineManager manager;
        if (this.updateAffordance == null) {
            return;
        }
        boolean shouldBeVisible = this.getProvisioningUI().hasScheduledOperations();
        if (this.updateAffordance.isVisible() != shouldBeVisible && (manager = this.getStatusLineManager()) != null) {
            this.updateAffordance.setVisible(shouldBeVisible);
            manager.update(true);
        }
    }

    void openUpdatePopup() {
        if (this.popup == null) {
            this.popup = new AutomaticUpdatesPopup(this.getWorkbenchWindowShell(), this.alreadyDownloaded, this.getPreferenceStore());
        }
        this.popup.open();
    }

    void clearUpdateAffordances() {
        if (this.updateAffordance != null) {
            IStatusLineManager manager = this.getStatusLineManager();
            if (manager != null) {
                manager.remove((IContributionItem)this.updateAffordance);
                manager.update(true);
            }
            this.updateAffordance.dispose();
            this.updateAffordance = null;
        }
        if (this.popup != null) {
            this.popup.close(false);
            this.popup = null;
        }
    }

    public void launchUpdate() {
        this.getProvisioningUI().openUpdateWizard(false, this.operation, null);
    }

    void triggerNewUpdateNotification() {
        Job notifyJob = new Job("Update validate job"){

            public IStatus run(IProgressMonitor monitor) {
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                AutomaticUpdater.this.updatesAvailable(new UpdateEvent(AutomaticUpdater.this.profileId, AutomaticUpdater.this.getInstalledIUs()));
                return Status.OK_STATUS;
            }
        };
        notifyJob.setSystem(true);
        notifyJob.setUser(false);
        notifyJob.setPriority(30);
        notifyJob.schedule();
    }

    public Collection<IInstallableUnit> getInstalledIUs() {
        IProfile profile = this.getProfileRegistry().getProfile(this.profileId);
        if (profile == null) {
            return Collections.emptyList();
        }
        UserVisibleRootQuery query = new UserVisibleRootQuery();
        IQueryResult queryResult = profile.query((IQuery)query, null);
        return queryResult.toUnmodifiableSet();
    }

    public void shutdown() {
        this.statusLineManager = null;
        if (this.profileListener != null) {
            this.getProvisioningEventBus().removeListener(this.profileListener);
            this.profileListener = null;
        }
    }

    IProfileRegistry getProfileRegistry() {
        return (IProfileRegistry)this.getSession().getProvisioningAgent().getService(IProfileRegistry.class);
    }

    IProvisioningEventBus getProvisioningEventBus() {
        return (IProvisioningEventBus)this.getSession().getProvisioningAgent().getService(IProvisioningEventBus.class);
    }

    IPreferenceStore getPreferenceStore() {
        return AutomaticUpdatePlugin.getDefault().getPreferenceStore();
    }
}

