/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.ui.internal.views;

import java.text.Collator;
import org.eclipse.help.ui.internal.IHelpUIConstants;
import org.eclipse.help.ui.internal.Messages;
import org.eclipse.help.ui.internal.views.IHelpPart;
import org.eclipse.help.ui.internal.views.IndexPart;
import org.eclipse.help.ui.internal.views.ReusableHelpPart;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.forms.AbstractFormPart;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class IndexTypeinPart
extends AbstractFormPart
implements IHelpPart,
IHelpUIConstants {
    private ReusableHelpPart parent;
    String id;
    private Composite container;
    private FormText indexInstructions;
    private Text indexText;
    private Button indexButton;
    private IndexPart indexPart;
    private Tree indexTree;
    private int itemCount;
    private String[] rootItems;
    private int currentIndex;

    public IndexTypeinPart(Composite parent, FormToolkit toolkit, IToolBarManager tbm) {
        this.container = toolkit.createComposite(parent);
        TableWrapLayout layout = new TableWrapLayout();
        layout.numColumns = 2;
        this.container.setLayout((Layout)layout);
        this.indexInstructions = toolkit.createFormText(this.container, false);
        this.indexInstructions.setText(Messages.IndexInstructions, false, false);
        TableWrapData td = new TableWrapData();
        td.colspan = 2;
        this.indexInstructions.setLayoutData((Object)td);
        this.indexText = toolkit.createText(this.container, null);
        td = new TableWrapData(256);
        td.maxWidth = 100;
        td.valign = 32;
        this.indexText.setLayoutData((Object)td);
        this.indexButton = toolkit.createButton(this.container, Messages.IndexButton, 8);
        this.indexButton.setEnabled(false);
        this.indexText.addModifyListener(e -> {
            this.indexButton.setEnabled(this.indexText.getText().length() > 0);
            this.doNavigate(this.indexText.getText());
        });
        this.indexText.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
                if (e.character == '\r' && IndexTypeinPart.this.indexButton.isEnabled()) {
                    IndexTypeinPart.this.doOpen();
                }
            }

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 0x1000001) {
                    e.doit = false;
                    IndexTypeinPart.this.doUp();
                } else if (e.keyCode == 0x1000002) {
                    e.doit = false;
                    IndexTypeinPart.this.doDown();
                }
            }
        });
        this.indexButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IndexTypeinPart.this.doOpen();
            }
        });
        toolkit.paintBordersFor(this.container);
        this.currentIndex = -1;
    }

    protected void doUp() {
        this.checkTree();
        if (this.indexTree == null) {
            return;
        }
        int index = 0;
        TreeItem[] items = this.indexTree.getSelection();
        if (items.length > 0 && (index = this.indexTree.indexOf(items[0]) - 1) < 0) {
            return;
        }
        TreeItem item = this.indexTree.getItem(index);
        this.indexTree.setSelection(new TreeItem[]{item});
        String text = item.getText();
        this.indexText.setText(text);
        this.indexText.setSelection(0, text.length());
    }

    protected void doDown() {
        this.checkTree();
        if (this.indexTree == null) {
            return;
        }
        int index = 0;
        TreeItem[] items = this.indexTree.getSelection();
        if (items.length > 0 && (index = this.indexTree.indexOf(items[0]) + 1) >= this.indexTree.getItemCount()) {
            return;
        }
        TreeItem item = this.indexTree.getItem(index);
        this.indexTree.setSelection(new TreeItem[]{item});
        String text = item.getText();
        this.indexText.setText(text);
        this.indexText.setSelection(0, text.length());
    }

    protected void doNavigate(String text) {
        this.checkTree();
        if (this.rootItems == null) {
            return;
        }
        int index = this.searchPattern(text);
        if (index != -1 && index != this.currentIndex) {
            this.indexTree.setSelection(new TreeItem[]{this.indexTree.getItem(index)});
            this.currentIndex = index;
        }
    }

    private void checkTree() {
        if (this.rootItems != null) {
            return;
        }
        this.indexPart = (IndexPart)this.parent.findPart("index");
        if (this.indexPart == null) {
            return;
        }
        this.indexTree = this.indexPart.getTreeWidget();
        if (this.indexTree == null) {
            return;
        }
        this.itemCount = this.indexTree.getItemCount();
        if (this.itemCount == 0) {
            this.indexTree = null;
        } else {
            this.rootItems = new String[this.itemCount];
            int i = 0;
            while (i < this.itemCount) {
                this.rootItems[i] = this.indexTree.getItem(i).getText();
                ++i;
            }
        }
    }

    private int searchPattern(String pattern) {
        int from = 0;
        int to = this.rootItems.length;
        while (to > from) {
            int i = (to + from) / 2;
            int res = this.compare(this.rootItems[i], pattern);
            if (res == 0) {
                while (i > 0) {
                    if (this.compare(this.rootItems[--i], pattern) == 0) continue;
                    ++i;
                    break;
                }
                return i;
            }
            if (res < 0) {
                from = i + 1;
                continue;
            }
            to = i;
        }
        if (from >= this.rootItems.length) {
            return this.rootItems.length - 1;
        }
        return from;
    }

    int compare(String keyword, String pattern) {
        return Collator.getInstance().compare(keyword, pattern);
    }

    protected void doOpen() {
        this.checkTree();
        if (this.indexTree == null) {
            return;
        }
        TreeItem[] items = this.indexTree.getSelection();
        if (items.length == 0) {
            return;
        }
        Object obj = items[0].getData();
        if (obj != null) {
            this.indexPart.doOpen(obj);
        }
    }

    @Override
    public void init(ReusableHelpPart parent, String id, IMemento memento) {
        this.parent = parent;
        this.id = id;
    }

    @Override
    public void saveState(IMemento memento) {
    }

    @Override
    public Control getControl() {
        return this.container;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setVisible(boolean visible) {
        this.getControl().setVisible(visible);
    }

    @Override
    public boolean hasFocusControl(Control control) {
        return false;
    }

    @Override
    public boolean fillContextMenu(IMenuManager manager) {
        return false;
    }

    @Override
    public IAction getGlobalAction(String id) {
        return null;
    }

    @Override
    public void stop() {
    }

    @Override
    public void toggleRoleFilter() {
    }

    @Override
    public void refilter() {
    }

    public void setFocus() {
        this.indexText.setFocus();
    }

    public Text getTextWidget() {
        return this.indexText;
    }
}

