/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.callstack.ui;

import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.tracecompass.internal.analysis.os.linux.ui.views.controlflow.ControlFlowPresentationProvider;
import org.eclipse.tracecompass.tmf.core.presentation.RGBAColor;
import org.eclipse.tracecompass.tmf.core.presentation.RotatingPaletteProvider;
import org.eclipse.tracecompass.tmf.ui.colors.RGBAUtil;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.StateItem;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeEvent;

public final class FlameViewPalette {
    public static final int MULTIPLE_STATE_INDEX = State.MULTIPLE.ordinal();
    private static final int NUM_COLORS = 360;
    private final StateItem[] fStateTable;
    private final ControlFlowPresentationProvider fCfProvider = new ControlFlowPresentationProvider();
    private static @Nullable FlameViewPalette fInstance = null;

    private FlameViewPalette() {
        RotatingPaletteProvider palette = new RotatingPaletteProvider.Builder().setNbColors(360).build();
        StateItem[] cfStateTable = this.fCfProvider.getStateTable();
        this.fStateTable = new StateItem[361 + cfStateTable.length];
        this.fStateTable[0] = new StateItem(State.MULTIPLE.rgb, State.MULTIPLE.toString());
        int i = 1;
        for (RGBAColor color : palette.get()) {
            this.fStateTable[i] = new StateItem(RGBAUtil.fromRGBAColor((RGBAColor)color).rgb, color.toString());
            ++i;
        }
        i = 0;
        while (i < cfStateTable.length) {
            this.fStateTable[361 + i] = cfStateTable[i];
            ++i;
        }
    }

    public static FlameViewPalette getInstance() {
        FlameViewPalette instance = fInstance;
        if (instance == null) {
            fInstance = instance = new FlameViewPalette();
        }
        return instance;
    }

    public StateItem[] getStateTable() {
        return this.fStateTable;
    }

    public int getControlFlowIndex(ITimeEvent event) {
        int cfIndex = this.fCfProvider.getStateTableIndex(event);
        if (cfIndex >= 0) {
            return 361 + cfIndex;
        }
        return -1;
    }

    public static int getIndexForValue(int value) {
        return Math.floorMod(value, 360) + 1;
    }

    private static enum State {
        MULTIPLE(new RGB(100, 100, 100)),
        EXEC(new RGB(0, 200, 0));

        private final RGB rgb;

        private State(RGB rgb) {
            this.rgb = rgb;
        }
    }
}

