/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.ros.ui.actions;

import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.tracecompass.incubator.internal.ros.ui.Activator;
import org.eclipse.tracecompass.incubator.internal.ros.ui.actions.Messages;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.TimeGraphViewer;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeGraphEntry;

public class HideRosoutAction
extends Action {
    private static final @NonNull String IMG_UI = "icons/elcl16/hide_rosout.gif";
    private static final String HIDE_ROSOUT_KEY_PREFIX = "hide.rosout.";
    private final TimeGraphViewer fTimeGraphViewer;
    private final IDialogSettings fDialogSettings;
    private final String fHideRosoutKeySufix;

    public HideRosoutAction(String hideRosoutKeySuffix, TimeGraphViewer timeGraphViewer, IDialogSettings dialogSettings) {
        this.fHideRosoutKeySufix = hideRosoutKeySuffix;
        this.fTimeGraphViewer = timeGraphViewer;
        this.fDialogSettings = dialogSettings;
        this.setText(Messages.HideRosoutAction_NameText);
        this.setToolTipText(Messages.HideRosoutAction_ToolTipText);
        this.setImageDescriptor(Objects.requireNonNull(Activator.getDefault()).getImageDescripterFromPath(IMG_UI));
        if (this.fDialogSettings != null) {
            boolean hideRosout = this.fDialogSettings.getBoolean(HIDE_ROSOUT_KEY_PREFIX + this.fHideRosoutKeySufix);
            this.update(hideRosout);
            this.setChecked(hideRosout);
        }
    }

    private void update(boolean hideRosout) {
        RosoutViewerFilter rosoutViewerFilter = null;
        ViewerFilter[] viewerFilterArray = this.fTimeGraphViewer.getFilters();
        int n = viewerFilterArray.length;
        int n2 = 0;
        while (n2 < n) {
            ViewerFilter filter = viewerFilterArray[n2];
            if (filter instanceof RosoutViewerFilter) {
                rosoutViewerFilter = (RosoutViewerFilter)filter;
            }
            ++n2;
        }
        if (rosoutViewerFilter == null) {
            rosoutViewerFilter = new RosoutViewerFilter(hideRosout);
            this.addFilter(rosoutViewerFilter);
        } else {
            rosoutViewerFilter.setFilterEnabled(hideRosout);
            this.changeFilter(rosoutViewerFilter);
        }
    }

    public void run() {
        ITimeGraphEntry[] topInput = this.fTimeGraphViewer.getTimeGraphContentProvider().getElements(this.fTimeGraphViewer.getInput());
        if (topInput != null) {
            boolean hideRosout = this.isChecked();
            this.update(hideRosout);
            if (this.fDialogSettings != null) {
                this.fDialogSettings.put(HIDE_ROSOUT_KEY_PREFIX + this.fHideRosoutKeySufix, hideRosout);
            }
        }
    }

    private void addFilter(@NonNull ViewerFilter filter) {
        this.fTimeGraphViewer.addFilter(filter);
    }

    private void changeFilter(@NonNull ViewerFilter filter) {
        this.fTimeGraphViewer.changeFilter(filter);
    }

    private class RosoutViewerFilter
    extends ViewerFilter {
        private static final String ROSOUT_NODE = "rosout/rosout";
        private static final String ROSOUT_TOPIC = "/rosout";
        private boolean fIsEnabled;

        public RosoutViewerFilter(boolean isEnabled) {
            this.fIsEnabled = isEnabled;
        }

        public void setFilterEnabled(boolean isEnabled) {
            this.fIsEnabled = isEnabled;
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (!this.fIsEnabled) {
                return true;
            }
            ITimeGraphEntry entry = (ITimeGraphEntry)element;
            String entryName = entry.getName();
            if (entryName.equals(ROSOUT_NODE) || entryName.equals(ROSOUT_TOPIC)) {
                return false;
            }
            return entry.getChildren().size() != 1 || !((ITimeGraphEntry)entry.getChildren().get(0)).getName().equals(ROSOUT_TOPIC);
        }
    }
}

