/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.virtual.machine.analysis.ui.views.vresources;

import java.util.Iterator;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.internal.analysis.os.linux.core.resourcesstatus.SoftIrqLabelProvider;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeGraphEntry;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.TimeGraphEntry;

public class VirtualResourceEntry
extends TimeGraphEntry
implements Comparable<ITimeGraphEntry> {
    private final int fId;
    private final @NonNull ITmfTrace fTrace;
    private final Type fType;
    private final int fQuark;

    public VirtualResourceEntry(int quark, @NonNull ITmfTrace trace, String name, long startTime, long endTime, Type type, int id) {
        super(name, startTime, endTime);
        this.fId = id;
        this.fTrace = trace;
        this.fType = type;
        this.fQuark = quark;
    }

    public VirtualResourceEntry(@NonNull ITmfTrace trace, String name, long startTime, long endTime, Type type, int id) {
        this(-1, trace, name, startTime, endTime, type, id);
    }

    public VirtualResourceEntry(int quark, @NonNull ITmfTrace trace, long startTime, long endTime, Type type, int id) {
        this(quark, trace, VirtualResourceEntry.computeEntryName(type, id), startTime, endTime, type, id);
    }

    private static String computeEntryName(Type type, int id) {
        if (Type.SOFT_IRQ.equals((Object)type)) {
            return String.valueOf(type.toString()) + ' ' + id + ' ' + SoftIrqLabelProvider.getSoftIrq((int)id);
        }
        return String.valueOf(type.toString()) + ' ' + id;
    }

    public int getId() {
        return this.fId;
    }

    public @NonNull ITmfTrace getTrace() {
        return this.fTrace;
    }

    public Type getType() {
        return this.fType;
    }

    public int getQuark() {
        return this.fQuark;
    }

    public boolean hasTimeEvents() {
        return this.fType != Type.NULL && this.fType != Type.VM && this.fType != Type.CONTAINER;
    }

    public boolean getDefaultExpandedState() {
        return this.fType != Type.CPU;
    }

    @Override
    public int compareTo(ITimeGraphEntry other) {
        if (!(other instanceof VirtualResourceEntry)) {
            return -1;
        }
        VirtualResourceEntry o = (VirtualResourceEntry)other;
        int ret = this.getType().compareTo(o.getType());
        if (ret != 0) {
            return ret;
        }
        return Integer.compare(this.getId(), o.getId());
    }

    public Iterator<@NonNull ITimeEvent> getTimeEventsIterator() {
        return super.getTimeEventsIterator();
    }

    public static enum Type {
        NULL,
        CPU,
        PCPU_VM,
        PCPU_CONTAINER,
        IRQ,
        SOFT_IRQ,
        VM,
        CONTAINER;


        public String toString() {
            if (this == CPU || this == PCPU_VM || this == PCPU_CONTAINER) {
                return "PCPU";
            }
            return super.toString();
        }
    }
}

