/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.dialogs;

import java.text.Collator;
import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.decorators.DecoratorDefinition;
import org.eclipse.ui.internal.decorators.DecoratorManager;

public class DecoratorsPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Text descriptionText;
    private CheckboxTableViewer checkboxViewer;

    public DecoratorsPreferencePage() {
        this.setDescription(WorkbenchMessages.DecoratorsPreferencePage_explanation);
    }

    protected Control createContents(Composite parent) {
        Font font = parent.getFont();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.ui.decorators_preference_page_context");
        Composite mainComposite = new Composite(parent, 0);
        mainComposite.setLayoutData((Object)new GridData(768));
        mainComposite.setFont(font);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = 10;
        mainComposite.setLayout((Layout)layout);
        this.createDecoratorsArea(mainComposite);
        this.createDescriptionArea(mainComposite);
        this.populateDecorators();
        return mainComposite;
    }

    private void createDecoratorsArea(Composite mainComposite) {
        Font mainFont = mainComposite.getFont();
        Composite decoratorsComposite = new Composite(mainComposite, 0);
        decoratorsComposite.setLayoutData((Object)new GridData(1808));
        GridLayout decoratorsLayout = new GridLayout();
        decoratorsLayout.marginWidth = 0;
        decoratorsLayout.marginHeight = 0;
        decoratorsComposite.setLayout((Layout)decoratorsLayout);
        decoratorsComposite.setFont(mainFont);
        Label decoratorsLabel = new Label(decoratorsComposite, 0);
        decoratorsLabel.setText(WorkbenchMessages.DecoratorsPreferencePage_decoratorsLabel);
        decoratorsLabel.setFont(mainFont);
        this.checkboxViewer = CheckboxTableViewer.newCheckList((Composite)decoratorsComposite, (int)2180);
        GridData layoutData = new GridData(1808);
        layoutData.heightHint = 300;
        this.checkboxViewer.getTable().setLayoutData((Object)layoutData);
        this.checkboxViewer.getTable().setFont(decoratorsComposite.getFont());
        this.checkboxViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((DecoratorDefinition)element).getName();
            }
        });
        this.checkboxViewer.getTable().setFont(mainFont);
        this.checkboxViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){
            private final Comparator comparer = new Comparator(){
                private Collator collator = Collator.getInstance();

                public int compare(Object arg0, Object arg1) {
                    String s1 = ((DecoratorDefinition)arg0).getName();
                    String s2 = ((DecoratorDefinition)arg1).getName();
                    return this.collator.compare(s1, s2);
                }
            };

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public Object[] getElements(Object inputElement) {
                Object[] elements = (Object[])inputElement;
                Object[] results = new Object[elements.length];
                System.arraycopy(elements, 0, results, 0, elements.length);
                Arrays.asList(results).sort(this.comparer);
                return results;
            }
        });
        this.checkboxViewer.addSelectionChangedListener(event -> {
            if (event.getSelection() instanceof IStructuredSelection) {
                IStructuredSelection sel = event.getStructuredSelection();
                DecoratorDefinition definition = (DecoratorDefinition)sel.getFirstElement();
                if (definition == null) {
                    this.clearDescription();
                } else {
                    this.showDescription(definition);
                }
            }
        });
        this.checkboxViewer.addCheckStateListener(event -> this.checkboxViewer.setSelection((ISelection)new StructuredSelection(event.getElement())));
    }

    private void createDescriptionArea(Composite mainComposite) {
        Font mainFont = mainComposite.getFont();
        Composite textComposite = new Composite(mainComposite, 0);
        textComposite.setLayoutData((Object)new GridData(1808));
        GridLayout textLayout = new GridLayout();
        textLayout.marginWidth = 0;
        textLayout.marginHeight = 0;
        textComposite.setLayout((Layout)textLayout);
        textComposite.setFont(mainFont);
        Label descriptionLabel = new Label(textComposite, 0);
        descriptionLabel.setText(WorkbenchMessages.DecoratorsPreferencePage_description);
        descriptionLabel.setFont(mainFont);
        this.descriptionText = new Text(textComposite, 2378);
        GridData layoutData = new GridData(1808);
        layoutData.minimumHeight = 50;
        this.descriptionText.setLayoutData((Object)layoutData);
        this.descriptionText.setFont(mainFont);
    }

    private void populateDecorators() {
        DecoratorDefinition[] definitions = this.getAllDefinitions();
        this.checkboxViewer.setInput((Object)definitions);
        DecoratorDefinition[] decoratorDefinitionArray = definitions;
        int n = definitions.length;
        int n2 = 0;
        while (n2 < n) {
            DecoratorDefinition definition = decoratorDefinitionArray[n2];
            this.checkboxViewer.setChecked((Object)definition, definition.isEnabled());
            ++n2;
        }
    }

    private void showDescription(DecoratorDefinition definition) {
        if (this.descriptionText == null || this.descriptionText.isDisposed()) {
            return;
        }
        String text = definition.getDescription();
        if (text == null || text.length() == 0) {
            this.descriptionText.setText(WorkbenchMessages.PreferencePage_noDescription);
        } else {
            this.descriptionText.setText(text);
        }
    }

    private void clearDescription() {
        if (this.descriptionText == null || this.descriptionText.isDisposed()) {
            return;
        }
        this.descriptionText.setText("");
    }

    protected void performDefaults() {
        super.performDefaults();
        DecoratorManager manager = WorkbenchPlugin.getDefault().getDecoratorManager();
        DecoratorDefinition[] decoratorDefinitionArray = manager.getAllDecoratorDefinitions();
        int n = decoratorDefinitionArray.length;
        int n2 = 0;
        while (n2 < n) {
            DecoratorDefinition definition = decoratorDefinitionArray[n2];
            this.checkboxViewer.setChecked((Object)definition, definition.getDefaultValue());
            ++n2;
        }
    }

    public boolean performOk() {
        if (super.performOk()) {
            DecoratorManager manager = this.getDecoratorManager();
            manager.clearCaches();
            DecoratorDefinition[] decoratorDefinitionArray = manager.getAllDecoratorDefinitions();
            int n = decoratorDefinitionArray.length;
            int n2 = 0;
            while (n2 < n) {
                DecoratorDefinition definition = decoratorDefinitionArray[n2];
                boolean checked = this.checkboxViewer.getChecked((Object)definition);
                definition.setEnabled(checked);
                ++n2;
            }
            manager.clearCaches();
            manager.updateForEnablementChange();
            return true;
        }
        return false;
    }

    @Override
    public void init(IWorkbench workbench) {
    }

    private DecoratorDefinition[] getAllDefinitions() {
        return this.getDecoratorManager().getAllDecoratorDefinitions();
    }

    private DecoratorManager getDecoratorManager() {
        return WorkbenchPlugin.getDefault().getDecoratorManager();
    }
}

