/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.changes;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.ChangeDescriptor;
import org.eclipse.ltk.core.refactoring.ContentStamp;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.text.edits.UndoEdit;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.UndoCompilationUnitChange;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;

public class CompilationUnitChange
extends TextFileChange {
    private final IJavaScriptUnit fCUnit;
    private ChangeDescriptor fDescriptor;

    public CompilationUnitChange(String name, IJavaScriptUnit cunit) {
        super(name, CompilationUnitChange.getFile(cunit));
        Assert.isNotNull((Object)cunit);
        this.fCUnit = cunit;
        this.setTextType("js");
    }

    private static IFile getFile(IJavaScriptUnit cunit) {
        return (IFile)cunit.getResource();
    }

    public Object getModifiedElement() {
        return this.fCUnit;
    }

    public IJavaScriptUnit getCompilationUnit() {
        return this.fCUnit;
    }

    protected IDocument acquireDocument(IProgressMonitor pm) throws CoreException {
        pm.beginTask("", 2);
        this.fCUnit.becomeWorkingCopy((IProgressMonitor)new SubProgressMonitor(pm, 1));
        return super.acquireDocument((IProgressMonitor)new SubProgressMonitor(pm, 1));
    }

    protected void releaseDocument(IDocument document, IProgressMonitor pm) throws CoreException {
        boolean isModified = this.isDocumentModified();
        super.releaseDocument(document, pm);
        try {
            this.fCUnit.discardWorkingCopy();
        }
        finally {
            if (isModified && !this.isDocumentAcquired()) {
                if (this.fCUnit.isWorkingCopy()) {
                    JavaModelUtil.reconcile(this.fCUnit);
                } else {
                    this.fCUnit.makeConsistent(pm);
                }
            }
        }
    }

    protected Change createUndoChange(UndoEdit edit, ContentStamp stampToRestore) {
        try {
            return new UndoCompilationUnitChange(this.getName(), this.fCUnit, edit, stampToRestore, this.getSaveMode());
        }
        catch (CoreException e) {
            JavaScriptPlugin.log(e);
            return null;
        }
    }

    public Object getAdapter(Class adapter) {
        if (IJavaScriptUnit.class.equals((Object)adapter)) {
            return this.fCUnit;
        }
        return super.getAdapter(adapter);
    }

    public void setDescriptor(ChangeDescriptor descriptor) {
        this.fDescriptor = descriptor;
    }

    public ChangeDescriptor getDescriptor() {
        return this.fDescriptor;
    }
}

