/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.text.java.hover;

import java.io.IOException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.ITextHoverExtension;
import org.eclipse.jface.text.information.IInformationProviderExtension2;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.part.IWorkbenchPartOrientation;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.ILocalVariable;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.ISourceReference;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.wst.jsdt.internal.corext.util.Strings;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.internal.ui.text.JavaCodeReader;
import org.eclipse.wst.jsdt.internal.ui.text.java.hover.AbstractJavaEditorTextHover;
import org.eclipse.wst.jsdt.internal.ui.text.java.hover.SourceViewerInformationControl;

public class JavaSourceHover
extends AbstractJavaEditorTextHover
implements ITextHoverExtension,
IInformationProviderExtension2 {
    @Override
    protected String getHoverInfo(IJavaScriptElement[] result) {
        int nResults = result.length;
        if (nResults > 1) {
            return null;
        }
        IJavaScriptElement curr = result[0];
        if ((curr instanceof IMember || curr instanceof ILocalVariable) && curr instanceof ISourceReference) {
            String source;
            block7: {
                try {
                    source = ((ISourceReference)curr).getSource();
                    if (source != null) break block7;
                    return null;
                }
                catch (JavaScriptModelException javaScriptModelException) {}
            }
            source = this.removeLeadingComments(source);
            String delim = StubUtility.getLineDelimiterUsed(result[0]);
            String[] sourceLines = Strings.convertIntoLines(source);
            String firstLine = sourceLines[0];
            if (!Character.isWhitespace(firstLine.charAt(0))) {
                sourceLines[0] = "";
            }
            Strings.trimIndentation(sourceLines, curr.getJavaScriptProject());
            if (!Character.isWhitespace(firstLine.charAt(0))) {
                sourceLines[0] = firstLine;
            }
            source = Strings.concatenate(sourceLines, delim);
            return source;
        }
        return null;
    }

    private String removeLeadingComments(String source) {
        int i;
        block16: {
            JavaCodeReader reader = new JavaCodeReader();
            Document document = new Document(source);
            try {
                try {
                    reader.configureForwardReader((IDocument)document, 0, document.getLength(), true, false);
                    int c = reader.read();
                    while (c != -1 && (c == 13 || c == 10)) {
                        c = reader.read();
                    }
                    i = reader.getOffset();
                    reader.close();
                }
                catch (IOException iOException) {
                    i = 0;
                    try {
                        if (reader != null) {
                            reader.close();
                        }
                        break block16;
                    }
                    catch (IOException ex) {
                        JavaScriptPlugin.log(ex);
                    }
                    break block16;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (IOException ex) {
                    JavaScriptPlugin.log(ex);
                }
                throw throwable;
            }
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException ex) {
                JavaScriptPlugin.log(ex);
            }
        }
        if (i < 0) {
            return source;
        }
        return source.substring(i);
    }

    @Override
    public IInformationControlCreator getHoverControlCreator() {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                IEditorPart editor = JavaSourceHover.this.getEditor();
                int shellStyle = 12;
                if (editor instanceof IWorkbenchPartOrientation) {
                    shellStyle |= ((IWorkbenchPartOrientation)editor).getOrientation();
                }
                return new SourceViewerInformationControl(parent, shellStyle, 0, EditorsUI.getTooltipAffordanceString());
            }
        };
    }

    public IInformationControlCreator getInformationPresenterControlCreator() {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                int style = 768;
                int shellStyle = 20;
                IEditorPart editor = JavaSourceHover.this.getEditor();
                if (editor instanceof IWorkbenchPartOrientation) {
                    shellStyle |= ((IWorkbenchPartOrientation)editor).getOrientation();
                }
                return new SourceViewerInformationControl(parent, shellStyle, style);
            }
        };
    }
}

