/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.ui.internal.contentassist;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.contentassist.ContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionList;
import org.eclipse.wst.xml.core.internal.contentmodel.CMAttributeDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMContent;
import org.eclipse.wst.xml.core.internal.contentmodel.CMElementDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMGroup;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNamedNodeMap;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNode;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNodeList;
import org.eclipse.wst.xml.core.internal.contentmodel.basic.CMNamedNodeMapImpl;
import org.eclipse.wst.xml.core.internal.modelquery.ModelQueryUtil;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xml.ui.internal.contentassist.AttributeContextInformation;
import org.eclipse.wst.xml.ui.internal.contentassist.AttributeContextInformationPresenter;
import org.eclipse.wst.xml.ui.internal.contentassist.ContextInfoModelUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class AttributeContextInformationProvider {
    private final IContextInformation[] EMPTY_CONTEXT_INFO = new IContextInformation[0];
    private Comparator fComparator;
    private IStructuredDocument fDocument = null;
    private ContextInfoModelUtil fModelUtil = null;

    public AttributeContextInformationProvider(IStructuredDocument doc, AttributeContextInformationPresenter presenter) {
        this.fDocument = doc;
        this.fModelUtil = new ContextInfoModelUtil(this.fDocument);
    }

    private boolean canProposeInfo(IStructuredDocumentRegion sdRegion) {
        return sdRegion == null || !this.isEndTag(sdRegion);
    }

    public IContextInformation[] getAttributeInformation(int offset) {
        IContextInformation[] results = this.EMPTY_CONTEXT_INFO;
        IStructuredDocumentRegion sdRegion = this.fModelUtil.getDocument().getRegionAtCharacterOffset(offset);
        if (!this.canProposeInfo(sdRegion)) {
            return this.EMPTY_CONTEXT_INFO;
        }
        IDOMNode node = this.fModelUtil.getXMLNode(offset);
        if (node != null) {
            switch (node.getNodeType()) {
                case 1: {
                    results = this.getInfoForElement(node);
                }
            }
        }
        return results;
    }

    private Comparator getCMAttributeComparator() {
        if (this.fComparator == null) {
            this.fComparator = new Comparator(){

                public int compare(Object o1, Object o2) {
                    return ((CMAttributeDeclaration)o1).getAttrName().compareTo(((CMAttributeDeclaration)o2).getAttrName());
                }
            };
        }
        return this.fComparator;
    }

    private IContextInformation[] getInfoForElement(IDOMNode node) {
        IContextInformation[] results = this.EMPTY_CONTEXT_INFO;
        CMElementDeclaration decl = this.fModelUtil.getModelQuery().getCMElementDeclaration((Element)node);
        if (decl != null) {
            CMNamedNodeMap attributes = decl.getAttributes();
            CMNamedNodeMapImpl allAttributes = new CMNamedNodeMapImpl(attributes);
            List nodes = ModelQueryUtil.getModelQuery((Document)node.getOwnerDocument()).getAvailableContent((Element)node, decl, 1);
            int k = 0;
            while (k < nodes.size()) {
                CMNode cmnode = (CMNode)nodes.get(k);
                if (cmnode.getNodeType() == 2) {
                    allAttributes.put(cmnode);
                }
                ++k;
            }
            attributes = allAttributes;
            String attrContextString = node.getNodeName();
            StringBuffer attrInfo = new StringBuffer(" ");
            String name = "";
            HashMap<String, Position> attrPosMap = new HashMap<String, Position>();
            int pos = 0;
            int length = 0;
            int numPerLine = 8;
            CMAttributeDeclaration[] sortedAttrs = this.getSortedAttributes(attributes);
            int i = 0;
            while (i < sortedAttrs.length) {
                name = sortedAttrs[i].getAttrName();
                length = name.length();
                pos = attrInfo.length();
                attrInfo.append(name);
                if (sortedAttrs[i].getUsage() == 2) {
                    attrInfo.append("*");
                    ++length;
                }
                if (i < attributes.getLength() - 1) {
                    attrInfo.append(" ");
                    if (i != 0 && i % numPerLine == 0) {
                        attrInfo.append("\n ");
                    }
                }
                attrPosMap.put(name, new Position(pos, length));
                ++i;
            }
            if (!attrInfo.toString().trim().equals("")) {
                return new IContextInformation[]{new AttributeContextInformation(attrContextString, attrInfo.toString(), attrPosMap)};
            }
        }
        return results;
    }

    IContextInformation[] getInfoForText(IDOMNode node) {
        CMElementDeclaration decl;
        CMContent content;
        Node parent = node.getParentNode();
        String contextString = node.getNodeName();
        StringBuffer info = new StringBuffer(" ");
        if (parent != null && parent.getNodeType() == 1 && (content = (decl = this.fModelUtil.getModelQuery().getCMElementDeclaration((Element)parent)).getContent()) instanceof CMGroup) {
            CMGroup cmGroup = (CMGroup)content;
            CMNodeList children = cmGroup.getChildNodes();
            CMNode cmNode = null;
            int i = 0;
            while (i < children.getLength()) {
                cmNode = children.item(i);
                contextString = cmNode.getNodeName();
                if (contextString != null) {
                    info.append("<" + cmNode.getNodeName() + ">");
                    if (i < children.getLength() - 1) {
                        info.append(" ");
                    }
                }
                ++i;
            }
        }
        if (!info.toString().trim().equals("")) {
            return new IContextInformation[]{new ContextInformation(contextString, info.toString())};
        }
        return this.EMPTY_CONTEXT_INFO;
    }

    private CMAttributeDeclaration[] getSortedAttributes(CMNamedNodeMap attributes) {
        ArrayList<CMNode> sorted = new ArrayList<CMNode>();
        int i = 0;
        while (i < attributes.getLength()) {
            sorted.add(attributes.item(i));
            ++i;
        }
        Collections.sort(sorted, this.getCMAttributeComparator());
        return sorted.toArray(new CMAttributeDeclaration[sorted.size()]);
    }

    private boolean isEndTag(IStructuredDocumentRegion sdRegion) {
        ITextRegionList regions = sdRegion.getRegions();
        return regions.get(0).getType() == "XML_END_TAG_OPEN";
    }
}

