/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.ui.internal.dialogs;

import java.util.Collection;
import java.util.List;
import java.util.Vector;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.wst.xml.core.internal.catalog.provisional.ICatalog;
import org.eclipse.wst.xml.core.internal.catalog.provisional.ICatalogEntry;
import org.eclipse.wst.xml.core.internal.catalog.provisional.INextCatalog;
import org.eclipse.wst.xml.ui.internal.XMLUIMessages;
import org.eclipse.wst.xml.ui.internal.dialogs.XMLCatalogTableViewer;

public class SelectXMLCatalogIdPanel
extends Composite {
    protected int catalogEntryType;
    protected boolean doTableSizeHack = false;
    protected XMLCatalogTableViewer tableViewer;
    protected ICatalog fXmlCatalog;

    public SelectXMLCatalogIdPanel(Composite parent, ICatalog xmlCatalog) {
        super(parent, 0);
        this.fXmlCatalog = xmlCatalog;
        GridLayout gridLayout = new GridLayout();
        this.setLayout((Layout)gridLayout);
        GridData gd = new GridData(1808);
        gd.heightHint = 200;
        gd.widthHint = 700;
        this.setLayoutData(gd);
        Label label = new Label((Composite)this, 0);
        label.setText(XMLUIMessages._UI_LABEL_XML_CATALOG_COLON);
        this.tableViewer = this.createTableViewer(this);
        this.tableViewer.getControl().setLayoutData((Object)new GridData(1808));
        this.tableViewer.setInput("dummy");
    }

    protected XMLCatalogTableViewer createTableViewer(Composite parent) {
        String[] headings = new String[]{XMLUIMessages._UI_LABEL_KEY, XMLUIMessages._UI_LABEL_URI};
        XMLCatalogTableViewer theTableViewer = new XMLCatalogTableViewer(parent, headings){

            protected void addXMLCatalogEntries(List list, ICatalogEntry[] entries) {
                int i = 0;
                while (i < entries.length) {
                    ICatalogEntry entry = entries[i];
                    if (SelectXMLCatalogIdPanel.this.catalogEntryType == 0) {
                        list.add(entry);
                    } else if (SelectXMLCatalogIdPanel.this.catalogEntryType == entry.getEntryType()) {
                        list.add(entry);
                    }
                    ++i;
                }
            }

            @Override
            public Collection getXMLCatalogEntries() {
                Vector<String> result = null;
                if (SelectXMLCatalogIdPanel.this.fXmlCatalog == null || SelectXMLCatalogIdPanel.this.doTableSizeHack) {
                    SelectXMLCatalogIdPanel.this.doTableSizeHack = false;
                    result = new Vector();
                    int i = 0;
                    while (i < 6) {
                        result.add("");
                        ++i;
                    }
                } else {
                    result = new Vector<String>();
                    this.processCatalog(result, SelectXMLCatalogIdPanel.this.fXmlCatalog);
                }
                return result;
            }

            private void processCatalog(List result, ICatalog catalog) {
                this.addXMLCatalogEntries(result, catalog.getCatalogEntries());
                INextCatalog[] nextCatalogs = catalog.getNextCatalogs();
                int i = 0;
                while (i < nextCatalogs.length) {
                    ICatalog nextCatalog = nextCatalogs[i].getReferencedCatalog();
                    if (nextCatalog != null) {
                        this.processCatalog(result, nextCatalog);
                    }
                    ++i;
                }
            }
        };
        return theTableViewer;
    }

    public String getId() {
        ICatalogEntry entry = this.getXMLCatalogEntry();
        return entry != null ? entry.getKey() : null;
    }

    public XMLCatalogTableViewer getTableViewer() {
        return this.tableViewer;
    }

    public String getURI() {
        ICatalogEntry entry = this.getXMLCatalogEntry();
        return entry != null ? entry.getURI() : null;
    }

    public ICatalogEntry getXMLCatalogEntry() {
        Object selectedObject;
        ICatalogEntry result = null;
        ISelection selection = this.tableViewer.getSelection();
        Object object = selectedObject = selection instanceof IStructuredSelection ? ((IStructuredSelection)selection).getFirstElement() : null;
        if (selectedObject instanceof ICatalogEntry) {
            result = (ICatalogEntry)selectedObject;
        }
        return result;
    }

    public void setCatalogEntryType(int catalogEntryType) {
        this.catalogEntryType = catalogEntryType;
        this.tableViewer.refresh();
    }
}

