/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xsd.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.EObjectEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.xsd.XSDAnnotation;
import org.eclipse.xsd.XSDAttributeGroupDefinition;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDDiagnosticSeverity;
import org.eclipse.xsd.XSDFactory;
import org.eclipse.xsd.XSDModelGroupDefinition;
import org.eclipse.xsd.XSDPackage;
import org.eclipse.xsd.XSDParticle;
import org.eclipse.xsd.XSDRedefinableComponent;
import org.eclipse.xsd.XSDRedefine;
import org.eclipse.xsd.XSDRedefineContent;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDTypeDefinition;
import org.eclipse.xsd.impl.XSDComplexTypeDefinitionImpl;
import org.eclipse.xsd.impl.XSDConcreteComponentImpl;
import org.eclipse.xsd.impl.XSDParticleImpl;
import org.eclipse.xsd.impl.XSDRedefineContentImpl;
import org.eclipse.xsd.impl.XSDSchemaCompositorImpl;
import org.eclipse.xsd.impl.XSDSchemaImpl;
import org.eclipse.xsd.util.XSDConstants;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XSDRedefineImpl
extends XSDSchemaCompositorImpl
implements XSDRedefine {
    protected EList<XSDAnnotation> annotations;
    protected EList<XSDRedefineContent> contents;

    public static XSDRedefine createRedefine(Node node) {
        if (XSDConstants.nodeType(node) == 31) {
            XSDRedefine xsdRedefine = XSDFactory.eINSTANCE.createXSDRedefine();
            xsdRedefine.setElement((Element)node);
            return xsdRedefine;
        }
        return null;
    }

    protected XSDRedefineImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return XSDPackage.Literals.XSD_REDEFINE;
    }

    @Override
    public EList<XSDAnnotation> getAnnotations() {
        if (this.annotations == null) {
            this.annotations = new EObjectEList(XSDAnnotation.class, (InternalEObject)this, 8);
        }
        return this.annotations;
    }

    @Override
    public EList<XSDRedefineContent> getContents() {
        if (this.contents == null) {
            this.contents = new EObjectContainmentEList(XSDRedefineContent.class, (InternalEObject)this, 9);
        }
        return this.contents;
    }

    @Override
    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 9: {
                return ((InternalEList)this.getContents()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 8: {
                return this.getAnnotations();
            }
            case 9: {
                return this.getContents();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 8: {
                this.getAnnotations().clear();
                this.getAnnotations().addAll((Collection)newValue);
                return;
            }
            case 9: {
                this.getContents().clear();
                this.getContents().addAll((Collection)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 8: {
                this.getAnnotations().clear();
                return;
            }
            case 9: {
                this.getContents().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 8: {
                return this.annotations != null && !this.annotations.isEmpty();
            }
            case 9: {
                return this.contents != null && !this.contents.isEmpty();
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public Element createElement() {
        Element newElement = this.createElement(31);
        this.setElement(newElement);
        for (XSDRedefineContent xsdRedefineContent : this.getContents()) {
            Element contentElement = ((XSDConcreteComponentImpl)((Object)xsdRedefineContent)).createElement();
            newElement.appendChild(contentElement);
        }
        return newElement;
    }

    @Override
    protected void patch() {
        if (this.getSchemaLocation() != null && this.getSchemaLocation().length() > 0) {
            XSDSchemaImpl containingSchema = (XSDSchemaImpl)this.getContainer();
            String oldPendingSchemaLocation = containingSchema.pendingSchemaLocation;
            if (containingSchema.getSchemaLocation() != null) {
                containingSchema.pendingSchemaLocation = containingSchema.getSchemaLocation();
            }
            this.resolve("", this.getSchemaLocation());
            containingSchema.pendingSchemaLocation = oldPendingSchemaLocation;
            super.patch();
            if (oldPendingSchemaLocation == null) {
                List<XSDSchemaImpl> redefinitions = containingSchema.getSchemasToRedefine();
                containingSchema.schemasToRedefine = null;
                for (XSDSchemaImpl schemaToRedefine : redefinitions) {
                    if (schemaToRedefine == containingSchema) continue;
                    schemaToRedefine.forceResolve = true;
                    schemaToRedefine.setSchemaLocation(schemaToRedefine.pendingSchemaLocation);
                    schemaToRedefine.forceResolve = false;
                    schemaToRedefine.pendingSchemaLocation = null;
                }
            }
        } else {
            super.patch();
        }
    }

    @Override
    protected void handleResolvedSchema(XSDSchema xsdSchema) {
        if (xsdSchema == null) {
            this.setResolvedSchema(null);
            this.setIncorporatedSchema(null);
        } else {
            ((XSDSchemaImpl)xsdSchema).redefined(this);
        }
    }

    @Override
    public void validate() {
        super.validate();
        Element theElement = this.getElement();
        if (theElement != null) {
            this.checkAttributes("http://www.w3.org/TR/xmlschema-1/", "element-redefine", theElement, new String[]{"id", "schemaLocation"});
            XSDComplexTypeDefinition xsdComplexTypeDefinition = (XSDComplexTypeDefinition)this.getSchema().getSchemaForSchema().resolveElementDeclaration("redefine").getTypeDefinition();
            this.checkComplexContent(xsdComplexTypeDefinition, "http://www.w3.org/TR/xmlschema-1/", "element-redefine", theElement);
            this.checkBuiltInTypeConstraint("ID", null, "http://www.w3.org/TR/xmlschema-1/", "element-redefine", theElement, "id", false);
        }
        this.checkBuiltInTypeConstraint("anyURI", this.getSchemaLocation(), "http://www.w3.org/TR/xmlschema-1/", "element-redefine", theElement, "schemaLocation", true);
        XSDSchema theResolvedSchema = this.getResolvedSchema();
        if (theResolvedSchema == null) {
            boolean hasRedefinitions = false;
            for (XSDRedefineContent content : this.getContents()) {
                if (content instanceof XSDAnnotation) continue;
                hasRedefinitions = true;
                break;
            }
            if (hasRedefinitions) {
                this.createDiagnostic(XSDDiagnosticSeverity.ERROR_LITERAL, "src-redefine.1", this.getSchemaLocation() == null ? "" : this.getSchemaLocation());
            } else {
                this.createDiagnostic(XSDDiagnosticSeverity.WARNING_LITERAL, "src-redefine.0", this.getSchemaLocation() == null ? "" : this.getSchemaLocation());
            }
        } else if (theResolvedSchema.eResource() == null || theResolvedSchema.getElement() == null || XSDConstants.nodeType(theResolvedSchema.getElement()) != 33) {
            this.createDiagnostic(XSDDiagnosticSeverity.ERROR_LITERAL, "src-redefine.2", this.getSchemaLocation() == null ? "" : this.getSchemaLocation());
        } else {
            XSDSchema theSchema = this.getSchema();
            if (theSchema.getTargetNamespace() == null ? theResolvedSchema.getTargetNamespace() != null : !theSchema.getTargetNamespace().equals(theResolvedSchema.getTargetNamespace()) && theResolvedSchema.getTargetNamespace() != null) {
                this.createDiagnostic(XSDDiagnosticSeverity.ERROR_LITERAL, "src-redefine.3", theResolvedSchema.getTargetNamespace() == null ? "" : theResolvedSchema.getTargetNamespace(), theSchema.getTargetNamespace() == null ? "" : theSchema.getTargetNamespace());
            } else {
                for (XSDRedefineContent xsdRedefineContent : this.getContents()) {
                    Object component;
                    Object j;
                    ArrayList<XSDRedefinableComponent> selfReferences;
                    if (xsdRedefineContent instanceof XSDTypeDefinition) {
                        XSDTypeDefinition xsdTypeDefinition = (XSDTypeDefinition)xsdRedefineContent;
                        XSDTypeDefinition baseType = xsdTypeDefinition.getBaseType();
                        if (baseType != null && baseType.hasSameNameAndTargetNamespace(xsdTypeDefinition) && this.resolveTypeDefinition(xsdTypeDefinition.getName()).getContainer() != null) continue;
                        this.getDiagnosticTarget(xsdTypeDefinition).createDiagnostic(XSDDiagnosticSeverity.ERROR_LITERAL, "src-redefine.5", xsdTypeDefinition.getName());
                        continue;
                    }
                    if (xsdRedefineContent instanceof XSDModelGroupDefinition) {
                        XSDModelGroupDefinition xsdModelGroupDefinition = (XSDModelGroupDefinition)xsdRedefineContent;
                        selfReferences = new ArrayList<XSDRedefinableComponent>();
                        j = xsdModelGroupDefinition.eAllContents();
                        while (j.hasNext()) {
                            XSDModelGroupDefinition otherXSDModelGroupDefinition;
                            component = j.next();
                            if (!(component instanceof XSDModelGroupDefinition) || !xsdModelGroupDefinition.hasSameNameAndTargetNamespace((otherXSDModelGroupDefinition = (XSDModelGroupDefinition)component).getResolvedModelGroupDefinition())) continue;
                            selfReferences.add(otherXSDModelGroupDefinition);
                        }
                        if (selfReferences.isEmpty()) {
                            XSDModelGroupDefinition otherXSDModelGroupDefinition = (XSDModelGroupDefinition)((XSDSchemaImpl)this.getContainer()).getRedefinitionMap().get(xsdModelGroupDefinition);
                            if (otherXSDModelGroupDefinition == null || otherXSDModelGroupDefinition.getContainer() == null) {
                                ((XSDConcreteComponentImpl)((Object)xsdModelGroupDefinition)).createDiagnostic(XSDDiagnosticSeverity.ERROR_LITERAL, "src-redefine.6.2.1", xsdModelGroupDefinition.getName());
                                continue;
                            }
                            XSDParticle xsdParticle = XSDFactory.eINSTANCE.createXSDParticle();
                            xsdParticle.setTerm(xsdModelGroupDefinition.getModelGroup());
                            XSDParticle otherXSDParticle = XSDFactory.eINSTANCE.createXSDParticle();
                            otherXSDParticle.setTerm(otherXSDModelGroupDefinition.getModelGroup());
                            if (((XSDParticleImpl)xsdParticle).isSubset(otherXSDParticle, true)) continue;
                            ((XSDConcreteComponentImpl)((Object)xsdModelGroupDefinition)).createDiagnostic(XSDDiagnosticSeverity.ERROR_LITERAL, "src-redefine.6.2.2");
                            continue;
                        }
                        j = selfReferences.iterator();
                        XSDModelGroupDefinition otherXSDModelGroupDefinition = (XSDModelGroupDefinition)j.next();
                        XSDParticle xsdParticle = (XSDParticle)otherXSDModelGroupDefinition.getContainer();
                        if (xsdParticle.getMinOccurs() != 1 || xsdParticle.getMaxOccurs() != 1) {
                            ((XSDConcreteComponentImpl)((Object)xsdParticle)).createDiagnostic(XSDDiagnosticSeverity.ERROR_LITERAL, "src-redefine.6.1.2");
                        }
                        while (j.hasNext()) {
                            XSDConcreteComponentImpl xsdConcreteComponent = (XSDConcreteComponentImpl)j.next();
                            xsdConcreteComponent.createDiagnostic(XSDDiagnosticSeverity.ERROR_LITERAL, "src-redefine.6.1.1");
                        }
                        continue;
                    }
                    if (!(xsdRedefineContent instanceof XSDAttributeGroupDefinition)) continue;
                    XSDAttributeGroupDefinition xsdAttributeGroupDefinition = (XSDAttributeGroupDefinition)xsdRedefineContent;
                    selfReferences = new ArrayList();
                    j = xsdAttributeGroupDefinition.eAllContents();
                    while (j.hasNext()) {
                        XSDAttributeGroupDefinition otherXSDAttributeGroupDefinition;
                        component = j.next();
                        if (!(component instanceof XSDAttributeGroupDefinition) || !xsdAttributeGroupDefinition.hasSameNameAndTargetNamespace((otherXSDAttributeGroupDefinition = (XSDAttributeGroupDefinition)component).getResolvedAttributeGroupDefinition())) continue;
                        selfReferences.add(otherXSDAttributeGroupDefinition);
                    }
                    if (selfReferences.isEmpty()) {
                        XSDAttributeGroupDefinition otherXSDAttributeGroupDefinition = (XSDAttributeGroupDefinition)((XSDSchemaImpl)this.getContainer()).getRedefinitionMap().get(xsdAttributeGroupDefinition);
                        if (otherXSDAttributeGroupDefinition == null || otherXSDAttributeGroupDefinition.getContainer() == null) {
                            ((XSDConcreteComponentImpl)((Object)xsdAttributeGroupDefinition)).createDiagnostic(XSDDiagnosticSeverity.ERROR_LITERAL, "src-redefine.7.2.1", xsdAttributeGroupDefinition.getName());
                            continue;
                        }
                        XSDComplexTypeDefinitionImpl.validateAttributeGroup((XSDConcreteComponentImpl)((Object)xsdAttributeGroupDefinition), xsdAttributeGroupDefinition.getAttributeWildcardContent(), otherXSDAttributeGroupDefinition.getAttributeUses(), xsdAttributeGroupDefinition.getAttributeUses(), otherXSDAttributeGroupDefinition.getAttributeWildcard(), xsdAttributeGroupDefinition.getAttributeWildcard());
                        continue;
                    }
                    j = selfReferences.iterator();
                    j.next();
                    while (j.hasNext()) {
                        XSDConcreteComponentImpl xsdConcreteComponent = (XSDConcreteComponentImpl)j.next();
                        xsdConcreteComponent.createDiagnostic(XSDDiagnosticSeverity.ERROR_LITERAL, "src-redefine.7.1");
                    }
                }
            }
        }
    }

    @Override
    protected void handleUnreconciledElement(Element child, List<XSDConcreteComponent> newContents, List<XSDConcreteComponent> remainingContents) {
        XSDRedefineContent xsdRedefineContent = XSDRedefineContentImpl.createRedefineContent(child);
        if (xsdRedefineContent != null) {
            newContents.add(xsdRedefineContent);
        }
    }

    @Override
    protected void handleReconciliation(List<XSDConcreteComponent> newContents, List<XSDConcreteComponent> remainingContents) {
        if (!remainingContents.isEmpty()) {
            this.getContents().removeAll(remainingContents);
        }
        List<XSDConcreteComponent> list = newContents;
        XSDRedefineImpl.setListContentAndOrder(this.getContents(), list);
    }

    @Override
    protected void adoptContent(EReference eReference, XSDConcreteComponent xsdConcreteComponent) {
        super.adoptContent(eReference, xsdConcreteComponent);
        if (xsdConcreteComponent instanceof XSDAnnotation) {
            this.getAnnotations().add((Object)((XSDAnnotation)xsdConcreteComponent));
        }
    }

    @Override
    protected void orphanContent(EReference eReference, XSDConcreteComponent xsdConcreteComponent) {
        super.orphanContent(eReference, xsdConcreteComponent);
        if (xsdConcreteComponent instanceof XSDAnnotation) {
            this.getAnnotations().remove((Object)xsdConcreteComponent);
        }
    }

    @Override
    public XSDConcreteComponent cloneConcreteComponent(boolean deep, boolean shareDOM) {
        XSDRedefineImpl clonedRedefine = (XSDRedefineImpl)this.getXSDFactory().createXSDRedefine();
        clonedRedefine.isReconciling = true;
        clonedRedefine.setSchemaLocation(this.getSchemaLocation());
        if (deep && !this.getContents().isEmpty()) {
            clonedRedefine.getContents().addAll(XSDRedefineImpl.cloneConcreteComponents(this.getContents(), true, shareDOM));
        }
        if (shareDOM && this.getElement() != null) {
            clonedRedefine.setElement(this.getElement());
        }
        clonedRedefine.isReconciling = shareDOM;
        return clonedRedefine;
    }
}

