/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.types;

import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.types.TType;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.types.TypeEnvironment;

public abstract class AbstractTypeVariable
extends TType {
    protected TType[] fBounds;

    protected AbstractTypeVariable(TypeEnvironment environment) {
        super(environment);
    }

    @Override
    protected void initialize(ITypeBinding binding) {
        super.initialize(binding);
        this.fBounds = EMPTY_TYPE_ARRAY;
        if (this.getEnvironment().getJavaLangObject() == null) {
            this.getEnvironment().initializeJavaLangObject(binding.getErasure());
        }
    }

    @Override
    public TType getErasure() {
        if (this.fBounds.length == 0) {
            return this.getEnvironment().getJavaLangObject();
        }
        return this.fBounds[0].getErasure();
    }

    final boolean isUnbounded() {
        if (this.fBounds.length == 0) {
            return true;
        }
        return this.fBounds[0].isJavaLangObject();
    }

    public final TType[] getBounds() {
        return (TType[])this.fBounds.clone();
    }

    @Override
    public final TType[] getSubTypes() {
        return EMPTY_TYPE_ARRAY;
    }

    protected final boolean checkAssignmentBound(TType rhs) {
        if (this.fBounds.length == 0) {
            return true;
        }
        int i = 0;
        while (i < this.fBounds.length) {
            if (rhs.canAssignTo(this.fBounds[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected final boolean canAssignOneBoundTo(TType lhs) {
        if (this.fBounds.length == 0) {
            return lhs.isJavaLangObject();
        }
        int i = 0;
        while (i < this.fBounds.length) {
            if (this.fBounds[i].canAssignTo(lhs)) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

