/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.keys.IBindingService;
import org.eclipse.wst.jsdt.internal.ui.actions.ActionMessages;
import org.eclipse.wst.jsdt.internal.ui.actions.SurroundWithTemplateMenuAction;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.CompilationUnitEditor;

public class SurroundWithActionGroup
extends ActionGroup {
    private CompilationUnitEditor fEditor;
    private final String fGroup;

    public SurroundWithActionGroup(CompilationUnitEditor editor, String group) {
        this.fEditor = editor;
        this.fGroup = group;
    }

    public void fillActionBars(IActionBars actionBar) {
    }

    public void fillContextMenu(IMenuManager menu) {
        ISelectionProvider selectionProvider = this.fEditor.getSelectionProvider();
        if (selectionProvider == null) {
            return;
        }
        ISelection selection = selectionProvider.getSelection();
        if (!(selection instanceof ITextSelection)) {
            return;
        }
        ITextSelection textSelection = (ITextSelection)selection;
        if (textSelection.getLength() == 0) {
            return;
        }
        String menuText = ActionMessages.SurroundWithTemplateMenuAction_SurroundWithTemplateSubMenuName;
        String shortcutString = this.getShortcutString();
        if (shortcutString != null) {
            menuText = String.valueOf(menuText) + '\t' + shortcutString;
        }
        MenuManager subMenu = new MenuManager(menuText, "org.eclipse.wst.jsdt.ui.edit.text.java.surround.with.quickMenu");
        menu.appendToGroup(this.fGroup, (IContributionItem)subMenu);
        subMenu.add((IAction)new Action(){});
        subMenu.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                manager.removeAll();
                SurroundWithTemplateMenuAction.fillMenu(manager, SurroundWithActionGroup.this.fEditor);
            }
        });
    }

    private String getShortcutString() {
        IBindingService bindingService = (IBindingService)PlatformUI.getWorkbench().getAdapter(IBindingService.class);
        if (bindingService == null) {
            return null;
        }
        return bindingService.getBestActiveBindingFormattedFor("org.eclipse.wst.jsdt.ui.edit.text.java.surround.with.quickMenu");
    }
}

