/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.fix;

import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.dom.JavaScriptUnit;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.wst.jsdt.internal.corext.fix.IFix;
import org.eclipse.wst.jsdt.internal.corext.fix.ImportsFix;
import org.eclipse.wst.jsdt.internal.ui.fix.AbstractCleanUp;
import org.eclipse.wst.jsdt.internal.ui.fix.MultiFixMessages;
import org.eclipse.wst.jsdt.internal.ui.preferences.JavaPreferencesSettings;
import org.eclipse.wst.jsdt.ui.text.java.IProblemLocation;

public class ImportsCleanUp
extends AbstractCleanUp {
    private CodeGenerationSettings fCodeGeneratorSettings;
    private RefactoringStatus fStatus;

    public ImportsCleanUp(Map options) {
        super(options);
    }

    public ImportsCleanUp() {
    }

    @Override
    public boolean requireAST(IJavaScriptUnit unit) throws CoreException {
        return this.isEnabled("cleanup.organize_imports");
    }

    @Override
    public IFix createFix(JavaScriptUnit compilationUnit) throws CoreException {
        return ImportsFix.createCleanUp(compilationUnit, this.fCodeGeneratorSettings, this.isEnabled("cleanup.organize_imports"), this.fStatus);
    }

    @Override
    public IFix createFix(JavaScriptUnit compilationUnit, IProblemLocation[] problems) throws CoreException {
        return null;
    }

    @Override
    public RefactoringStatus checkPreConditions(IJavaScriptProject project, IJavaScriptUnit[] compilationUnits, IProgressMonitor monitor) throws CoreException {
        RefactoringStatus result = super.checkPreConditions(project, compilationUnits, monitor);
        if (this.isEnabled("cleanup.organize_imports")) {
            this.fCodeGeneratorSettings = JavaPreferencesSettings.getCodeGenerationSettings(project);
            this.fStatus = new RefactoringStatus();
        }
        return result;
    }

    @Override
    public RefactoringStatus checkPostConditions(IProgressMonitor monitor) throws CoreException {
        this.fCodeGeneratorSettings = null;
        if (this.fStatus == null || this.fStatus.isOK()) {
            return super.checkPostConditions(monitor);
        }
        return this.fStatus;
    }

    @Override
    public String[] getDescriptions() {
        if (this.isEnabled("cleanup.organize_imports")) {
            return new String[]{MultiFixMessages.ImportsCleanUp_OrganizeImports_Description};
        }
        return null;
    }

    @Override
    public String getPreview() {
        StringBuffer buf = new StringBuffer();
        return buf.toString();
    }

    @Override
    public Map getRequiredOptions() {
        return null;
    }

    @Override
    public int maximalNumberOfFixes(JavaScriptUnit compilationUnit) {
        return -1;
    }

    @Override
    public boolean needsFreshAST(JavaScriptUnit compilationUnit) {
        if (this.isEnabled("cleanup.organize_imports")) {
            return true;
        }
        return super.needsFreshAST(compilationUnit);
    }

    @Override
    public boolean canFix(JavaScriptUnit compilationUnit, IProblemLocation problem) throws CoreException {
        return false;
    }
}

