/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.javaeditor.saveparticipant;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.dialogs.ControlEnableState;
import org.eclipse.jface.preference.IPreferencePageContainer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.saveparticipant.ISaveParticipantPreferenceConfiguration;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.SelectionButtonDialogField;

public abstract class AbstractSaveParticipantPreferenceConfiguration
implements ISaveParticipantPreferenceConfiguration {
    private static final String EDITOR_SAVE_PARTICIPANT_PREFIX = "editor_save_participant_";
    private SelectionButtonDialogField fEnableField;
    private Control fConfigControl;
    private IScopeContext fContext;
    private ControlEnableState fConfigControlEnabledState;

    protected abstract String getPostSaveListenerId();

    protected abstract String getPostSaveListenerName();

    protected Control createConfigControl(Composite composite, IPreferencePageContainer container) {
        return null;
    }

    @Override
    public Control createControl(Composite parent, IPreferencePageContainer container) {
        Composite composite = new Composite(parent, 0);
        GridData gridData = new GridData(4, 128, true, false);
        composite.setLayoutData((Object)gridData);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        this.fEnableField = new SelectionButtonDialogField(32);
        this.fEnableField.setLabelText(this.getPostSaveListenerName());
        this.fEnableField.doFillIntoGrid(composite, 1);
        this.fConfigControl = this.createConfigControl(composite, container);
        return composite;
    }

    @Override
    public void initialize(IScopeContext context, IAdaptable element) {
        boolean enabled = this.isEnabled(context);
        this.fEnableField.setSelection(enabled);
        if (this.fConfigControl != null && !enabled) {
            this.fConfigControlEnabledState = ControlEnableState.disable((Control)this.fConfigControl);
        }
        this.fEnableField.setDialogFieldListener(new IDialogFieldListener(){

            @Override
            public void dialogFieldChanged(DialogField field) {
                AbstractSaveParticipantPreferenceConfiguration.this.enableConfigControl(AbstractSaveParticipantPreferenceConfiguration.this.fEnableField.isSelected());
            }
        });
        this.fContext = context;
    }

    @Override
    public void dispose() {
    }

    @Override
    public void performDefaults() {
        String key = this.getPreferenceKey();
        boolean defaultEnabled = new DefaultScope().getNode("org.eclipse.wst.jsdt.ui").getBoolean(key, false);
        this.fContext.getNode("org.eclipse.wst.jsdt.ui").putBoolean(key, defaultEnabled);
        this.fEnableField.setSelection(defaultEnabled);
    }

    @Override
    public void performOk() {
    }

    @Override
    public void enableProjectSettings() {
        this.fContext.getNode("org.eclipse.wst.jsdt.ui").putBoolean(this.getPreferenceKey(), this.fEnableField.isSelected());
    }

    @Override
    public void disableProjectSettings() {
        this.fContext.getNode("org.eclipse.wst.jsdt.ui").remove(this.getPreferenceKey());
    }

    @Override
    public boolean hasSettingsInScope(IScopeContext context) {
        return context.getNode("org.eclipse.wst.jsdt.ui").get(this.getPreferenceKey(), null) != null;
    }

    @Override
    public boolean isEnabled(IScopeContext context) {
        IEclipsePreferences node = this.hasSettingsInScope(context) ? context.getNode("org.eclipse.wst.jsdt.ui") : new InstanceScope().getNode("org.eclipse.wst.jsdt.ui");
        IEclipsePreferences defaultNode = new DefaultScope().getNode("org.eclipse.wst.jsdt.ui");
        String key = this.getPreferenceKey();
        return node.getBoolean(key, defaultNode.getBoolean(key, false));
    }

    protected void enableConfigControl(boolean isEnabled) {
        this.fContext.getNode("org.eclipse.wst.jsdt.ui").putBoolean(this.getPreferenceKey(), isEnabled);
        if (this.fConfigControl != null) {
            if (this.fConfigControlEnabledState != null) {
                this.fConfigControlEnabledState.restore();
                this.fConfigControlEnabledState = null;
            } else {
                this.fConfigControlEnabledState = ControlEnableState.disable((Control)this.fConfigControl);
            }
        }
    }

    private String getPreferenceKey() {
        return EDITOR_SAVE_PARTICIPANT_PREFIX + this.getPostSaveListenerId();
    }
}

