/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.analysis.xml.ui.swtbot.tests.latency;

import org.eclipse.swt.widgets.Control;
import org.eclipse.swtbot.eclipse.finder.widgets.SWTBotView;
import org.eclipse.swtbot.swt.finder.SWTBotAssert;
import org.eclipse.swtbot.swt.finder.exceptions.WidgetNotFoundException;
import org.eclipse.swtbot.swt.finder.junit.SWTBotJunit4ClassRunner;
import org.eclipse.swtbot.swt.finder.widgets.AbstractSWTBot;
import org.eclipse.swtbot.swt.finder.widgets.AbstractSWTBotControl;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTreeItem;
import org.eclipse.swtchart.Chart;
import org.eclipse.swtchart.ISeries;
import org.eclipse.swtchart.ISeriesSet;
import org.eclipse.swtchart.Range;
import org.eclipse.swtchart.model.IndexedSeriesModel;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.ui.views.latency.PatternScatterGraphView;
import org.eclipse.tracecompass.tmf.analysis.xml.ui.swtbot.tests.latency.PatternLatencyViewTestBase;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared.ConditionHelpers;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared.SWTBotUtils;
import org.eclipse.tracecompass.tmf.ui.tests.shared.WaitUtils;
import org.eclipse.tracecompass.tmf.ui.viewers.xychart.TmfXYChartViewer;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=SWTBotJunit4ClassRunner.class)
public class PatternScatterChartViewTest
extends PatternLatencyViewTestBase {
    private static final String VIEW_ID = "org.eclipse.tracecompass.internal.tmf.analysis.xml.ui.views.scattergraph";
    private static final String VIEW_TITLE = "Latency vs Time";
    private Chart fScatterChart;

    private TmfXYChartViewer getChartViewer() {
        SWTBotView viewBot = fBot.viewById(VIEW_ID);
        PatternScatterGraphView viewPart = (PatternScatterGraphView)viewBot.getViewReference().getView(true);
        TmfXYChartViewer chartViewer = viewPart.getChartViewer();
        this.fScatterChart = chartViewer.getSwtChart();
        return chartViewer;
    }

    @Test
    public void testWithTrace() {
        SWTBotTreeItem[] items;
        WaitUtils.waitForJobs();
        TmfXYChartViewer chartViewer = this.getChartViewer();
        Assert.assertNotNull((Object)chartViewer);
        fBot.waitUntil(ConditionHelpers.xyViewerIsReadyCondition((TmfXYChartViewer)chartViewer));
        Chart chart = this.fScatterChart;
        Assert.assertNotNull((Object)chart);
        SWTBotView viewBot = fBot.viewById(VIEW_ID);
        SWTBotTreeItem[] sWTBotTreeItemArray = items = viewBot.bot().tree().getAllItems();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            SWTBotTreeItem item = sWTBotTreeItemArray[n2];
            item.check();
            ++n2;
        }
        SWTBotUtils.waitUntil(c -> c.getSeriesSet().getSeries().length > 0, (Object)chart, (String)"No data available");
        SWTBotChart chartBot = new SWTBotChart(chart);
        SWTBotAssert.assertVisible((AbstractSWTBot)chartBot);
        Range range = chart.getAxisSet().getXAxes()[0].getRange();
        Assert.assertEquals((double)1.0E8, (double)(range.upper - range.lower), (double)0.0);
        ISeriesSet seriesSet = this.fScatterChart.getSeriesSet();
        Assert.assertNotNull((Object)seriesSet);
        ISeries[] series = seriesSet.getSeries();
        Assert.assertNotNull((Object)series);
        Assert.assertTrue((series.length > 1 ? 1 : 0) != 0);
        int i = 0;
        while (i < series.length) {
            Assert.assertTrue((String)("Verifying series " + i), (((IndexedSeriesModel)series[i].getDataModel()).size() > 0 ? 1 : 0) != 0);
            ++i;
        }
    }

    @Override
    protected String getViewId() {
        return VIEW_ID;
    }

    @Override
    protected String getViewTitle() {
        return VIEW_TITLE;
    }

    private static class SWTBotChart
    extends AbstractSWTBotControl<Chart> {
        public SWTBotChart(Chart w) throws WidgetNotFoundException {
            super((Control)w);
        }
    }
}

