/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.tests.analysis.requirements;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.tmf.core.analysis.requirements.TmfAbstractAnalysisRequirement;
import org.eclipse.tracecompass.tmf.tests.stubs.analysis.AnalysisRequirementFactory;
import org.junit.Assert;
import org.junit.Test;

public class AnalysisRequirementTest {
    private static final @NonNull String VALUE_A = "Test Value A";
    private static final @NonNull String VALUE_B = "Test Value B";
    private static final @NonNull String INFO_A = "This is an information.";
    private static final @NonNull String INFO_B = "This is another information.";

    @Test
    public void testAddAndGetInformation() {
        AnalysisRequirementFactory.TmfRequirementStub requirement = new AnalysisRequirementFactory.TmfRequirementStub(Collections.EMPTY_SET, TmfAbstractAnalysisRequirement.PriorityLevel.OPTIONAL);
        requirement.addInformation(INFO_A);
        requirement.addInformation(INFO_B);
        requirement.addInformation(INFO_B);
        Set information = requirement.getInformation();
        Assert.assertEquals((long)2L, (long)information.size());
        Assert.assertTrue((boolean)information.contains(INFO_A));
        Assert.assertTrue((boolean)information.contains(INFO_B));
    }

    @Test
    public void testGetValueLevel() {
        AnalysisRequirementFactory.TmfRequirementStub requirement = new AnalysisRequirementFactory.TmfRequirementStub(Collections.EMPTY_SET, TmfAbstractAnalysisRequirement.PriorityLevel.OPTIONAL);
        Assert.assertEquals((Object)TmfAbstractAnalysisRequirement.PriorityLevel.OPTIONAL, (Object)requirement.getPriorityLevel());
        requirement = new AnalysisRequirementFactory.TmfRequirementStub(Collections.EMPTY_SET, TmfAbstractAnalysisRequirement.PriorityLevel.ALL_OR_NOTHING);
        Assert.assertEquals((Object)TmfAbstractAnalysisRequirement.PriorityLevel.ALL_OR_NOTHING, (Object)requirement.getPriorityLevel());
        requirement = new AnalysisRequirementFactory.TmfRequirementStub(Collections.EMPTY_SET, TmfAbstractAnalysisRequirement.PriorityLevel.AT_LEAST_ONE);
        Assert.assertEquals((Object)TmfAbstractAnalysisRequirement.PriorityLevel.AT_LEAST_ONE, (Object)requirement.getPriorityLevel());
        requirement = new AnalysisRequirementFactory.TmfRequirementStub(Collections.EMPTY_SET, TmfAbstractAnalysisRequirement.PriorityLevel.MANDATORY);
        Assert.assertEquals((Object)TmfAbstractAnalysisRequirement.PriorityLevel.MANDATORY, (Object)requirement.getPriorityLevel());
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Test
    public void testGetValues() {
        @NonNull ImmutableSet values = ImmutableSet.of((Object)VALUE_A, (Object)VALUE_B);
        AnalysisRequirementFactory.TmfRequirementStub requirement = new AnalysisRequirementFactory.TmfRequirementStub((Collection<String>)values, TmfAbstractAnalysisRequirement.PriorityLevel.OPTIONAL);
        Assert.assertEquals((Object)values, (Object)requirement.getValues());
    }
}

